/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.EnumMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.block.DynamicRenderedItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BuntingBlock;
import net.mehvahdjukaar.supplementaries.common.items.BuntingItem;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2754;

public class BuntingBlockTile
extends DynamicRenderedItemDisplayTile {
    public static final ModelDataKey<class_1767> NORTH_BUNTING = new ModelDataKey(class_1767.class);
    public static final ModelDataKey<class_1767> SOUTH_BUNTING = new ModelDataKey(class_1767.class);
    public static final ModelDataKey<class_1767> EAST_BUNTING = new ModelDataKey(class_1767.class);
    public static final ModelDataKey<class_1767> WEST_BUNTING = new ModelDataKey(class_1767.class);
    private final Map<class_2350, class_1767> buntings = new EnumMap<class_2350, class_1767>(class_2350.class);

    public BuntingBlockTile(class_2338 pos, class_2680 state) {
        super(null, pos, state, 4);
    }

    public class_238 getRenderBoundingBox() {
        return new class_238(this.field_11867);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43470((String)"Bunting");
    }

    public void updateClientVisualsOnLoad() {
        this.buntings.clear();
        for (class_2350 d : class_2350.class_2353.field_11062) {
            class_1767 color;
            class_1799 stack = this.method_5438(d.method_10161());
            if (!(stack.method_7909() instanceof BuntingItem) || (color = BuntingItem.getColor(stack)) == null) continue;
            this.buntings.put(d, color);
        }
        if (this.buntings.isEmpty()) {
            Supplementaries.error();
        }
        this.requestModelReload();
    }

    public void updateTileOnInventoryChanged() {
        class_2680 state = this.method_11010();
        if (this.method_5442()) {
            this.field_11863.method_8501(this.field_11867, BuntingBlock.toRope(state));
        } else {
            class_2680 state2 = state;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2754<ModBlockProperties.Bunting> prop = BuntingBlock.HORIZONTAL_FACING_TO_PROPERTY_MAP.get(dir);
                ModBlockProperties.Bunting old = (ModBlockProperties.Bunting)((Object)state2.method_11654(prop));
                boolean isEmpty = this.method_5438(dir.method_10161()).method_7960();
                state2 = (class_2680)state2.method_11657(prop, (Comparable)((Object)(isEmpty ? (old == ModBlockProperties.Bunting.NONE ? ModBlockProperties.Bunting.NONE : ModBlockProperties.Bunting.ROPE) : ModBlockProperties.Bunting.BUNTING)));
            }
            if (state != state2) {
                this.field_11863.method_8501(this.field_11867, state2);
            }
        }
    }

    public boolean needsToUpdateClientWhenChanged() {
        return false;
    }

    public Map<class_2350, class_1767> getBuntings() {
        return this.buntings;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return stack.method_7909() instanceof BuntingItem && this.method_5438(index).method_7960() && BuntingBlock.canSupportBunting(this.method_11010(), index);
    }

    public boolean isNeverFancy() {
        return ClientConfigs.Blocks.FAST_BUNTINGS.get();
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        super.addExtraModelData(builder);
        builder.with(NORTH_BUNTING, (Object)this.buntings.getOrDefault(class_2350.field_11043, null));
        builder.with(SOUTH_BUNTING, (Object)this.buntings.getOrDefault(class_2350.field_11035, null));
        builder.with(EAST_BUNTING, (Object)this.buntings.getOrDefault(class_2350.field_11034, null));
        builder.with(WEST_BUNTING, (Object)this.buntings.getOrDefault(class_2350.field_11039, null));
    }

    protected boolean getFancyDistance(class_243 cameraPos) {
        LOD lod = new LOD(cameraPos, this.method_11016());
        return lod.isNear();
    }
}

