/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.mixins;

import com.simibubi.create.content.contraptions.MountedStorage;
import com.simibubi.create.foundation.utility.NBTHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import me.duquee.createutilities.CreateUtilities;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestInventory;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestTileEntity;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorNetworkHandler;
import me.duquee.createutilities.mixins.MountedStorageAccessor;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MountedStorage.class})
public class MountedStorageMixin {
    @Shadow
    ItemStackHandler handler;
    @Shadow
    boolean valid;
    @Shadow
    boolean noFuel;

    @Inject(method={"addStorageToWorld(Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnForVoidChest(class_2586 te, CallbackInfo ci) {
        if (te instanceof VoidChestTileEntity) {
            ci.cancel();
        }
    }

    @Inject(method={"serialize()Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="HEAD")}, cancellable=true)
    private void serializeVoidChest(CallbackInfoReturnable<class_2487> cir) {
        ItemStackHandler itemStackHandler = this.handler;
        if (!(itemStackHandler instanceof VoidChestInventory)) {
            return;
        }
        VoidChestInventory voidChest = (VoidChestInventory)itemStackHandler;
        if (!this.valid) {
            cir.setReturnValue(null);
            return;
        }
        class_2487 tag = this.handler.serializeNBT();
        if (this.noFuel) {
            NBTHelper.putMarker((class_2487)tag, (String)"NoFuel");
        }
        NBTHelper.putMarker((class_2487)tag, (String)"VoidChest");
        tag.method_10566("NetworkKey", (class_2520)voidChest.getKey().serialize());
        cir.setReturnValue((Object)tag);
    }

    @Inject(method={"deserialize(Lnet/minecraft/nbt/CompoundTag;)Lcom/simibubi/create/content/contraptions/MountedStorage;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void deserializeVoidChest(class_2487 nbt, CallbackInfoReturnable<MountedStorage> cir) {
        if (nbt == null) {
            return;
        }
        if (!nbt.method_10545("VoidChest")) {
            return;
        }
        MountedStorageAccessor storage = (MountedStorageAccessor)new MountedStorage(null);
        VoidMotorNetworkHandler.NetworkKey key = VoidMotorNetworkHandler.NetworkKey.deserialize(nbt.method_10562("NetworkKey"));
        VoidChestInventory voidChest = CreateUtilities.VOID_CHEST_INVENTORIES_DATA.computeStorageIfAbsent(key);
        storage.setHandler(voidChest);
        storage.setValid(true);
        storage.setNoFuel(nbt.method_10545("NoFuel"));
        cir.setReturnValue((Object)((MountedStorage)storage));
    }

    @Inject(method={"canUseAsStorage(Lnet/minecraft/world/level/block/entity/BlockEntity;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void canUseVoidChestAsStorage(class_2586 be, CallbackInfoReturnable<Boolean> cir) {
        if (be instanceof VoidChestTileEntity) {
            cir.setReturnValue((Object)true);
        }
    }
}

