/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.lgearbox;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import java.util.EnumMap;
import java.util.Map;
import me.duquee.createutilities.blocks.lgearbox.LShapedGearboxBlock;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2769;

public class LShapedGearboxInstance
extends KineticBlockEntityInstance<GearboxBlockEntity> {
    protected final EnumMap<class_2350, RotatingData> keys = new EnumMap(class_2350.class);
    protected class_2350 sourceFacing;

    public LShapedGearboxInstance(MaterialManager modelManager, GearboxBlockEntity tile) {
        super(modelManager, (KineticBlockEntity)tile);
        int blockLight = this.world.method_8314(class_1944.field_9282, this.pos);
        int skyLight = this.world.method_8314(class_1944.field_9284, this.pos);
        this.updateSourceFacing();
        Material rotatingMaterial = this.getRotatingMaterial();
        class_2350 facing1 = (class_2350)this.blockState.method_11654((class_2769)LShapedGearboxBlock.FACING_1);
        this.putShaft((Material<RotatingData>)rotatingMaterial, tile, facing1, blockLight, skyLight);
        class_2350 facing2 = LShapedGearboxBlock.getAbsolute(facing1, (class_2350)this.blockState.method_11654((class_2769)LShapedGearboxBlock.FACING_2));
        this.putShaft((Material<RotatingData>)rotatingMaterial, tile, facing2, blockLight, skyLight);
    }

    private void putShaft(Material<RotatingData> rotatingMaterial, GearboxBlockEntity tile, class_2350 direction, int blockLight, int skyLight) {
        class_2350.class_2351 axis = direction.method_10166();
        Instancer shaft = rotatingMaterial.getModel(AllPartialModels.SHAFT_HALF, this.blockState, direction);
        RotatingData key = (RotatingData)shaft.createInstance();
        key.setRotationAxis(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis).method_23955()).setRotationalSpeed(((GearboxBlockEntity)this.blockEntity).getSpeed()).setRotationOffset(this.getRotationOffset(axis)).setColor((KineticBlockEntity)tile).setPosition(this.getInstancePosition()).setBlockLight(blockLight).setSkyLight(skyLight);
        this.keys.put(direction, key);
    }

    protected void updateSourceFacing() {
        if (((GearboxBlockEntity)this.blockEntity).hasSource()) {
            class_2338 source = ((GearboxBlockEntity)this.blockEntity).source.method_10059((class_2382)this.pos);
            this.sourceFacing = class_2350.method_10147((float)source.method_10263(), (float)source.method_10264(), (float)source.method_10260());
        } else {
            this.sourceFacing = null;
        }
    }

    public void update() {
        this.updateSourceFacing();
        for (Map.Entry<class_2350, RotatingData> key : this.keys.entrySet()) {
            class_2350 direction = key.getKey();
            class_2350.class_2351 axis = direction.method_10166();
            this.updateRotation(key.getValue(), axis, ((GearboxBlockEntity)this.blockEntity).getSpeed());
        }
    }

    public void updateLight() {
        this.relight(this.pos, this.keys.values().stream());
    }

    public void remove() {
        this.keys.values().forEach(InstanceData::delete);
        this.keys.clear();
    }
}

