/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.api.Auxiliary;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.language.Operators;
import carpet.script.value.BooleanValue;
import carpet.script.value.ContainerValueInterface;
import carpet.script.value.LContainerValue;
import carpet.script.value.LazyListValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.gson.JsonParseException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DataStructures {
    public static void apply(Expression expression) {
        expression.addFunction("l", lv -> {
            ListValue listValue;
            Object patt1086$temp;
            if (lv.size() == 1 && (patt1086$temp = lv.get(0)) instanceof LazyListValue) {
                LazyListValue llv = (LazyListValue)patt1086$temp;
                listValue = ListValue.wrap(llv.unroll());
            } else {
                listValue = new ListValue.ListConstructorValue((Collection<? extends Value>)lv);
            }
            return listValue;
        });
        expression.addFunction("join", lv -> {
            Object patt1732$temp;
            List<Object> toJoin;
            Object patt1580$temp;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'join' takes at least 2 arguments");
            }
            String delimiter = ((Value)lv.get(0)).getString();
            if (lv.size() == 2 && (patt1580$temp = lv.get(1)) instanceof LazyListValue) {
                LazyListValue llv = (LazyListValue)patt1580$temp;
                toJoin = llv.unroll();
            } else if (lv.size() == 2 && (patt1732$temp = lv.get(1)) instanceof ListValue) {
                ListValue llv = (ListValue)patt1732$temp;
                toJoin = new ArrayList<Value>(llv.getItems());
            } else {
                toJoin = lv.subList(1, lv.size());
            }
            return new StringValue(toJoin.stream().map(Value::getString).collect(Collectors.joining(delimiter)));
        });
        expression.addFunction("split", lv -> {
            Value delimiter;
            Value hwat;
            if (lv.size() == 1) {
                hwat = (Value)lv.get(0);
                delimiter = null;
            } else if (lv.size() == 2) {
                delimiter = (Value)lv.get(0);
                hwat = (Value)lv.get(1);
            } else {
                throw new InternalExpressionException("'split' takes 1 or 2 arguments");
            }
            return hwat.split(delimiter);
        });
        expression.addFunction("slice", lv -> {
            if (lv.size() != 2 && lv.size() != 3) {
                throw new InternalExpressionException("'slice' takes 2 or 3 arguments");
            }
            Value hwat = (Value)lv.get(0);
            long from = NumericValue.asNumber((Value)lv.get(1)).getLong();
            Long to = null;
            if (lv.size() == 3) {
                to = NumericValue.asNumber((Value)lv.get(2)).getLong();
            }
            return hwat.slice(from, to);
        });
        expression.addFunction("sort", lv -> {
            Object patt3307$temp;
            ArrayList<Value> toSort = lv;
            if (lv.size() == 1 && (patt3307$temp = lv.get(0)) instanceof ListValue) {
                ListValue llv = (ListValue)patt3307$temp;
                toSort = new ArrayList<Value>(llv.getItems());
            }
            Collections.sort(toSort);
            return ListValue.wrap((List<Value>)toSort);
        });
        expression.addLazyFunction("sort_key", (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("First argument for 'sort_key' should be a List");
            }
            Value v = ((LazyValue)lv.get(0)).evalValue((Context)c);
            if (!(v instanceof ListValue)) {
                throw new InternalExpressionException("First argument for 'sort_key' should be a List");
            }
            ListValue list = (ListValue)v;
            ArrayList<Value> toSort = new ArrayList<Value>(list.getItems());
            if (lv.size() == 1) {
                Collections.shuffle(toSort);
                ListValue ret = ListValue.wrap(toSort);
                return (ct, tt) -> ret;
            }
            LazyValue sortKey = (LazyValue)lv.get(1);
            LazyValue defaultVal = c.getVariable("_");
            toSort.sort((v1, v2) -> {
                c.setVariable("_", (cc, tt) -> v1);
                Value ev1 = sortKey.evalValue((Context)c);
                c.setVariable("_", (cc, tt) -> v2);
                Value ev2 = sortKey.evalValue((Context)c);
                return ev1.compareTo(ev2);
            });
            c.setVariable("_", defaultVal);
            ListValue ret = ListValue.wrap(toSort);
            return (cc, tt) -> ret;
        });
        expression.addFunction("range", lv -> {
            NumericValue from = Value.ZERO;
            NumericValue step = Value.ONE;
            int argsize = lv.size();
            if (argsize == 0 || argsize > 3) {
                throw new InternalExpressionException("'range' accepts from 1 to 3 arguments, not " + argsize);
            }
            NumericValue to = NumericValue.asNumber((Value)lv.get(0));
            if (lv.size() > 1) {
                from = to;
                to = NumericValue.asNumber((Value)lv.get(1));
                if (lv.size() > 2) {
                    step = NumericValue.asNumber((Value)lv.get(2));
                }
            }
            return from.isInteger() && to.isInteger() && step.isInteger() ? LazyListValue.rangeLong(from.getLong(), to.getLong(), step.getLong()) : LazyListValue.rangeDouble(from.getDouble(), to.getDouble(), step.getDouble());
        });
        expression.addTypedContextFunction("m", -1, Context.MAPDEF, (c, t, lv) -> {
            MapValue mapValue;
            Object patt6049$temp;
            if (lv.size() == 1 && (patt6049$temp = lv.get(0)) instanceof LazyListValue) {
                LazyListValue llv = (LazyListValue)patt6049$temp;
                mapValue = new MapValue(llv.unroll());
            } else {
                mapValue = new MapValue((List<Value>)lv);
            }
            return mapValue;
        });
        expression.addUnaryFunction("keys", v -> {
            Value value;
            if (v instanceof MapValue) {
                MapValue map = (MapValue)v;
                value = new ListValue(map.getMap().keySet());
            } else {
                value = Value.NULL;
            }
            return value;
        });
        expression.addUnaryFunction("values", v -> {
            Value value;
            if (v instanceof MapValue) {
                MapValue map = (MapValue)v;
                value = new ListValue(map.getMap().values());
            } else {
                value = Value.NULL;
            }
            return value;
        });
        expression.addUnaryFunction("pairs", v -> {
            Value value;
            if (v instanceof MapValue) {
                MapValue map = (MapValue)v;
                value = ListValue.wrap(map.getMap().entrySet().stream().map(p -> ListValue.of((Value)p.getKey(), (Value)p.getValue())));
            } else {
                value = Value.NULL;
            }
            return value;
        });
        expression.addBinaryContextOperator(":", Operators.precedence.get("attribute~:"), true, true, false, (ctx, t, container, address) -> {
            if (container instanceof LContainerValue) {
                LContainerValue lContainerValue;
                LContainerValue lcv = (LContainerValue)container;
                ContainerValueInterface outerContainer = lcv.container();
                if (outerContainer == null) {
                    return LContainerValue.NULL_CONTAINER;
                }
                Value patt7373$temp = outerContainer.get(lcv.address());
                if (patt7373$temp instanceof ContainerValueInterface) {
                    ContainerValueInterface cvi = (ContainerValueInterface)((Object)patt7373$temp);
                    lContainerValue = new LContainerValue(cvi, (Value)address);
                } else {
                    lContainerValue = LContainerValue.NULL_CONTAINER;
                }
                return lContainerValue;
            }
            if (!(container instanceof ContainerValueInterface)) {
                return t == Context.LVALUE ? LContainerValue.NULL_CONTAINER : Value.NULL;
            }
            ContainerValueInterface cvi = (ContainerValueInterface)((Object)container);
            return t != Context.LVALUE ? cvi.get((Value)address) : new LContainerValue(cvi, (Value)address);
        });
        expression.addLazyFunction("get", (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'get' requires parameters");
            }
            if (lv.size() == 1) {
                Value v = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.LVALUE);
                if (!(v instanceof LContainerValue)) {
                    return LazyValue.NULL;
                }
                LContainerValue lcv = (LContainerValue)v;
                ContainerValueInterface container = lcv.container();
                if (container == null) {
                    return LazyValue.NULL;
                }
                Value ret = container.get(lcv.address());
                return (cc, tt) -> ret;
            }
            Value container = ((LazyValue)lv.get(0)).evalValue((Context)c);
            for (int i = 1; i < lv.size(); ++i) {
                if (!(container instanceof ContainerValueInterface)) {
                    return (cc, tt) -> Value.NULL;
                }
                ContainerValueInterface cvi = (ContainerValueInterface)((Object)container);
                container = cvi.get(((LazyValue)lv.get(i)).evalValue((Context)c));
            }
            if (container == null) {
                return (cc, tt) -> Value.NULL;
            }
            Value finalContainer = container;
            return (cc, tt) -> finalContainer;
        });
        expression.addLazyFunction("has", (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'has' requires parameters");
            }
            if (lv.size() == 1) {
                Value v = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.LVALUE);
                if (!(v instanceof LContainerValue)) {
                    return LazyValue.NULL;
                }
                LContainerValue lcv = (LContainerValue)v;
                ContainerValueInterface container = lcv.container();
                if (container == null) {
                    return LazyValue.NULL;
                }
                BooleanValue ret = BooleanValue.of(container.has(lcv.address()));
                return (cc, tt) -> ret;
            }
            Value container = ((LazyValue)lv.get(0)).evalValue((Context)c);
            for (int i = 1; i < lv.size() - 1; ++i) {
                if (!(container instanceof ContainerValueInterface)) {
                    return LazyValue.NULL;
                }
                ContainerValueInterface cvi = (ContainerValueInterface)((Object)container);
                container = cvi.get(((LazyValue)lv.get(i)).evalValue((Context)c));
            }
            if (!(container instanceof ContainerValueInterface)) {
                return LazyValue.NULL;
            }
            ContainerValueInterface cvi = (ContainerValueInterface)((Object)container);
            BooleanValue ret = BooleanValue.of(cvi.has(((LazyValue)lv.get(lv.size() - 1)).evalValue((Context)c)));
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("put", (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'put' takes at least three arguments, a container, address, and values to insert at that index");
            }
            Value container = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.LVALUE);
            if (container instanceof LContainerValue) {
                LContainerValue lcv = (LContainerValue)container;
                ContainerValueInterface internalContainer = lcv.container();
                if (internalContainer == null) {
                    return LazyValue.NULL;
                }
                Value address = lcv.address();
                Value what = ((LazyValue)lv.get(1)).evalValue((Context)c);
                BooleanValue retVal = BooleanValue.of(lv.size() > 2 ? internalContainer.put(address, what, ((LazyValue)lv.get(2)).evalValue((Context)c)) : internalContainer.put(address, what));
                return (cc, tt) -> retVal;
            }
            if (lv.size() < 3) {
                throw new InternalExpressionException("'put' takes at least three arguments, a container, address, and values to insert at that index");
            }
            if (!(container instanceof ContainerValueInterface)) {
                return LazyValue.NULL;
            }
            ContainerValueInterface cvi = (ContainerValueInterface)((Object)container);
            Value where = ((LazyValue)lv.get(1)).evalValue((Context)c);
            Value what = ((LazyValue)lv.get(2)).evalValue((Context)c);
            BooleanValue retVal = BooleanValue.of(lv.size() > 3 ? cvi.put(where, what, ((LazyValue)lv.get(3)).evalValue((Context)c)) : cvi.put(where, what));
            return (cc, tt) -> retVal;
        });
        expression.addLazyFunction("delete", (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'delete' requires parameters");
            }
            if (lv.size() == 1) {
                Value v = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.LVALUE);
                if (!(v instanceof LContainerValue)) {
                    return LazyValue.NULL;
                }
                LContainerValue lcv = (LContainerValue)v;
                ContainerValueInterface container = lcv.container();
                if (container == null) {
                    return LazyValue.NULL;
                }
                BooleanValue ret = BooleanValue.of(container.delete(lcv.address()));
                return (cc, tt) -> ret;
            }
            Value container = ((LazyValue)lv.get(0)).evalValue((Context)c);
            for (int i = 1; i < lv.size() - 1; ++i) {
                if (!(container instanceof ContainerValueInterface)) {
                    return LazyValue.NULL;
                }
                ContainerValueInterface cvi = (ContainerValueInterface)((Object)container);
                container = cvi.get(((LazyValue)lv.get(i)).evalValue((Context)c));
            }
            if (!(container instanceof ContainerValueInterface)) {
                return LazyValue.NULL;
            }
            ContainerValueInterface cvi = (ContainerValueInterface)((Object)container);
            BooleanValue ret = BooleanValue.of(cvi.delete(((LazyValue)lv.get(lv.size() - 1)).evalValue((Context)c)));
            return (cc, tt) -> ret;
        });
        expression.addUnaryFunction("encode_b64", v -> StringValue.of(Base64.getEncoder().encodeToString(v.getString().getBytes(StandardCharsets.UTF_8))));
        expression.addUnaryFunction("decode_b64", v -> {
            try {
                return StringValue.of(new String(Base64.getDecoder().decode(v.getString()), StandardCharsets.UTF_8));
            }
            catch (IllegalArgumentException iae) {
                throw new ThrowStatement("Invalid b64 string: " + v.getString(), Throwables.B64_ERROR);
            }
        });
        expression.addUnaryFunction("encode_json", v -> StringValue.of(v.toJson().toString()));
        expression.addUnaryFunction("decode_json", v -> {
            try {
                return (Value)Auxiliary.GSON.fromJson(v.getString(), Value.class);
            }
            catch (JsonParseException jpe) {
                throw new ThrowStatement("Invalid json string: " + v.getString(), Throwables.JSON_ERROR);
            }
        });
    }
}

