/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.CarpetEventServer;
import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.ScriptHost;
import carpet.script.exception.InternalExpressionException;
import carpet.script.external.Vanilla;
import carpet.script.value.EntityValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_243;

public class EntityEventsGroup {
    private final Map<Event, Map<EventKey, CarpetEventServer.Callback>> actions = new HashMap<Event, Map<EventKey, CarpetEventServer.Callback>>();
    private final class_1297 entity;

    public EntityEventsGroup(class_1297 e) {
        this.entity = e;
    }

    public void onEvent(Event type, Object ... args) {
        if (this.actions.isEmpty()) {
            return;
        }
        Map<EventKey, CarpetEventServer.Callback> actionSet = this.actions.get(type);
        if (actionSet == null) {
            return;
        }
        CarpetScriptServer scriptServer = Vanilla.MinecraftServer_getScriptServer(this.entity.method_5682());
        if (scriptServer.stopAll) {
            return;
        }
        Iterator<Map.Entry<EventKey, CarpetEventServer.Callback>> iterator = actionSet.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EventKey, CarpetEventServer.Callback> action = iterator.next();
            EventKey key = action.getKey();
            CarpetScriptHost host = scriptServer.getAppHostByName(key.host());
            if (host == null) {
                iterator.remove();
                continue;
            }
            if (key.user() != null && this.entity.method_5682().method_3760().method_14566(key.user()) == null) {
                iterator.remove();
                continue;
            }
            if (type.call(action.getValue(), this.entity, args) != CarpetEventServer.CallbackResult.FAIL) continue;
            iterator.remove();
        }
        if (actionSet.isEmpty()) {
            this.actions.remove(type);
        }
    }

    public void addEvent(Event type, ScriptHost host, FunctionValue fun, List<Value> extraargs) {
        EventKey key = new EventKey(host.getName(), host.user);
        if (fun != null) {
            CarpetEventServer.Callback call = type.create(key, fun, extraargs, (CarpetScriptServer)host.scriptServer());
            if (call == null) {
                throw new InternalExpressionException("wrong number of arguments for callback, required " + type.argcount);
            }
            this.actions.computeIfAbsent(type, k -> new HashMap()).put(key, call);
        } else {
            this.actions.computeIfAbsent(type, k -> new HashMap()).remove(key);
            if (this.actions.get(type).isEmpty()) {
                this.actions.remove(type);
            }
        }
    }

    private record EventKey(String host, String user) {
    }

    public static class Event {
        public static final Map<String, Event> byName = new HashMap<String, Event>();
        public static final Event ON_DEATH = new Event("on_death", 1){

            @Override
            public List<Value> makeArgs(class_1297 entity, Object ... providedArgs) {
                return Arrays.asList(new EntityValue(entity), new StringValue((String)providedArgs[0]));
            }
        };
        public static final Event ON_REMOVED = new Event("on_removed", 0);
        public static final Event ON_TICK = new Event("on_tick", 0);
        public static final Event ON_DAMAGE = new Event("on_damaged", 3){

            @Override
            public List<Value> makeArgs(class_1297 entity, Object ... providedArgs) {
                float amount = ((Float)providedArgs[0]).floatValue();
                class_1282 source = (class_1282)providedArgs[1];
                return Arrays.asList(new EntityValue(entity), new NumericValue(amount), new StringValue(source.method_5525()), source.method_5529() == null ? Value.NULL : new EntityValue(source.method_5529()));
            }
        };
        public static final Event ON_MOVE = new Event("on_move", 3){

            @Override
            public List<Value> makeArgs(class_1297 entity, Object ... providedArgs) {
                return Arrays.asList(new EntityValue(entity), ValueConversions.of((class_243)providedArgs[0]), ValueConversions.of((class_243)providedArgs[1]), ValueConversions.of((class_243)providedArgs[2]));
            }
        };
        public final int argcount;
        public final String id;

        public Event(String identifier, int args) {
            this.id = identifier;
            this.argcount = args + 1;
            byName.put(identifier, this);
        }

        public CarpetEventServer.Callback create(EventKey key, FunctionValue function, List<Value> extraArgs, CarpetScriptServer scriptServer) {
            if (function.getArguments().size() - (extraArgs == null ? 0 : extraArgs.size()) != this.argcount) {
                return null;
            }
            return new CarpetEventServer.Callback(key.host(), key.user(), function, extraArgs, scriptServer);
        }

        public CarpetEventServer.CallbackResult call(CarpetEventServer.Callback tickCall, class_1297 entity, Object ... args) {
            assert (args.length == this.argcount - 1);
            return tickCall.execute(entity.method_5671(), this.makeArgs(entity, args));
        }

        protected List<Value> makeArgs(class_1297 entity, Object ... args) {
            return Collections.singletonList(new EntityValue(entity));
        }
    }
}

