/*
 * Decompiled with CFR 0.152.
 */
package carpet.network;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.api.settings.SettingsManager;
import carpet.fakes.LevelInterface;
import carpet.helpers.TickRateManager;
import carpet.network.CarpetClient;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2168;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_746;

public class ClientNetworkHandler {
    private static final Map<String, BiConsumer<class_746, class_2520>> dataHandlers = new HashMap<String, BiConsumer<class_746, class_2520>>();

    public static void handleData(class_2540 data, class_746 player) {
        if (data != null) {
            int id = data.method_10816();
            if (id == 69) {
                ClientNetworkHandler.onHi(data);
            }
            if (id == 1) {
                ClientNetworkHandler.onSyncData(data, player);
            }
        }
    }

    private static void onHi(class_2540 data) {
        CarpetClient.setCarpet();
        CarpetClient.serverCarpetVersion = data.method_10800(64);
        if (CarpetSettings.carpetVersion.equals(CarpetClient.serverCarpetVersion)) {
            CarpetSettings.LOG.info("Joined carpet server with matching carpet version");
        } else {
            CarpetSettings.LOG.warn("Joined carpet server with another carpet version: " + CarpetClient.serverCarpetVersion);
        }
        ClientNetworkHandler.respondHello();
    }

    public static void respondHello() {
        CarpetClient.getPlayer().field_3944.method_2883((class_2596)new class_2817(CarpetClient.CARPET_CHANNEL, new class_2540(Unpooled.buffer()).method_10804(420).method_10814(CarpetSettings.carpetVersion)));
    }

    private static void onSyncData(class_2540 data, class_746 player) {
        class_2487 compound = data.method_10798();
        if (compound == null) {
            return;
        }
        for (String key : compound.method_10541()) {
            if (dataHandlers.containsKey(key)) {
                try {
                    dataHandlers.get(key).accept(player, compound.method_10580(key));
                }
                catch (Exception exc) {
                    CarpetSettings.LOG.info("Corrupt carpet data for " + key);
                }
                continue;
            }
            CarpetSettings.LOG.error("Unknown carpet data: " + key);
        }
    }

    public static void clientCommand(String command) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", command);
        tag.method_10582("command", command);
        class_2487 outer = new class_2487();
        outer.method_10566("clientCommand", (class_2520)tag);
        CarpetClient.getPlayer().field_3944.method_2883((class_2596)new class_2817(CarpetClient.CARPET_CHANNEL, new class_2540(Unpooled.buffer()).method_10804(1).method_10794(outer)));
    }

    static {
        dataHandlers.put("Rules", (p, t) -> {
            class_2487 ruleset = (class_2487)t;
            for (String ruleKey : ruleset.method_10541()) {
                CarpetRule<?> rule;
                String ruleName;
                class_2487 ruleNBT = (class_2487)ruleset.method_10580(ruleKey);
                SettingsManager manager = null;
                if (ruleNBT.method_10545("Manager")) {
                    ruleName = ruleNBT.method_10558("Rule");
                    String managerName = ruleNBT.method_10558("Manager");
                    if (managerName.equals("carpet")) {
                        manager = CarpetServer.settingsManager;
                    } else {
                        for (CarpetExtension extension : CarpetServer.extensions) {
                            SettingsManager eManager = extension.extensionSettingsManager();
                            if (eManager == null || !managerName.equals(eManager.identifier())) continue;
                            manager = eManager;
                            break;
                        }
                    }
                } else {
                    manager = CarpetServer.settingsManager;
                    ruleName = ruleKey;
                }
                if ((rule = manager != null ? manager.getCarpetRule(ruleName) : null) == null) continue;
                String value = ruleNBT.method_10558("Value");
                try {
                    rule.set((class_2168)null, value);
                }
                catch (InvalidRuleValueException invalidRuleValueException) {}
            }
        });
        dataHandlers.put("TickRate", (p, t) -> {
            TickRateManager tickRateManager = ((LevelInterface)p.field_17892).tickRateManager();
            tickRateManager.setTickRate(((class_2514)t).method_10700());
        });
        dataHandlers.put("TickingState", (p, t) -> {
            class_2487 tickingState = (class_2487)t;
            TickRateManager tickRateManager = ((LevelInterface)p.field_17892).tickRateManager();
            tickRateManager.setFrozenState(tickingState.method_10577("is_paused"), tickingState.method_10577("deepFreeze"));
        });
        dataHandlers.put("SuperHotState", (p, t) -> {
            TickRateManager tickRateManager = ((LevelInterface)p.field_17892).tickRateManager();
            tickRateManager.setSuperHot(((class_2481)t).equals((Object)class_2481.field_21027));
        });
        dataHandlers.put("TickPlayerActiveTimeout", (p, t) -> {
            TickRateManager tickRateManager = ((LevelInterface)p.field_17892).tickRateManager();
            tickRateManager.setPlayerActiveTimeout(((class_2514)t).method_10701());
        });
        dataHandlers.put("scShape", (p, t) -> {
            if (CarpetClient.shapes != null) {
                CarpetClient.shapes.addShape((class_2487)t);
            }
        });
        dataHandlers.put("scShapes", (p, t) -> {
            if (CarpetClient.shapes != null) {
                CarpetClient.shapes.addShapes((class_2499)t);
            }
        });
        dataHandlers.put("clientCommand", (p, t) -> CarpetClient.onClientCommand(t));
    }
}

