/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.CarpetServer;
import carpet.helpers.TickRateManager;
import carpet.network.ServerNetworkHandler;
import carpet.utils.Messenger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerTickRateManager
extends TickRateManager {
    private long remainingWarpTicks = 0L;
    private long tickWarpStartTime = 0L;
    private long scheduledCurrentWarpTicks = 0L;
    private class_3222 warpResponsiblePlayer = null;
    private String tickWarpCallback = null;
    private class_2168 warpResponsibleSource = null;
    private MinecraftServer server;
    private final Map<String, BiConsumer<String, Float>> tickrateListeners = new HashMap<String, BiConsumer<String, Float>>();
    private static final float MIN_TICKRATE = 0.01f;

    public ServerTickRateManager(MinecraftServer server) {
        this.server = server;
    }

    public boolean isInWarpSpeed() {
        return this.tickWarpStartTime != 0L;
    }

    @Override
    public boolean shouldEntityTick(class_1297 e) {
        return this.runsNormally() || e instanceof class_1657;
    }

    public boolean deeplyFrozen() {
        return this.deepFreeze;
    }

    @Override
    public void setFrozenState(boolean isPaused, boolean isDeepFreeze) {
        super.setFrozenState(isPaused, isDeepFreeze);
        ServerNetworkHandler.updateFrozenStateToConnectedPlayers(this.server);
    }

    public void resetPlayerActivity() {
        if (this.playerActivityTimeout < 2) {
            this.playerActivityTimeout = 2;
            ServerNetworkHandler.updateTickPlayerActiveTimeoutToConnectedPlayers(this.server);
        }
    }

    public void stepGameIfPaused(int ticks) {
        this.playerActivityTimeout = 2 + ticks;
        ServerNetworkHandler.updateTickPlayerActiveTimeoutToConnectedPlayers(this.server);
    }

    public class_2561 requestGameToWarpSpeed(class_3222 player, int advance, String callback, class_2168 source) {
        if (0 == advance) {
            this.tickWarpCallback = null;
            if (source != this.warpResponsibleSource) {
                this.warpResponsibleSource = null;
            }
            if (this.remainingWarpTicks > 0L) {
                this.finishTickWarp();
                this.warpResponsibleSource = null;
                return Messenger.c("gi Warp interrupted");
            }
            return Messenger.c("ri No warp in progress");
        }
        if (this.remainingWarpTicks > 0L) {
            String who = "Another player";
            if (this.warpResponsiblePlayer != null) {
                who = this.warpResponsiblePlayer.method_5820();
            }
            return Messenger.c("l " + who + " is already advancing time at the moment. Try later or ask them");
        }
        this.warpResponsiblePlayer = player;
        this.tickWarpStartTime = System.nanoTime();
        this.scheduledCurrentWarpTicks = advance;
        this.remainingWarpTicks = advance;
        this.tickWarpCallback = callback;
        this.warpResponsibleSource = source;
        return Messenger.c("gi Warp speed ....");
    }

    public void finishTickWarp() {
        long completed_ticks = this.scheduledCurrentWarpTicks - this.remainingWarpTicks;
        double milis_to_complete = System.nanoTime() - this.tickWarpStartTime;
        if (milis_to_complete == 0.0) {
            milis_to_complete = 1.0;
        }
        int tps = (int)(1000.0 * (double)completed_ticks / (milis_to_complete /= 1000000.0));
        double mspt = 1.0 * milis_to_complete / (double)completed_ticks;
        this.scheduledCurrentWarpTicks = 0L;
        this.tickWarpStartTime = 0L;
        if (this.tickWarpCallback != null) {
            block6: {
                class_2170 icommandmanager = this.warpResponsibleSource.method_9211().method_3734();
                try {
                    icommandmanager.method_44252(this.warpResponsibleSource, this.tickWarpCallback);
                }
                catch (Throwable var23) {
                    if (this.warpResponsiblePlayer == null) break block6;
                    Messenger.m((class_1657)this.warpResponsiblePlayer, "r Command Callback failed - unknown error: ", "rb /" + this.tickWarpCallback, "/" + this.tickWarpCallback);
                }
            }
            this.tickWarpCallback = null;
            this.warpResponsibleSource = null;
        }
        if (this.warpResponsiblePlayer != null) {
            Messenger.m((class_1657)this.warpResponsiblePlayer, String.format("gi ... Time warp completed with %d tps, or %.2f mspt", tps, mspt));
            this.warpResponsiblePlayer = null;
        } else {
            Messenger.print_server_message(CarpetServer.minecraft_server, String.format("... Time warp completed with %d tps, or %.2f mspt", tps, mspt));
        }
        this.remainingWarpTicks = 0L;
    }

    public boolean continueWarp() {
        if (!this.runGameElements) {
            return false;
        }
        if (this.remainingWarpTicks > 0L) {
            if (this.remainingWarpTicks == this.scheduledCurrentWarpTicks) {
                this.tickWarpStartTime = System.nanoTime();
            }
            --this.remainingWarpTicks;
            return true;
        }
        this.finishTickWarp();
        return false;
    }

    @Override
    public void setTickRate(float rate) {
        this.setTickRate(rate, true);
    }

    public void setTickRate(float rate, boolean update) {
        super.setTickRate(rate);
        if (update) {
            this.notifyTickrateListeners("carpet");
        }
    }

    private void tickrateChanged(String modId, float rate) {
        if (rate < 0.01f) {
            rate = 0.01f;
        }
        this.tickrate = rate;
        this.mspt = 1000.0f / this.tickrate;
        this.notifyTickrateListeners(modId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTickrateListeners(String originModId) {
        Map<String, BiConsumer<String, Float>> map = this.tickrateListeners;
        synchronized (map) {
            for (Map.Entry<String, BiConsumer<String, Float>> listenerEntry : this.tickrateListeners.entrySet()) {
                if (originModId != null && originModId.equals(listenerEntry.getKey())) continue;
                listenerEntry.getValue().accept(originModId, Float.valueOf(this.tickrate));
            }
        }
        ServerNetworkHandler.updateTickSpeedToConnectedPlayers(this.server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiConsumer<String, Float> addTickrateListener(String modId, BiConsumer<String, Float> tickrateListener) {
        Map<String, BiConsumer<String, Float>> map = this.tickrateListeners;
        synchronized (map) {
            this.tickrateListeners.put(modId, tickrateListener);
        }
        return this::tickrateChanged;
    }
}

