/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.simplevillagers.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.samo_lego.config2brigadier.IBrigadierConfigurator;
import org.samo_lego.config2brigadier.annotation.BrigadierDescription;
import org.samo_lego.simplevillagers.SimpleVillagers;

public class Config
implements IBrigadierConfigurator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    @SerializedName(value="// How many ticks between each golem spawn. Defaults to 4 minutes.")
    public final String _comment_golemTimer = "";
    @BrigadierDescription(defaultOption="4800")
    @SerializedName(value="golem_timer")
    public int golemTimer = 4800;
    @SerializedName(value="// How many ticks does golem 'live'. Defaults to 12 seconds.")
    public final String _comment_golemDyingTicks = "";
    @BrigadierDescription(defaultOption="240")
    @SerializedName(value="golem_death_ticks")
    public int golemDyingTicks = 240;
    @SerializedName(value="// How many ticks must pass between each breeding cycle. Defaults to 5 minutes.")
    public final String _comment_breedingTimer = "";
    @BrigadierDescription(defaultOption="6000")
    @SerializedName(value="breeding_timer")
    public int breedingTimer = 6000;
    @SerializedName(value="// Age of new baby villagers. Default is 20 minutes to grow up (like in vanilla).")
    public final String _comment_bornBabyAge = "";
    @BrigadierDescription(defaultOption="-24000")
    @SerializedName(value="born_baby_age")
    public int bornBabyAge = -24000;
    @SerializedName(value="// How much should age be increased by each tick in *incubator* block. Vanilla would be 1.")
    public final String _comment_babyAgeIncrease = "";
    @SerializedName(value="baby_age_increase")
    public int babyAgeIncrease = 2;
    @SerializedName(value="// Settings for zombie villager converter (curing).")
    public final String _comment_converter = "";
    public Converter converter = new Converter();
    public Restock restock = new Restock();

    public static Config loadConfigFile(File file) {
        Config config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (Config)GSON.fromJson((Reader)fileReader, Config.class);
            }
            catch (IOException e) {
                throw new RuntimeException("simplevillagers Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new Config();
        }
        config.saveConfigFile(file);
        return config;
    }

    public void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            SimpleVillagers.LOGGER.error("Problem occurred when saving config: " + e.getMessage());
        }
    }

    public void reload() {
        Config newConfig = Config.loadConfigFile(SimpleVillagers.getConfigFile());
        this.reload(newConfig);
        this.save();
    }

    public void save() {
        this.saveConfigFile(SimpleVillagers.getConfigFile());
    }

    public static class Converter {
        @SerializedName(value="// How many ticks does zombie -> villager conversion take.")
        public final String _comment_conversionTime = "";
        @SerializedName(value="time")
        public int conversionTime = 6000;
        @SerializedName(value="// Whether players must be online when conversion finishes to get discounts.")
        public final String _comment_requiresOnlinePlayer0 = "";
        @SerializedName(value="// Vanilla acts strangely here as it defaults to true, but that doesn't make much sense.")
        public final String _comment_requiresOnlinePlayer1 = "";
        @SerializedName(value="requires_player_be_online")
        public boolean requiresOnlinePlayer = false;
        @SerializedName(value="// Whether to require *splash* potion of weakness.")
        public final String _comment_requireSplash = "";
        @SerializedName(value="require_splash_potion_type")
        public boolean requireSplash = true;
    }

    public static class Restock {
        @SerializedName(value="// How many ticks must pass between each restocking.")
        public final String _comment_timer = "";
        public int timer = 6000;
        @SerializedName(value="How many times per day restocking can occur.")
        public String _maxAmount = "";
        public int maxAmount = 2;
        public int minWaitTime = 12000;
    }
}

