/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.api;

import java.util.function.Supplier;
import net.minecraft.class_2960;

public class DeferredObject<T> {
    private final class_2960 identifier;
    private final Supplier<T> supplier;
    private final Supplier<Boolean> canResolveFunc;
    protected T object;

    protected DeferredObject(class_2960 identifier) {
        this(identifier, () -> null, () -> false);
    }

    public DeferredObject(class_2960 identifier, Supplier<T> supplier) {
        this(identifier, supplier, () -> false);
    }

    public DeferredObject(class_2960 identifier, Supplier<T> supplier, Supplier<Boolean> canResolveFunc) {
        this.identifier = identifier;
        this.supplier = supplier;
        this.canResolveFunc = canResolveFunc;
    }

    protected void set(T object) {
        this.object = object;
    }

    public boolean canResolve() {
        return this.canResolveFunc.get();
    }

    public T resolve() {
        if (this.object == null) {
            this.object = this.supplier.get();
        }
        return this.object;
    }

    public T get() {
        if (this.object == null) {
            if (this.canResolve()) {
                return this.resolve();
            }
            throw new IllegalStateException("Tried to access deferred object before it was resolved.");
        }
        return this.object;
    }

    public DeferredObject<T> resolveImmediately() {
        this.resolve();
        return this;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public static <T> DeferredObject<T> of(class_2960 identifier, T instance) {
        return new DeferredObject<Object>(identifier, () -> instance).resolveImmediately();
    }
}

