/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;

public class ETFSprite {
    public final boolean isETFAltered;
    private final class_1058 sprite;
    private final class_1058 emissiveSprite;

    public ETFSprite(@NotNull class_1058 originalSprite, @NotNull ETFTexture etfTexture) {
        Optional resource;
        class_2960 emissiveId;
        class_7764 contents;
        if (etfTexture.getVariantNumber() != 0) {
            class_2960 variantId = etfTexture.getTextureIdentifier(null);
            Optional resource2 = class_310.method_1551().method_1478().method_14486(variantId);
            if (resource2.isPresent()) {
                class_1058 possibleVariant = null;
                contents = class_7766.method_45829((class_2960)new class_2960(variantId + "-etf_sprite"), (class_3298)((class_3298)resource2.get()));
                try {
                    if (contents != null) {
                        possibleVariant = new class_1058(variantId, contents, contents.method_45807(), contents.method_45815(), 0, 0);
                    }
                }
                finally {
                    if (contents != null) {
                        contents.close();
                    }
                }
                this.sprite = Objects.requireNonNullElse(possibleVariant, originalSprite);
            } else {
                this.sprite = originalSprite;
            }
        } else {
            this.sprite = originalSprite;
        }
        this.isETFAltered = !this.sprite.equals(originalSprite);
        class_1058 possibleEmissive = null;
        if (etfTexture.eSuffix != null && (emissiveId = etfTexture.getEmissiveIdentifierOfCurrentState()) != null && (resource = class_310.method_1551().method_1478().method_14486(emissiveId)).isPresent()) {
            contents = class_7766.method_45829((class_2960)new class_2960(emissiveId + "-etf_sprite"), (class_3298)((class_3298)resource.get()));
            try {
                if (contents != null) {
                    possibleEmissive = new class_1058(emissiveId, contents, contents.method_45807(), contents.method_45815(), 0, 0);
                }
            }
            finally {
                if (contents != null) {
                    contents.close();
                }
            }
        }
        this.emissiveSprite = possibleEmissive;
    }

    @NotNull
    public class_1058 getEmissive() {
        return this.emissiveSprite;
    }

    public boolean isEmissive() {
        return this.emissiveSprite != null;
    }

    @NotNull
    public class_1058 getSpriteVariant() {
        return this.sprite;
    }
}

