/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.utils;

import de.ambertation.wunderreich.client.WunderreichClient;
import de.ambertation.wunderreich.config.Configs;
import de.ambertation.wunderreich.config.LevelData;
import de.ambertation.wunderreich.config.LevelDataFile;
import de.ambertation.wunderreich.items.WunderKisteItem;
import de.ambertation.wunderreich.registries.WunderreichBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3542;
import net.minecraft.class_4730;
import net.minecraft.class_5251;

public enum WunderKisteDomain implements class_3542
{
    WHITE("white", class_1802.field_8446, 0xFFFFFF, false, "wunder_kiste"),
    ORANGE("orange", class_1802.field_8492, 16356139, true),
    MAGENTA("magenta", class_1802.field_8669, 14049489, true),
    LIGHT_BLUE("light_blue", class_1802.field_8273, 6076391, false),
    YELLOW("yellow", class_1802.field_8192, 16701759, true),
    LIME("lime", class_1802.field_8131, 8834086, true),
    PINK("pink", class_1802.field_8330, 16036553, true),
    GRAY("gray", class_1802.field_8298, 4673362, false),
    LIGHT_GRAY("light_gray", class_1802.field_8851, 0x9D9D97, false),
    CYAN("cyan", class_1802.field_8632, 1481628, true),
    PURPLE("purple", class_1802.field_8296, 9913293, true),
    BLUE("blue", class_1802.field_8345, 2895760, false),
    BROWN("brown", class_1802.field_8099, 8606770, true),
    GREEN("green", class_1802.field_8408, 6653465, true),
    RED("red", class_1802.field_8264, 12071980, true),
    BLACK("black", class_1802.field_8226, 0x252529, false);

    public final class_1792 triggerItem;
    public final ID domainID;
    public final int color;
    public final class_5251 textColor;
    public final int overlayColor;
    private final String name;
    public final boolean useMonochromeFallback;
    @Environment(value=EnvType.CLIENT)
    private final Object texture;

    private WunderKisteDomain(String name, class_1792 triggerItem, int color, boolean useMonochromeFallback, String texture) {
        this.name = name;
        this.domainID = new ID(name, false);
        this.triggerItem = triggerItem;
        this.color = color;
        this.textColor = class_5251.method_27717((int)color);
        this.useMonochromeFallback = useMonochromeFallback;
        this.overlayColor = (Boolean)Configs.MAIN.multiTexturedWunderkiste.get() != false ? 0xFFFFFF : color;
        this.texture = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? (((Boolean)Configs.MAIN.multiTexturedWunderkiste.get()).booleanValue() ? WunderreichClient.getWunderkisteColor(texture) : (useMonochromeFallback ? WunderreichClient.getWunderkisteColor("wunder_kiste_bw") : WunderreichClient.getWunderkisteColor("wunder_kiste"))) : null;
    }

    private WunderKisteDomain(String name, class_1792 triggerItem, int color, boolean useMonochromeFallback) {
        this(name, triggerItem, color, useMonochromeFallback, "wunder_kiste_" + name);
    }

    @Environment(value=EnvType.CLIENT)
    public class_4730 getMaterial() {
        return (class_4730)this.texture;
    }

    public String toString() {
        return this.name;
    }

    public String method_15434() {
        return this.name;
    }

    public class_1799 createStack() {
        class_1799 stack = new class_1799((class_1935)WunderreichBlocks.WUNDER_KISTE.method_8389(), 1);
        return WunderKisteItem.setDomain(stack, this);
    }

    public static class ID {
        public final String id;
        public final LevelDataFile extraFile;
        private static final Map<String, ID> ID_MAP = new HashMap<String, ID>();

        ID(String id, boolean extraFile) {
            this.id = id;
            this.extraFile = extraFile ? LevelData.getInstance().fileForName(id) : null;
        }

        public static ID forString(String s) {
            return ID_MAP.computeIfAbsent(s, key -> new ID("_n_" + key, true));
        }

        public static ID forDomain(WunderKisteDomain d) {
            return d.domainID;
        }

        public static void forAll(Consumer<ID> idConsumer) {
            for (WunderKisteDomain domain : WunderKisteDomain.values()) {
                idConsumer.accept(domain.domainID);
            }
            for (ID id : ID_MAP.values()) {
                idConsumer.accept(id);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof String) {
                String s = (String)o;
                return ("_n_" + s).equals(this.id);
            }
            if (o instanceof WunderKisteDomain) {
                WunderKisteDomain d = (WunderKisteDomain)((Object)o);
                return this.equals(d.domainID);
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ID id1 = (ID)o;
            return this.id.equals(id1.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return this.id;
        }

        public boolean isEmpty() {
            return this.id == null || this.id.isEmpty();
        }

        public boolean isBuiltIn() {
            return this.extraFile == null;
        }

        public static void loadNewLevel() {
            ID_MAP.entrySet().removeIf(i -> i != null && i.getValue() != null && !((ID)i.getValue()).isBuiltIn());
        }
    }
}

