/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3497;
import net.minecraft.class_3503;
import net.minecraft.class_3505;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class TagRegistry<T> {
    private static final List<TagRegistry<?>> REGISTRIES = Lists.newArrayList();
    public static final TagRegistry<class_2248> BLOCK = new TagRegistry(class_7923.field_41175);
    public static final TagRegistry<class_1792> ITEM = new TagRegistry(class_7923.field_41178);
    private final Map<class_2960, Set<T>> tags = Maps.newHashMap();
    private final class_7922<T> registry;

    public TagRegistry(class_7922<T> registry) {
        this.registry = registry;
        REGISTRIES.add(this);
    }

    public static TagRegistry<?> getRegistryForDirectory(String directory) {
        for (TagRegistry<?> reg : REGISTRIES) {
            if (!reg.isForDirectory(directory)) continue;
            return reg;
        }
        return null;
    }

    public void add(class_6862<T> tag, T ... objects) {
        class_2960 tagID = tag.comp_327();
        Set set = this.tags.computeIfAbsent(tagID, k -> Sets.newHashSet());
        for (T obj : objects) {
            if (obj == null) continue;
            set.add(obj);
        }
    }

    public boolean isForDirectory(String directory) {
        return class_3505.method_40099(this.getRegistryKey()).equals(directory);
    }

    public class_5321<? extends class_2378<T>> getRegistryKey() {
        return this.registry.method_30517();
    }

    private class_2960 getLocation(T element) {
        class_2960 id = this.registry.method_10221(element);
        if (id != this.registry.method_10137()) {
            return id;
        }
        return null;
    }

    public Map<class_2960, List<class_3503.class_5145>> addTags(Map<class_2960, List<class_3503.class_5145>> tagMap) {
        for (Map.Entry<class_2960, Set<T>> entry : this.tags.entrySet()) {
            class_2960 location = entry.getKey();
            Set<T> elements = entry.getValue();
            List builder = tagMap.computeIfAbsent(location, loc -> new ArrayList());
            for (T element : elements) {
                class_2960 elementLocation = this.getLocation(element);
                if (elementLocation == null) continue;
                builder.add(new class_3503.class_5145(class_3497.method_43937((class_2960)elementLocation), "wunderreich"));
            }
        }
        return tagMap;
    }

    public class_6862<T> createCommon(String name) {
        return class_6862.method_40092(this.getRegistryKey(), (class_2960)new class_2960("c", name));
    }
}

