/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.ambertation.wunderreich.loot.EntryCondition;
import de.ambertation.wunderreich.loot.EntryFunction;
import de.ambertation.wunderreich.loot.SetCountFunction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2769;

class Entry {
    private final String type;
    private final String name;
    private final List<EntryFunction> functions = new ArrayList<EntryFunction>(0);
    private final List<EntryCondition> conditions = new ArrayList<EntryCondition>(0);

    Entry(String type, String name) {
        this.type = type;
        this.name = name;
    }

    void addFunction(EntryFunction f) {
        this.functions.add(f);
    }

    <T extends Enum<T>> void addCountForStateFunction(int count, boolean add, class_2769<T> prop, T value) {
        this.addFunction(new SetCountFunction(count, add).addStateCondition(this.name, prop, value));
    }

    void addCondition(EntryCondition f) {
        this.conditions.add(f);
    }

    JsonObject serialize() {
        JsonArray f;
        JsonObject root = new JsonObject();
        root.add("type", (JsonElement)new JsonPrimitive(this.type));
        if (this.functions.size() > 0) {
            f = new JsonArray();
            this.functions.stream().map(EntryFunction::serialize).forEach(arg_0 -> ((JsonArray)f).add(arg_0));
            root.add("functions", (JsonElement)f);
        }
        if (this.conditions.size() > 0) {
            f = new JsonArray();
            this.conditions.stream().map(EntryCondition::serialize).forEach(arg_0 -> ((JsonArray)f).add(arg_0));
            root.add("conditions", (JsonElement)f);
        }
        if (this.name != null) {
            root.add("name", (JsonElement)new JsonPrimitive(this.name));
        }
        return root;
    }
}

