/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.integration.emi;

import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.integration.emi.EMIImprinterRecipe;
import de.ambertation.wunderreich.registries.WunderreichBlocks;
import de.ambertation.wunderreich.utils.Logger;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;

public class EMIPlugin
implements EmiPlugin {
    public static final class_2960 WIDGETS = Wunderreich.ID("textures/gui/widgets.png");
    public static final EmiStack IMPRINTER_WORKSTATION = EmiStack.of((class_1935)WunderreichBlocks.WHISPER_IMPRINTER);
    public static final EmiRecipeCategory IMPRINTER_CATEGORY = new EmiRecipeCategory(Wunderreich.ID("imprinter"), (EmiRenderable)IMPRINTER_WORKSTATION, (EmiRenderable)EMIPlugin.getSprite(0, 0));

    public static EmiTexture getSprite(int u, int v) {
        return new EmiTexture(WIDGETS, u, v, 16, 16, 16, 16, 16, 16);
    }

    public static <C extends class_1263, T extends class_1860<C>, E extends EmiRecipe> void addAllRecipes(EmiRegistry emiRegistry, class_1863 manager, Logger logger, class_3956<T> recipeType, Function<T, E> createRecipe) {
        EMIPlugin.addAllRecipes(emiRegistry, manager, logger, recipeType, _ignored -> null, (recipe, _ignored) -> (EmiRecipe)createRecipe.apply(recipe));
    }

    public static <C extends class_1263, T extends class_1860<C>, E extends EmiRecipe, V> void addAllRecipes(EmiRegistry emiRegistry, class_1863 manager, Logger logger, class_3956<T> recipeType, Function<T, List<V>> variantSupplier, BiFunction<T, V, E> createRecipe) {
        List<class_1860> recipes = manager.method_30027(recipeType).stream().sorted(Comparator.comparing(a -> a.method_8110(class_310.method_1551().field_1687.method_30349()).method_7954().getString())).toList();
        for (class_1860 recipe : recipes) {
            List<V> variants = variantSupplier.apply(recipe);
            if (variants == null) {
                emiRegistry.addRecipe((EmiRecipe)createRecipe.apply(recipe, null));
                continue;
            }
            for (V variantData : variants) {
                try {
                    emiRegistry.addRecipe((EmiRecipe)createRecipe.apply(recipe, variantData));
                }
                catch (Exception e) {
                    logger.error("Exception when parsing vanilla recipe " + recipe.method_8114(), e);
                }
            }
        }
    }

    public void register(EmiRegistry emiRegistry) {
        class_1863 manager = emiRegistry.getRecipeManager();
        emiRegistry.addCategory(IMPRINTER_CATEGORY);
        emiRegistry.addWorkstation(IMPRINTER_CATEGORY, (EmiIngredient)IMPRINTER_WORKSTATION);
        EMIImprinterRecipe.addAllRecipes(emiRegistry, manager);
    }
}

