/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.blocks;

import com.google.common.math.DoubleMath;
import de.ambertation.wunderreich.blocks.DirtSlabBlock;
import de.ambertation.wunderreich.blocks.SnowyDirtSlab;
import de.ambertation.wunderreich.config.Configs;
import de.ambertation.wunderreich.registries.WunderreichSlabBlocks;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2488;
import net.minecraft.class_2500;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6862;

public class SpreadableSnowyDirtSlab
extends SnowyDirtSlab {
    public SpreadableSnowyDirtSlab(class_2248 baseBlock) {
        super(baseBlock);
    }

    public static boolean doesOcclude(class_1922 blockGetter, class_2680 state, class_2338 pos, class_2680 aboveState, class_2338 abovePos, class_2350 direction) {
        if (!aboveState.method_26225()) {
            return false;
        }
        class_265 shape = state.method_26201(blockGetter, pos);
        class_265 aboveShape = aboveState.method_26201(blockGetter, abovePos);
        if (!aboveState.method_26211() && aboveShape != class_259.method_1077()) {
            return false;
        }
        if (aboveShape.method_1110()) {
            return false;
        }
        class_2350.class_2351 axis = direction.method_10166();
        if (!DoubleMath.fuzzyEquals((double)shape.method_1105(axis), (double)1.0, (double)1.0E-7)) {
            return false;
        }
        if (!DoubleMath.fuzzyEquals((double)aboveShape.method_1091(axis), (double)0.0, (double)1.0E-7)) {
            return false;
        }
        return class_259.method_1080((class_265)shape, (class_265)aboveShape, (class_2350)direction);
    }

    private static boolean canBeGrassNewSlab(class_2680 state, class_4538 reader, class_2338 pos) {
        if (state.method_11654((class_2769)field_11501) == class_2771.field_12681) {
            return true;
        }
        return SpreadableSnowyDirtSlab.canBeGrassNew(state, reader, pos);
    }

    private static boolean canBeGrassNew(class_2680 state, class_4538 reader, class_2338 pos) {
        class_2338 abovePos = pos.method_10084();
        class_2680 aboveState = reader.method_8320(abovePos);
        if (state.method_27852(class_2246.field_10477) && (Integer)state.method_11654((class_2769)class_2488.field_11518) == 1) {
            return true;
        }
        if (state.method_26227().method_15761() == 8) {
            return false;
        }
        return !SpreadableSnowyDirtSlab.doesOcclude((class_1922)reader, state, pos, aboveState, abovePos, class_2350.field_11036);
    }

    public static boolean canBeGrass(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        class_2248 bl = blockState.method_26204();
        if (bl instanceof DirtSlabBlock) {
            return SpreadableSnowyDirtSlab.canBeGrassNewSlab(blockState, levelReader, blockPos);
        }
        return class_2500.method_10614((class_2680)blockState, (class_4538)levelReader, (class_2338)blockPos);
    }

    private static boolean canPropagate(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        class_2338 blockPos2 = blockPos.method_10084();
        return SpreadableSnowyDirtSlab.canBeGrass(blockState, levelReader, blockPos) && !levelReader.method_8316(blockPos2).method_15767(class_3486.field_15517);
    }

    public static void spreadingTick(class_2248 me, class_2680 blockState, class_3218 level, class_2338 blockPos, class_5819 random) {
        if (!Configs.BLOCK_CONFIG.isEnabled(WunderreichSlabBlocks.DIRT_SLAB) || !Configs.BLOCK_CONFIG.isEnabled(WunderreichSlabBlocks.GRASS_SLAB)) {
            return;
        }
        if (!SpreadableSnowyDirtSlab.canBeGrass(blockState, (class_4538)level, blockPos)) {
            class_2680 testState = level.method_8320(blockPos);
            if (me instanceof SpreadableSnowyDirtSlab) {
                level.method_8501(blockPos, (class_2680)((class_2680)WunderreichSlabBlocks.DIRT_SLAB.method_9564().method_11657((class_2769)field_11502, (Comparable)((Boolean)testState.method_11654((class_2769)field_11502)))).method_11657((class_2769)field_11501, (Comparable)((class_2771)testState.method_11654((class_2769)field_11501))));
            } else if (me instanceof class_2500) {
                level.method_8501(blockPos, class_2246.field_10566.method_9564());
            }
            return;
        }
        if (level.method_22339(blockPos.method_10084()) >= 9) {
            class_2680 grassSlabBlockState = WunderreichSlabBlocks.GRASS_SLAB.method_9564();
            class_2680 grassBlockState = class_2246.field_10219.method_9564();
            for (int i = 0; i < 2; ++i) {
                class_2338 testPos = blockPos.method_10069(random.method_43048(3) - 1, random.method_43048(5) - 3, random.method_43048(3) - 1);
                class_2680 testState = level.method_8320(testPos);
                if (!SpreadableSnowyDirtSlab.canPropagate(testState, (class_4538)level, testPos)) continue;
                if (testState.method_27852(class_2246.field_10566)) {
                    level.method_8501(testPos, (class_2680)grassBlockState.method_11657((class_2769)SNOWY, (Comparable)Boolean.valueOf(level.method_8320(testPos.method_10084()).method_27852(class_2246.field_10477))));
                    continue;
                }
                if (!testState.method_27852(WunderreichSlabBlocks.DIRT_SLAB)) continue;
                class_2680 newState = (class_2680)((class_2680)((class_2680)grassSlabBlockState.method_11657((class_2769)SNOWY, (Comparable)Boolean.valueOf(level.method_8320(testPos.method_10084()).method_27852(class_2246.field_10477)))).method_11657((class_2769)field_11502, (Comparable)((Boolean)testState.method_11654((class_2769)field_11502)))).method_11657((class_2769)field_11501, (Comparable)((class_2771)testState.method_11654((class_2769)field_11501)));
                level.method_8501(testPos, newState);
            }
        }
    }

    public void method_9514(class_2680 blockState, class_3218 level, class_2338 blockPos, class_5819 random) {
        SpreadableSnowyDirtSlab.spreadingTick((class_2248)this, blockState, level, blockPos, random);
    }

    public static class GrassSlab
    extends SpreadableSnowyDirtSlab {
        public GrassSlab(class_2248 baseBlock) {
            super(baseBlock);
        }

        @Override
        public void supplyTags(Consumer<class_6862<class_2248>> blockTags, Consumer<class_6862<class_1792>> itemTags) {
            blockTags.accept((class_6862<class_2248>)class_3481.field_15469);
            itemTags.accept((class_6862<class_1792>)class_3489.field_15535);
            blockTags.accept((class_6862<class_2248>)class_3481.field_33716);
        }
    }
}

