/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.advancements;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.advancements.Condition;
import de.ambertation.wunderreich.advancements.Criteria;
import de.ambertation.wunderreich.advancements.Display;
import de.ambertation.wunderreich.advancements.ItemCondition;
import de.ambertation.wunderreich.advancements.RecipeCondition;
import de.ambertation.wunderreich.advancements.RecipeReward;
import de.ambertation.wunderreich.advancements.Reward;
import de.ambertation.wunderreich.registries.WunderreichAdvancements;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class AdvancementsJsonBuilder {
    private static final ThreadLocal<AdvancementsJsonBuilder> BUILDER = ThreadLocal.withInitial(AdvancementsJsonBuilder::new);
    private final Map<String, Criteria> criteria = new HashMap<String, Criteria>();
    private final List<Reward> rewards = new ArrayList<Reward>(0);
    public class_2960 ID;
    public AdvancementType type;
    private String parent;
    private Display display;
    private boolean canBuild = true;

    private AdvancementsJsonBuilder() {
    }

    public static void invalidate() {
        BUILDER.remove();
        Display.DISPLAY.remove();
    }

    public static AdvancementsJsonBuilder create(String name) {
        return BUILDER.get().reset(Wunderreich.ID(name), AdvancementType.REGULAR);
    }

    public static AdvancementsJsonBuilder create(String name, AdvancementType type) {
        return BUILDER.get().reset(Wunderreich.ID(name), type);
    }

    public static AdvancementsJsonBuilder create(class_1792 item) {
        return AdvancementsJsonBuilder.create(item, AdvancementType.REGULAR, b -> {});
    }

    public static AdvancementsJsonBuilder create(class_1792 item, AdvancementType type) {
        return AdvancementsJsonBuilder.create(item, type, b -> {});
    }

    public static AdvancementsJsonBuilder create(class_1792 item, Consumer<DisplayBuilder> builder) {
        return AdvancementsJsonBuilder.create(item, AdvancementType.REGULAR, builder);
    }

    public static AdvancementsJsonBuilder create(class_1792 item, AdvancementType type, Consumer<DisplayBuilder> builder) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        boolean canBuild = true;
        if (id == null) {
            canBuild = false;
            id = class_7923.field_41178.method_10137();
        }
        String baseName = "advancements." + id.method_12836() + "." + id.method_12832() + ".";
        AdvancementsJsonBuilder b = BUILDER.get().reset(id, type);
        if (builder != null) {
            b.startDisplay(item, baseName + "title", baseName + "description", builder);
        }
        b.canBuild = canBuild;
        return b;
    }

    public static AdvancementsJsonBuilder createRecipe(class_1792 item, AdvancementType type) {
        return AdvancementsJsonBuilder.create(item, type, null).awardRecipe(item).gotRecipeCriteria("has_the_recipe", item);
    }

    private AdvancementsJsonBuilder reset(class_2960 id, AdvancementType type) {
        if (type == AdvancementType.RECIPE_DECORATIONS) {
            this.ID = new class_2960(id.method_12836(), "recipes/decorations/" + id.method_12832());
            this.parent = "minecraft:recipes/root";
        } else if (type == AdvancementType.RECIPE_TOOL) {
            this.ID = new class_2960(id.method_12836(), "recipes/tools/" + id.method_12832());
            this.parent = "minecraft:recipes/root";
        } else {
            this.ID = id;
            this.parent = null;
        }
        this.type = type;
        this.display = null;
        this.criteria.clear();
        this.rewards.clear();
        this.canBuild = true;
        return this;
    }

    public AdvancementsJsonBuilder parent(class_2960 parent) {
        this.parent = parent.toString();
        return this;
    }

    public AdvancementsJsonBuilder parent(String parent) {
        this.parent = parent;
        return this;
    }

    public AdvancementsJsonBuilder startDisplay(class_1792 icon, Consumer<DisplayBuilder> builder) {
        String baseName = "advancements." + this.ID.method_12836() + "." + this.ID.method_12832() + ".";
        return this.startDisplay(icon, baseName + "title", baseName + "description", builder);
    }

    public AdvancementsJsonBuilder startDisplay(class_1792 icon, String title, String description, Consumer<DisplayBuilder> builder) {
        class_2960 id = class_7923.field_41178.method_10221((Object)icon);
        if (id == null) {
            id = class_7923.field_41178.method_10137();
            this.canBuild = false;
        }
        this.display = Display.DISPLAY.get().reset(id.toString(), title, description);
        builder.accept(new DisplayBuilder(this, this.display));
        return this;
    }

    public AdvancementsJsonBuilder gotRecipeCriteria(String name, class_1792 item) {
        return this.startCriteria(name, "minecraft:recipe_unlocked", builder -> builder.recipeCondition(item));
    }

    public AdvancementsJsonBuilder inventoryChangedCriteria(String name, class_1792 ... items) {
        return this.startCriteria(name, "minecraft:inventory_changed", builder -> builder.itemsCondition(items));
    }

    public AdvancementsJsonBuilder startCriteria(String name, String trigger, Consumer<CriteriaBuilder> builder) {
        Criteria c = new Criteria(trigger);
        this.criteria.put(name, c);
        builder.accept(new CriteriaBuilder(this, c));
        return this;
    }

    public AdvancementsJsonBuilder awardRecipe(class_1792 ... items) {
        RecipeReward rew = new RecipeReward();
        for (class_1792 item : items) {
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            if (id == null) continue;
            rew.addRecipe(id.toString());
        }
        this.rewards.add(rew);
        return this;
    }

    public class_2960 register() {
        if (!this.canBuild) {
            return null;
        }
        JsonElement res = this.build();
        WunderreichAdvancements.ADVANCEMENTS.put(this.ID, res);
        return this.ID;
    }

    public JsonElement build() {
        if (!this.canBuild) {
            return null;
        }
        JsonObject root = new JsonObject();
        if (this.parent != null) {
            root.add("parent", (JsonElement)new JsonPrimitive(this.parent));
        }
        if (this.display != null) {
            root.add("display", (JsonElement)this.display.serialize());
        }
        if (!this.criteria.isEmpty()) {
            JsonObject critObj = new JsonObject();
            JsonArray requirements = new JsonArray();
            this.criteria.forEach((key, value) -> {
                critObj.add(key, (JsonElement)value.serialize());
                requirements.add((JsonElement)new JsonPrimitive(key));
            });
            root.add("criteria", (JsonElement)critObj);
            JsonArray a = new JsonArray();
            a.add((JsonElement)requirements);
            root.add("requirements", (JsonElement)a);
        }
        if (!this.rewards.isEmpty()) {
            JsonObject obj = new JsonObject();
            this.rewards.forEach(r -> r.serialize(obj));
            root.add("rewards", (JsonElement)obj);
        }
        return root;
    }

    public static enum AdvancementType {
        REGULAR,
        RECIPE_DECORATIONS,
        RECIPE_TOOL;

    }

    public static class DisplayBuilder {
        final AdvancementsJsonBuilder base;
        final Display display;

        DisplayBuilder(AdvancementsJsonBuilder base, Display display) {
            this.base = base;
            this.display = display;
        }

        protected DisplayBuilder frame(String value) {
            this.display.frame = value;
            return this;
        }

        public DisplayBuilder background(String value) {
            this.display.background = value;
            return this;
        }

        public DisplayBuilder showToast() {
            this.display.showToast = true;
            return this;
        }

        public DisplayBuilder hideToast() {
            this.display.showToast = false;
            return this;
        }

        public DisplayBuilder hidden() {
            this.display.hidden = true;
            return this;
        }

        public DisplayBuilder visible() {
            this.display.hidden = false;
            return this;
        }

        public DisplayBuilder announceToChat() {
            this.display.announceToChat = true;
            return this;
        }

        public DisplayBuilder hideFromChat() {
            this.display.announceToChat = false;
            return this;
        }

        public DisplayBuilder frame(class_189 type) {
            return this.frame(type.method_831());
        }

        public DisplayBuilder challenge() {
            return this.frame(class_189.field_1250);
        }

        public DisplayBuilder task() {
            return this.frame(class_189.field_1254);
        }

        public DisplayBuilder goal() {
            return this.frame(class_189.field_1249);
        }
    }

    public static class CriteriaBuilder {
        final AdvancementsJsonBuilder base;
        final Criteria criteria;

        CriteriaBuilder(AdvancementsJsonBuilder base, Criteria c) {
            this.base = base;
            this.criteria = c;
        }

        protected CriteriaBuilder addCondition(Condition c) {
            this.criteria.addCondition(c);
            return this;
        }

        public CriteriaBuilder itemsCondition(class_1792 ... items) {
            ItemCondition cond = new ItemCondition();
            for (class_1792 item : items) {
                class_2960 id = class_7923.field_41178.method_10221((Object)item);
                if (id == null) {
                    this.base.canBuild = false;
                    continue;
                }
                cond.addItem(id.toString());
            }
            this.criteria.addCondition(cond);
            return this;
        }

        public CriteriaBuilder recipeCondition(class_1792 item) {
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            if (id == null) {
                this.base.canBuild = false;
                return this;
            }
            return this.recipeCondition(id.toString());
        }

        public CriteriaBuilder recipeCondition(String id) {
            RecipeCondition cond = new RecipeCondition(id);
            this.criteria.addCondition(cond);
            return this;
        }
    }
}

