/*
 * Decompiled with CFR 0.152.
 */
package com.chefmoon.ubesdelight.registry;

import com.chefmoon.ubesdelight.block.BakingMatBlock;
import com.chefmoon.ubesdelight.block.DrinkableFeastBlock;
import com.chefmoon.ubesdelight.block.GarlicCropBlock;
import com.chefmoon.ubesdelight.block.GingerCropBlock;
import com.chefmoon.ubesdelight.block.GlassCupBlock;
import com.chefmoon.ubesdelight.block.HaloHaloFeast;
import com.chefmoon.ubesdelight.block.KalanBlock;
import com.chefmoon.ubesdelight.block.LecheFlanFeast;
import com.chefmoon.ubesdelight.block.LemongrassCropBlock;
import com.chefmoon.ubesdelight.block.LemongrassLeafCropBlock;
import com.chefmoon.ubesdelight.block.LemongrassStalkCropBlock;
import com.chefmoon.ubesdelight.block.LumpiaFeast;
import com.chefmoon.ubesdelight.block.TallWildCropBlock;
import com.chefmoon.ubesdelight.block.UbeCropBlock;
import com.chefmoon.ubesdelight.block.UbesDelightCakeBlock;
import com.chefmoon.ubesdelight.block.WildCropBlock;
import com.chefmoon.ubesdelight.registry.ItemsRegistry;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2362;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;

public enum BlocksRegistry {
    KALAN("kalan", KalanBlock::new),
    BAKING_MAT_BAMBOO("baking_mat_bamboo", BakingMatBlock::new, true),
    UBE_CRATE("ube_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    GARLIC_CRATE("garlic_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    GINGER_CRATE("ginger_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    LEMONGRASS_CRATE("lemongrass_crate", () -> new class_2248(FabricBlockSettings.method_9630((class_4970)class_2246.field_10161).method_36557(2.0f).method_36558(3.0f).method_9626(class_2498.field_11547))),
    WILD_UBE("wild_ube", WildCropBlock::new, true, BlocksRegistry.flammable(100, 60)),
    WILD_GARLIC("wild_garlic", WildCropBlock::new, true, BlocksRegistry.flammable(100, 60)),
    WILD_GINGER("wild_ginger", WildCropBlock::new, true, BlocksRegistry.flammable(100, 60)),
    WILD_LEMONGRASS("wild_lemongrass", TallWildCropBlock::new, true, BlocksRegistry.flammable(100, 60)),
    POTTED_UBE("potted_ube", () -> new class_2362(WILD_UBE.get(), FabricBlockSettings.method_9630((class_4970)class_2246.field_10354)), true, BlocksRegistry.flammable(100, 60)),
    POTTED_GARLIC("potted_garlic", () -> new class_2362(WILD_GARLIC.get(), FabricBlockSettings.method_9630((class_4970)class_2246.field_10354)), true, BlocksRegistry.flammable(100, 60)),
    POTTED_GINGER("potted_ginger", () -> new class_2362(WILD_GINGER.get(), FabricBlockSettings.method_9630((class_4970)class_2246.field_10354)), true, BlocksRegistry.flammable(100, 60)),
    UBE_CROP("ube_crop", UbeCropBlock::new, true),
    GARLIC_CROP("garlic_crop", GarlicCropBlock::new, true),
    GINGER_CROP("ginger_crop", GingerCropBlock::new, true),
    LEMONGRASS_CROP("lemongrass_crop", LemongrassCropBlock::new, true),
    LEMONGRASS_STALK_CROP("lemongrass_stalk_crop", LemongrassStalkCropBlock::new, true),
    LEMONGRASS_LEAF_CROP("lemongrass_leaf_crop", LemongrassLeafCropBlock::new, true),
    GLASS_CUP_HALO_HALO("glass_cup_halo_halo", GlassCupBlock::new, true),
    UBE_CAKE("ube_cake", () -> new UbesDelightCakeBlock(ItemsRegistry.UBE_CAKE_SLICE.get()), true),
    LECHE_FLAN_FEAST("leche_flan_feast", () -> new LecheFlanFeast(ItemsRegistry.LECHE_FLAN.get()), true),
    HALO_HALO_FEAST("halo_halo_feast", () -> new HaloHaloFeast(ItemsRegistry.HALO_HALO.get()), true),
    MILK_TEA_UBE_FEAST("milk_tea_ube_feast", () -> new DrinkableFeastBlock(ItemsRegistry.MILK_TEA_UBE.get()), true),
    LUMPIA_FEAST("lumpia_feast", () -> new LumpiaFeast(ItemsRegistry.LUMPIA.get()), true);

    private final String pathName;
    private final Supplier<class_2248> blockSupplier;
    private final FlammableBlockRegistry.Entry flammableRate;
    private final boolean isCutout;
    private class_2248 block;

    private static FlammableBlockRegistry.Entry flammable(int burnChance, int spreadChance) {
        return new FlammableBlockRegistry.Entry(burnChance, spreadChance);
    }

    private static boolean isValidFlammableEntry(FlammableBlockRegistry.Entry flammableRate) {
        return flammableRate != null && flammableRate.getBurnChance() > 0 && flammableRate.getSpreadChance() > 0;
    }

    private BlocksRegistry(String pathName, Supplier<class_2248> blockSupplier) {
        this(pathName, blockSupplier, false, new FlammableBlockRegistry.Entry(0, 0));
    }

    private BlocksRegistry(String pathName, Supplier<class_2248> blockSupplier, boolean isCutout) {
        this(pathName, blockSupplier, isCutout, new FlammableBlockRegistry.Entry(0, 0));
    }

    private BlocksRegistry(String pathName, Supplier<class_2248> blockSupplier, boolean isCutout, FlammableBlockRegistry.Entry flammableRate) {
        this.pathName = pathName;
        this.blockSupplier = blockSupplier;
        this.flammableRate = flammableRate;
        this.isCutout = isCutout;
    }

    public static void registerAll() {
        for (BlocksRegistry value : BlocksRegistry.values()) {
            class_2248 block = value.get();
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("ubesdelight", value.pathName), (Object)block);
            if (!BlocksRegistry.isValidFlammableEntry(value.flammableRate)) continue;
            FlammableBlockRegistry.getDefaultInstance().add(block, (Object)value.flammableRate);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerRenderLayer() {
        for (BlocksRegistry value : BlocksRegistry.values()) {
            if (!value.isCutout) continue;
            BlockRenderLayerMap.INSTANCE.putBlock(value.get(), class_1921.method_23581());
        }
    }

    public class_2248 get() {
        if (this.block == null) {
            this.block = this.blockSupplier.get();
        }
        return this.block;
    }

    public String getId() {
        return class_7923.field_41175.method_10221((Object)this.get()).toString();
    }

    public String getPathName() {
        return this.pathName;
    }
}

