/*
 * Decompiled with CFR 0.152.
 */
package com.chefmoon.ubesdelight;

import com.chefmoon.ubesdelight.UbesDelightMod;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.fabricmc.loader.api.FabricLoader;

public final class Configuration {
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "ubesdelight.json");
    private boolean enableUDCropCrates = true;
    private boolean farmersBuyUDCrops = true;
    private boolean wanderingTraderSellsUDItems = true;
    private boolean isFoodEffectTooltip = true;
    private boolean generateUDChestLoot = true;
    private boolean generateWildUbe = true;
    private int chanceWildUbe = 50;
    private boolean generateWildGarlic = true;
    private int chanceWildGarlic = 80;
    private boolean generateWildGinger = true;
    private int chanceWildGinger = 80;
    private boolean generateWildLemongrass = true;
    private int chanceWildLemongrass = 80;
    private boolean enableGarlicCompat = false;
    private boolean enableGingerCompat = false;

    public static Configuration load() {
        Configuration configuration = new Configuration();
        if (!CONFIG_FILE.exists()) {
            Configuration.save(configuration);
        }
        try {
            BufferedReader reader = Files.newBufferedReader(CONFIG_FILE.toPath());
            configuration = (Configuration)new GsonBuilder().setPrettyPrinting().create().fromJson((Reader)reader, Configuration.class);
            ((Reader)reader).close();
        }
        catch (IOException e) {
            UbesDelightMod.LOGGER.error("Error while trying to load configuration file. Default configuration used.", (Throwable)e);
        }
        return configuration;
    }

    public static void save(Configuration config) {
        try {
            BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE.toPath(), new OpenOption[0]);
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)config, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            UbesDelightMod.LOGGER.error("Error while trying to save configuration file.", (Throwable)e);
        }
    }

    public boolean isEnableUDCropCrates() {
        return this.enableUDCropCrates;
    }

    public void setEnableUDCropCrates(boolean enableUDCropCrates) {
        this.enableUDCropCrates = enableUDCropCrates;
    }

    public boolean isFarmersBuyUDCrops() {
        return this.farmersBuyUDCrops;
    }

    public void setFarmersBuyUDCrops(boolean farmersBuyUDCrops) {
        this.farmersBuyUDCrops = farmersBuyUDCrops;
    }

    public boolean isWanderingTraderSellsUDItems() {
        return this.wanderingTraderSellsUDItems;
    }

    public void setWanderingTraderSellsUDItems(boolean wanderingTraderSellsUDItems) {
        this.wanderingTraderSellsUDItems = wanderingTraderSellsUDItems;
    }

    public boolean isFoodEffectTooltip() {
        return this.isFoodEffectTooltip;
    }

    public void setFoodEffectTooltip(boolean foodEffectTooltip) {
        this.isFoodEffectTooltip = foodEffectTooltip;
    }

    public boolean isGenerateUDChestLoot() {
        return this.generateUDChestLoot;
    }

    public void setGenerateUDChestLoot(boolean generateUDChestLoot) {
        this.generateUDChestLoot = generateUDChestLoot;
    }

    public boolean isGenerateWildUbe() {
        return this.generateWildUbe;
    }

    public void setGenerateWildUbe(boolean generateWildUbe) {
        this.generateWildUbe = generateWildUbe;
    }

    public int getChanceWildUbe() {
        return this.chanceWildUbe;
    }

    public void setChanceWildUbe(int chanceWildUbe) {
        this.chanceWildUbe = chanceWildUbe;
    }

    public boolean isGenerateWildGarlic() {
        return this.generateWildGarlic;
    }

    public void setGenerateWildGarlic(boolean generateWildGarlic) {
        this.generateWildGarlic = generateWildGarlic;
    }

    public int getChanceWildGarlic() {
        return this.chanceWildGarlic;
    }

    public void setChanceWildGarlic(int chanceWildGarlic) {
        this.chanceWildGarlic = chanceWildGarlic;
    }

    public boolean isGenerateWildGinger() {
        return this.generateWildGinger;
    }

    public void setGenerateWildGinger(boolean generateWildGinger) {
        this.generateWildGinger = generateWildGinger;
    }

    public int getChanceWildGinger() {
        return this.chanceWildGinger;
    }

    public void setChanceWildGinger(int chanceWildGinger) {
        this.chanceWildGinger = chanceWildGinger;
    }

    public boolean isGenerateWildLemongrass() {
        return this.generateWildLemongrass;
    }

    public void setGenerateWildLemongrass(boolean generateWildLemongrass) {
        this.generateWildLemongrass = generateWildLemongrass;
    }

    public int getChanceWildLemongrass() {
        return this.chanceWildLemongrass;
    }

    public void setChanceWildLemongrass(int chanceWildLemongrass) {
        this.chanceWildLemongrass = chanceWildLemongrass;
    }

    public boolean isEnableGarlicCompat() {
        return this.enableGarlicCompat;
    }

    public void setEnableGarlicCompat(boolean enableGarlicCompat) {
        this.enableGarlicCompat = enableGarlicCompat;
    }

    public boolean isEnableGingerCompat() {
        return this.enableGingerCompat;
    }

    public void setEnableGingerCompat(boolean enableGingerCompat) {
        this.enableGingerCompat = enableGingerCompat;
    }
}

