/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.ui.container.WrappingParentComponent;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.util.ScissorStack;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

@ApiStatus.Experimental
public class RenderEffectWrapper<C extends Component>
extends WrappingParentComponent<C> {
    protected static final List<class_276> FRAMEBUFFERS = new ArrayList<class_276>();
    protected static int drawDepth = 0;
    protected final List<RenderEffectSlot> effects = new ArrayList<RenderEffectSlot>();

    protected RenderEffectWrapper(C child) {
        super(Sizing.content(), Sizing.content(), child);
        this.allowOverflow = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        try {
            ++drawDepth;
            class_1041 window = class_310.method_1551().method_22683();
            while (drawDepth > FRAMEBUFFERS.size()) {
                FRAMEBUFFERS.add((class_276)new class_6367(window.method_4489(), window.method_4506(), true, class_310.field_1703));
            }
            int previousFramebuffer = GlStateManager.getBoundFramebuffer();
            class_276 framebuffer = FRAMEBUFFERS.get(drawDepth - 1);
            framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
            ScissorStack.drawUnclipped(() -> framebuffer.method_1230(class_310.field_1703));
            framebuffer.method_1235(false);
            this.drawChildren(context, mouseX, mouseY, partialTicks, delta, this.childView);
            GlStateManager._glBindFramebuffer((int)36160, (int)previousFramebuffer);
            ListIterator<RenderEffectSlot> iter = this.effects.listIterator();
            while (iter.hasNext()) {
                iter.next().effect.setup(this, context, partialTicks, delta);
            }
            class_287 buffer = RenderSystem.renderThreadTesselator().method_1349();
            Matrix4f matrix = context.method_51448().method_23760().method_23761();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            buffer.method_22918(matrix, 0.0f, (float)window.method_4502(), 0.0f).method_22913(0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
            buffer.method_22918(matrix, (float)window.method_4486(), (float)window.method_4502(), 0.0f).method_22913(1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
            buffer.method_22918(matrix, (float)window.method_4486(), 0.0f, 0.0f).method_22913(1.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
            buffer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
            RenderSystem.setShaderTexture((int)0, (int)framebuffer.method_30277());
            RenderSystem.setShader(class_757::method_34543);
            class_286.method_43433((class_287.class_7433)buffer.method_1326());
            while (iter.hasPrevious()) {
                iter.previous().effect.cleanup(this, context, partialTicks, delta);
            }
        }
        finally {
            --drawDepth;
        }
    }

    public RenderEffectSlot effect(RenderEffect effect) {
        RenderEffectSlot slot = new RenderEffectSlot(effect);
        this.effects.add(slot);
        return slot;
    }

    public void clearEffects() {
        this.effects.clear();
    }

    static {
        WindowResizeCallback.EVENT.register((client, window) -> FRAMEBUFFERS.forEach(framebuffer -> framebuffer.method_1234(window.method_4489(), window.method_4506(), class_310.field_1703)));
    }

    public class RenderEffectSlot {
        protected RenderEffect effect;

        protected RenderEffectSlot(RenderEffect effect) {
            this.effect = effect;
        }

        public void update(RenderEffect newEffect) {
            this.effect = newEffect;
        }

        public void remove() {
            RenderEffectWrapper.this.effects.remove(this);
        }
    }

    public static interface RenderEffect {
        public void setup(Component var1, class_332 var2, float var3, float var4);

        public void cleanup(Component var1, class_332 var2, float var3, float var4);

        public static RenderEffect rotate(float angle) {
            return RenderEffect.rotate(class_7833.field_40718, angle);
        }

        public static RenderEffect rotate(final class_7833 axis, final float angle) {
            return new RenderEffect(){

                @Override
                public void setup(Component component, class_332 context, float partialTicks, float delta) {
                    Size size = component.fullSize();
                    class_4587 matrices = context.method_51448();
                    matrices.method_22903();
                    matrices.method_46416((float)component.x() + (float)size.width() / 2.0f, (float)component.y() + (float)size.height() / 2.0f, 0.0f);
                    matrices.method_22907(axis.rotationDegrees(angle));
                    matrices.method_46416(-((float)component.x() + (float)size.width() / 2.0f), -((float)component.y() + (float)size.height() / 2.0f), 0.0f);
                }

                @Override
                public void cleanup(Component component, class_332 context, float partialTicks, float delta) {
                    context.method_51448().method_22909();
                }
            };
        }

        public static RenderEffect color(final Color color) {
            return new RenderEffect(){
                private float[] colors = null;

                @Override
                public void setup(Component component, class_332 context, float partialTicks, float delta) {
                    this.colors = (float[])RenderSystem.getShaderColor().clone();
                    RenderSystem.setShaderColor((float)(this.colors[0] * color.red()), (float)(this.colors[1] * color.green()), (float)(this.colors[2] * color.blue()), (float)(this.colors[3] * color.alpha()));
                    if (color.alpha() != 1.0f) {
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                    }
                }

                @Override
                public void cleanup(Component component, class_332 context, float partialTicks, float delta) {
                    RenderSystem.setShaderColor((float)this.colors[0], (float)this.colors[1], (float)this.colors[2], (float)this.colors[3]);
                }
            };
        }

        public static RenderEffect transform(Matrix4f transform) {
            return RenderEffect.transform((class_4587 matrices) -> matrices.method_34425(transform));
        }

        public static RenderEffect transform(final Consumer<class_4587> transform) {
            return new RenderEffect(){

                @Override
                public void setup(Component component, class_332 context, float partialTicks, float delta) {
                    context.method_51448().method_22903();
                    transform.accept(context.method_51448());
                }

                @Override
                public void cleanup(Component component, class_332 context, float partialTicks, float delta) {
                    context.method_51448().method_22909();
                }
            };
        }
    }
}

