/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.entity.entities;

import com.yahoo.chirpycricket.wildlife.entity.WildlifeEntity;
import com.yahoo.chirpycricket.wildlife.registry.Entities;
import com.yahoo.chirpycricket.wildlife.registry.Sounds;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_7;

public abstract class TerrestrialEntity
extends WildlifeEntity {
    @Override
    public String getDefaultTexture() {
        if (this.textures.size() > 0) {
            return (String)this.textures.get(0);
        }
        return "iguana.png";
    }

    public TerrestrialEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn, Entities.EntityKey key) {
        super(type, worldIn, key);
        this.leashYOffset = 0.45f;
        this.leashZOffset = 0.35f;
        this.wanderFrequency = WildlifeEntity.Wander.INFREQUENTLY;
    }

    public TerrestrialEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn, Entities.EntityKey key, boolean shouldSwim) {
        super(type, worldIn, key, shouldSwim, true);
        this.leashYOffset = 0.45f;
        this.leashZOffset = 0.35f;
        this.wanderFrequency = WildlifeEntity.Wander.INFREQUENTLY;
    }

    public static class BadgerEntity
    extends TerrestrialEntity {
        public BadgerEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.BADGER);
            this.textures.add("badger.png");
            this.textures.add("badger_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.BADGER)).item;
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.BADGER_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.BADGER_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.BADGER_DEATH_EVENT;
        }
    }

    public static class PorcupineEntity
    extends TerrestrialEntity {
        public PorcupineEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.PORCUPINE);
            this.textures.add("porcupine.png");
            this.textures.add("porcupine_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.PORCUPINE)).item;
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.PORCUPINE_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.PORCUPINE_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.PORCUPINE_DEATH_EVENT;
        }
    }

    public static class BeaverEntity
    extends TerrestrialEntity {
        public BeaverEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.BEAVER);
            this.textures.add("beaver.png");
            this.textures.add("beaver_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.BEAVER)).item;
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.BEAVER_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.BEAVER_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.BEAVER_DEATH_EVENT;
        }
    }

    public static class ArmadilloEntity
    extends TerrestrialEntity {
        public ArmadilloEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.ARMADILLO);
            this.textures.add("armadillo.png");
            this.textures.add("armadillo_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.ARMADILLO)).item;
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.ARMADILLO_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.ARMADILLO_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.ARMADILLO_DEATH_EVENT;
        }
    }

    public static class AntEaterEntity
    extends TerrestrialEntity {
        float[] sizes = new float[]{1.0f, 1.4f, 0.8f, 1.65f};

        public AntEaterEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.ANTEATER);
            this.varyScale = true;
            this.textures.add("anteater.png");
            this.textures.add("anteater_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.ANTEATER)).item;
        }

        @Override
        public float getEntitySize() {
            return this.sizes[this.field_5974.method_39332(0, this.sizes.length - 1)];
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.ANTEATER_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.ANTEATER_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.ANTEATER_DEATH_EVENT;
        }
    }

    public static class PossumEntity
    extends TerrestrialEntity {
        public PossumEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.POSSUM);
            this.textures.add("possum.png");
            this.textures.add("possum_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.POSSUM)).item;
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.POSSUM_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.POSSUM_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.POSSUM_DEATH_EVENT;
        }
    }

    public static class CapybaraEntity
    extends TerrestrialEntity {
        float[] sizes = new float[]{1.0f, 1.4f, 0.8f, 1.65f, 1.8f, 2.0f, 2.5f};

        public CapybaraEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.CAPYBARA);
            this.varyScale = true;
            this.textures.add("capybara.png");
            this.textures.add("capybara.png");
            this.textures.add("capybara.png");
            this.textures.add("capybara.png");
            this.textures.add("capybara2.png");
            this.textures.add("capybara3.png");
            this.textures.add("capybara3.png");
            this.textures.add("capybara3.png");
            this.textures.add("capybara3.png");
            this.textures.add("capybara4.png");
            this.textures.add("capybara5.png");
            this.textures.add("capybara5.png");
            this.textures.add("capybara5.png");
            this.textures.add("capybara_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.CAPYBARA)).item;
        }

        @Override
        public float getEntitySize() {
            return this.sizes[this.field_5974.method_39332(0, this.sizes.length - 1)];
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.CAPYBARA_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.CAPYBARA_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.CAPYBARA_DEATH_EVENT;
        }
    }

    public static class BoarEntity
    extends TerrestrialEntity {
        float[] sizes = new float[]{1.0f, 1.4f, 0.8f, 1.65f};

        public BoarEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.BOAR);
            this.varyScale = true;
            this.textures.add("boar.png");
            this.textures.add("boar2.png");
            this.textures.add("boar3.png");
            this.textures.add("boar_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.BOAR)).item;
        }

        @Override
        public float getEntitySize() {
            return this.sizes[this.field_5974.method_39332(0, this.sizes.length - 1)];
        }

        @Override
        protected class_3414 method_5994() {
            if (this.method_6510()) {
                return Sounds.BOAR_ANGRY_EVENT;
            }
            return Sounds.BOAR_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.BOAR_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.BOAR_DEATH_EVENT;
        }
    }

    public static class DeerEntity
    extends TerrestrialEntity {
        public DeerEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.DEER);
            this.textures.add("deer.png");
            this.textures.add("deer2.png");
            this.textures.add("deer_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.DEER)).item;
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.DEER_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.DEER_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.DEER_DEATH_EVENT;
        }
    }

    public static class MonkeyEntity
    extends TerrestrialEntity {
        float[] sizes = new float[]{1.0f, 1.2f, 0.8f};

        public MonkeyEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.MONKEY);
            this.varyScale = true;
            this.textures.add("monkey.png");
            this.textures.add("monkey.png");
            this.textures.add("monkey.png");
            this.textures.add("monkey2.png");
            this.textures.add("monkey3.png");
            this.textures.add("monkey_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.MONKEY)).item;
        }

        @Override
        public float getEntitySize() {
            return this.sizes[this.field_5974.method_39332(0, this.sizes.length - 1)];
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.MONKEY_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.MONKEY_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.MONKEY_DEATH_EVENT;
        }
    }

    public static class IguanaEntity
    extends TerrestrialEntity {
        public IguanaEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.IGUANA);
            this.textures.add("iguana.png");
            this.textures.add("iguana_amelanistic.png");
            this.textures.add("iguana_axanthic.png");
            this.textures.add("iguana_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.IGUANA)).item;
        }

        @Override
        protected String getRandomTexture() {
            if (Math.random() > 0.95) {
                return (String)this.textures.get(this.field_5974.method_39332(1, this.textures.size() - 1));
            }
            return (String)this.textures.get(0);
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.IGUANA_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.IGUANA_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.IGUANA_DEATH_EVENT;
        }
    }

    public static class AlligatorEntity
    extends TerrestrialEntity {
        float[] sizes = new float[]{1.0f, 1.5f, 2.0f};

        public AlligatorEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.ALLIGATOR, false);
            this.varyScale = true;
            this.textures.add("alligator.png");
            this.textures.add("alligator_albino.png");
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.ALLIGATOR)).item;
            this.method_5941(class_7.field_18, 0.0f);
        }

        @Override
        public float getEntitySize() {
            return this.sizes[this.field_5974.method_39332(0, this.sizes.length - 1)];
        }

        public boolean method_6094() {
            return true;
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.ALLIGATOR_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.ALLIGATOR_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.ALLIGATOR_DEATH_EVENT;
        }
    }
}

