/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.entity.entities;

import com.yahoo.chirpycricket.wildlife.entity.SmallWildlifeEntity;
import com.yahoo.chirpycricket.wildlife.entity.WildlifeEntity;
import com.yahoo.chirpycricket.wildlife.registry.Entities;
import com.yahoo.chirpycricket.wildlife.registry.Sounds;
import java.awt.Color;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_3414;

public abstract class SmallTerrestrialEntity
extends SmallWildlifeEntity {
    @Override
    public String getDefaultTexture() {
        return "small_terrestrial.png";
    }

    public SmallTerrestrialEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn, Entities.EntityKey key) {
        super(type, worldIn, key);
        this.textures.add("small_terrestrial.png");
        this.textures.add("small_terrestrial_albino.png");
        this.leashYOffset = 0.45f;
        this.leashZOffset = 0.35f;
        this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)key)).item;
        this.wanderFrequency = WildlifeEntity.Wander.INFREQUENTLY;
        this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)this.entityKey)).item;
        this.wildlifeEntityItemAlbino = Entities.entityMap.get((Object)((Object)this.entityKey)).item_albino;
    }

    public static class HedgehogEntity
    extends SmallTerrestrialEntity {
        public HedgehogEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.HEDGEHOG);
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.HEDGEHOG_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.HEDGEHOG_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.HEDGEHOG_DEATH_EVENT;
        }
    }

    public static class FerretEntity
    extends SmallTerrestrialEntity {
        public FerretEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.FERRET);
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.FERRET_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.FERRET_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.FERRET_DEATH_EVENT;
        }
    }

    public static class HamsterEntity
    extends SmallTerrestrialEntity {
        public HamsterEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.HAMSTER);
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.HAMSTER_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.HAMSTER_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.HAMSTER_DEATH_EVENT;
        }
    }

    public static class ChameleonEntity
    extends SmallTerrestrialEntity {
        boolean change = true;
        float color = -1.0f;
        float count = 0.0f;

        public ChameleonEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.CHAMELEON);
            this.wildlifeEntityItem = Entities.entityMap.get((Object)((Object)Entities.EntityKey.CHAMELEON)).item;
            int[] newTints = new int[]{0xFFFFFE, 6446157, 5201976, 5213304, 9200975, 16346397, 3256150, 5655666, 13734848, 10705496, 0x191212};
            this.tints = newTints;
            if (this.getVariant().equals(this.textures.get(this.textures.size() - 1))) {
                this.change = false;
            }
        }

        @Override
        public void method_5773() {
            super.method_5773();
            if (this.getVariant().equals(this.textures.get(this.textures.size() - 1))) {
                return;
            }
            if (this.color < 0.0f) {
                this.color = this.getTint();
            }
            this.count += 1.0f;
            this.count %= 1000.0f;
            if (!this.method_37908().field_9236 && this.count == 0.0f) {
                this.color += 0.05f;
                if (this.color >= 1.0f) {
                    this.color = 0.0f;
                }
                this.setTint(Color.HSBtoRGB(this.color, 1.0f, 1.0f) & 0xFFFFFF);
            }
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.CHAMELEON_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.CHAMELEON_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.CHAMELEON_DEATH_EVENT;
        }
    }

    public static class GeckoEntity
    extends SmallTerrestrialEntity {
        public GeckoEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.GECKO);
            int[] newTints = new int[]{0xFFFFFF, 6446157, 5201976, 5213304, 9200975, 16346397, 3256150, 5655666, 13734848, 10705496, 0x191212};
            this.tints = newTints;
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.GECKO_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.GECKO_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.GECKO_DEATH_EVENT;
        }
    }

    public static class GrassSnakeEntity
    extends SmallTerrestrialEntity {
        public GrassSnakeEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.GRASS_SNAKE);
            this.textures.clear();
            this.textures.add("small_snakes.png");
            this.textures.add("small_snakes_albino.png");
        }

        @Override
        public String getDefaultTexture() {
            return "small_snakes.png";
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.GRASS_SNAKE_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.GRASS_SNAKE_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.GRASS_SNAKE_DEATH_EVENT;
        }
    }

    public static class MilkSnakeEntity
    extends SmallTerrestrialEntity {
        public MilkSnakeEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.MILK_SNAKE);
            this.textures.clear();
            this.textures.add("small_snakes.png");
            this.textures.add("small_snakes_albino.png");
        }

        @Override
        public String getDefaultTexture() {
            return "small_snakes.png";
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.MILK_SNAKE_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.MILK_SNAKE_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.MILK_SNAKE_DEATH_EVENT;
        }
    }

    public static class PythonEntity
    extends SmallTerrestrialEntity {
        public PythonEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.PYTHON);
            this.textures.clear();
            this.textures.add("small_snakes.png");
            this.textures.add("small_snakes_albino.png");
        }

        @Override
        public String getDefaultTexture() {
            return "small_snakes.png";
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.PYTHON_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.PYTHON_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.PYTHON_DEATH_EVENT;
        }
    }

    public static class KingSnakeEntity
    extends SmallTerrestrialEntity {
        public KingSnakeEntity(class_1299<? extends WildlifeEntity> type, class_1937 worldIn) {
            super(type, worldIn, Entities.EntityKey.KING_SNAKE);
            this.textures.clear();
            this.textures.add("small_snakes.png");
            this.textures.add("small_snakes_albino.png");
        }

        @Override
        public String getDefaultTexture() {
            return "small_snakes.png";
        }

        @Override
        protected class_3414 method_5994() {
            return Sounds.KING_SNAKE_AMBIENT_EVENT;
        }

        @Override
        protected class_3414 method_6011(class_1282 source) {
            return Sounds.KING_SNAKE_HURT_EVENT;
        }

        @Override
        protected class_3414 method_6002() {
            return Sounds.KING_SNAKE_DEATH_EVENT;
        }
    }
}

