/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.yahoo.chirpycricket.wildlife.Wildlife;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigFileHelper {
    public static final String configFileName = "WildlifeConfig.json";

    protected static BufferedReader readOrCreateSettingsFile() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDir() + File.separator + configFileName));
            return br;
        }
        catch (FileNotFoundException e) {
            try {
                System.out.println("Created config file for wildlife mod.");
                ConfigFileHelper.createDefaultSettings();
                try {
                    br = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDir() + File.separator + configFileName));
                    return br;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return br;
        }
    }

    protected static void createDefaultSettings() throws IOException {
        FileWriter myWriter = new FileWriter(FabricLoader.getInstance().getConfigDir() + File.separator + configFileName);
        myWriter.write("{ \r\n  \"globalSettings\": { \r\n    \"configVersion\": 5, \r\n    \"printBiomes\": false, \r\n    \"globalDebug\": false, \r\n    \"mobCap\": 100, \r\n    \"mobCapRange\": 192 \r\n  }, \r\n  \"biomeGroups\": { \r\n    \"deserts\": [\"mesa\",\"savanna\",\"desert\"], \r\n    \"jungles\": [\"jungles\"], \r\n    \"temperate\": [\"plains\",\"forest\",\"mushroom\"], \r\n    \"shores\": [\"beach\",\"minecraft:stony_shore\",\"minecraft:beach\"], \r\n    \"swamps\": [\"swamp\"], \r\n    \"cold\": [\"mountain\",\"taiga\",\"extreme_hills\"], \r\n    \"snowy\": [\"mountain\",\"icy\"], \r\n    \"mountains\": [\"mountain\",\"extreme_hills\"], \r\n    \"forests\": [\"forest\",\"mushroom\",\"taiga\"], \r\n    \"warmForests\": [\"forest\",\"mushroom\"], \r\n    \"oldForests\": [\"Old Growth Pine Taiga\",\"Old Growth Spruce Taiga\",\"Giant Tree Taiga Hills\",\"Giant Spruce Taiga Hills\",\"Giant Tree Taiga\",\"Giant Spruce Taiga\"], \r\n    \"freshWater\": [\"minecraft:river\",\"minecraft:swamp\"], \r\n    \"saltWater\": [\"ocean\"], \r\n    \"warmOcean\": [\"minecraft:deep_lukewarm_ocean\",\"minecraft:lukewarm_ocean\",\"minecraft:warm_ocean\"], \r\n    \"coldOcean\": [\"minecraft:cold_ocean\",\"minecraft:deep_cold_ocean\",\"minecraft:frozen_ocean\",\"minecraft:deep_frozen_ocean\"], \r\n    \"shallowOcean\": [\"minecraft:ocean\",\"minecraft:frozen_ocean\",\"minecraft:cold_ocean\",\"minecraft:lukewarm_ocean\",\"minecraft:warm_ocean\"], \r\n    \"deepOcean\": [\"minecraft:deep_ocean\",\"minecraft:deep_frozen_ocean\",\"minecraft:deep_cold_ocean\",\"minecraft:deep_lukewarm_ocean\"] \r\n  }, \r\n  \"itemGroups\": { \r\n    \"flowerItems\": [\"sugar\",\"dandelion\",\"poppy\",\"blue_orchid\",\"allium\",\"azure_bluet\",\"red_tulip\",\"orange_tulip\",\"white_tulip\",\"pink_tulip\",\"oxeye_daisy\",\"cornflower\",\"lily_of_the_valley\",\"lilac\",\"rose_bush\",\"peony\",\"flowering_azalea_leaves\"], \r\n    \"grassItems\": [\"hay\",\"grass\",\"fern\",\"tall_grass\",\"large_fern\",\"bamboo\"], \r\n    \"leafItems\": [\"oak_leaves\",\"spruce_leaves\",\"birch_leaves\",\"jungle_leaves\",\"acacia_leaves\",\"dark_oak_leaves\",\"azalea_leaves\",\"flowering_azalea_leaves\",\"lily_pad\",\"small_dripleaf\",\"big_dripleaf\"], \r\n    \"mushroomItems\": [\"brown_mushroom\",\"red_mushroom\",\"crimson_fungus\",\"warped_fungus\"], \r\n    \"rootItems\": [\"cave_vines\",\"vines\",\"hanging_roots\",\"glow_lichen\",\"crimson_roots\",\"warped_roots\",\"nether_wart\",\"cactus\"], \r\n    \"seedItems\": [\"wheat_seeds\",\"melon_seeds\",\"pumpkin_seeds\",\"beetroot_seeds\",\"sweet_berries\"], \r\n    \"vegetableItems\": [\"potato\",\"carrot\",\"beetroot\"], \r\n    \"fruitItems\": [\"sweet_berries\",\"melon_slice\",\"apple\",\"glow_berries\"], \r\n    \"seaweedItems\": [\"seagrass\",\"kelp\",\"tall_seagrass\"], \r\n    \"fishItems\": [\"salmon\",\"cod\",\"tropical_fish\",\"pufferfish\",\"wildlife.raw_anglerfish\",\"wildlife.raw_bettafish\",\"wildlife.raw_bluegill\",\"wildlife.raw_catfish\",\"wildlife.raw_goldfish\",\"wildlife.raw_prawn\",\"wildlife.raw_shrimp\",\"wildlife.raw_rainbow_trout\"], \r\n    \"meatItems\": [\"rabbit\",\"chicken\",\"mutton\",\"beef\",\"porkchop\",\"egg\"], \r\n    \"insectItems\": [\"wildlife:ant\",\"wildlife:cricket\",\"wildlife:dragonfly\",\"wildlife:glasswing_butterfly\",\"wildlife:monarch_butterfly\",\"wildlife:tiger_butterfly\",\"wildlife:spicebush_butterfly\",\"wildlife:morpho_butterfly\",\"wildlife:june_beetle\",\"wildlife:ladybug\",\"wildlife:rhino_beetle\",\"wildlife:snail\",\"wildlife:spider\",\"wildlife:staghorn_beetle\",\"wildlife:stickbug\",\"wildlife:sunflower_beetle\"], \r\n    \"scavengerItems\": [\"egg\",\"rotten_flesh\",\"spider_eye\"] \r\n  }, \r\n  \"itemGroupCategories\": { \r\n    \"nectar\": [\"flowerItems\", \"fruitItems\"], \r\n    \"leafyHerbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\"], \r\n    \"heartyHerbivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\"], \r\n    \"herbivore\": [\"grassItems\", \"leafItems\", \"flowerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"], \r\n    \"omnivore\": [\"vegetableItems\", \"fruitItems\", \"mushroomItems\", \"meatItems\", \"scavengerItems\"], \r\n    \"carnivore\": [\"meatItems\", \"fishItems\"], \r\n    \"bird\": [\"seedItems\", \"insectItems\"], \r\n    \"bug\": [\"grassItems\", \"leafItems\", \"flowerItems\", \"rootItems\"], \r\n    \"scavenger\": [\"scavengerItems\", \"vegetableItems\", \"fruitItems\", \"mushroomItems\"], \r\n    \"oceanScavenger\": [\"seaweedItems\", \"scavengerItems\", \"fishItems\", \"vegetableItems\"] \r\n  }, \r\n  \"spawnCategories\": { \r\n    \"birdSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 3, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 2, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"bugSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 3, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 2, \r\n      \"chunkOffset\": 1, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"smallAnimalSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 4, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 3, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"mediumAnimalSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 4, \r\n      \"spawnRandomChance\": 50, \r\n      \"chunkFreq\": 3, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"beachSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 40, \r\n      \"spawnRandomChance\": 100, \r\n      \"chunkFreq\": 1, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"overworld\", \r\n      \"minSpawnGroupSize\": 4, \r\n      \"maxSpawnGroupSize\": 6 \r\n    }, \r\n    \"seaFloorSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 20, \r\n      \"spawnRandomChance\": 100, \r\n      \"chunkFreq\": 1, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"water\", \r\n      \"minSpawnGroupSize\": 2, \r\n      \"maxSpawnGroupSize\": 4 \r\n    }, \r\n    \"fishSpawnSettings\": { \r\n      \"shouldSpawn\": true, \r\n      \"spawnDebug\": false, \r\n      \"spawnWeight\": 10, \r\n      \"spawnRandomChance\": 100, \r\n      \"chunkFreq\": 1, \r\n      \"chunkOffset\": 0, \r\n      \"spawnType\": \"water\", \r\n      \"minSpawnGroupSize\": 3, \r\n      \"maxSpawnGroupSize\": 6 \r\n    } \r\n  }, \r\n  \"mobConfig\": { \r\n    \"SPARROW\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"all overworld\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"COTTONBIRD\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"mountains\",\"snowy\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"WHITE_EYE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"FLYCATCHER\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"LARK\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"all overworld\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"ROBIN\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"CHICKADEE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"biomeGroups\": [ \"forests\",\"cold\",\"snowy\",\"mountains\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"TOWHEE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [ \"mountains\",\"snowy\",\"cold\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"WREN\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"MEADOWLARK\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"cold\"], \r\n      \"spawnWeight\": 3, \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"ORIOLE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"BLUEBIRD\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"GOLDFINCH\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"cold\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"PHOEBE\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"cold\",\"snowy\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"SWALLOW\": { \r\n      \"spawnCategory\": \"birdSpawnSettings\", \r\n      \"spawnBiomes\": [\"swamps\",\"jungles\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bird\"] \r\n    }, \r\n    \"CRICKET\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\"], \r\n      \"health\": 4, \r\n      \"loudness\": 100, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"GLASSWING_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"MONARCH_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"warmForests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"MORPHO_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"TIGER_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"warmForests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"SPICEBUSH_BUTTERFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"forests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"nectar\"] \r\n    }, \r\n    \"DRAGONFLY\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"LADYBUG\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"SUNFLOWERBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"ANT\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"bug\"] \r\n    }, \r\n    \"SPIDER\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"SNAIL\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"Speed\": 0.01, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"STICKBUG\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"JUNEBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"RHINOBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"forests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"STAGHORNBEETLE\": { \r\n      \"spawnCategory\": \"bugSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"jungles\",\"forests\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"BADGER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"mountains\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"omnivore\"] \r\n    }, \r\n    \"PORCUPINE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"mountains\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"herbivore\"] \r\n    }, \r\n    \"BEAVER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"swamps\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"herbivore\"] \r\n    }, \r\n    \"ARMADILLO\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"scavenger\"] \r\n    }, \r\n    \"ANTEATER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"POSSUM\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"scavenger\"] \r\n    }, \r\n    \"CAPYBARA\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"grassItems\",\"vegetableItems\",\"fruitItems\"] \r\n    }, \r\n    \"BOAR\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"oldForests\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"heartyHerbivore\"] \r\n    }, \r\n    \"DEER\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"oldForests\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"herbivore\"] \r\n    }, \r\n    \"MONKEY\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"fruitItems\",\"egg\"] \r\n    }, \r\n    \"IGUANA\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"leafyHerbivore\",\"fruitItems\"] \r\n    }, \r\n    \"CRAB\": { \r\n      \"spawnCategory\": \"beachSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"HERMITCRAB\": { \r\n      \"spawnCategory\": \"beachSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"HEDGEHOG\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"forests\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"insectItems\",\"heartyHerbivore\"] \r\n    }, \r\n    \"FERRET\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"temperate\",\"mountains\",\"forests\",\"cold\",\"snowy\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    }, \r\n    \"HAMSTER\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"seedItems\",\"heartyHerbivore\"] \r\n    }, \r\n    \"CHAMELEON\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\"], \r\n      \"health\": 7, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"GECKO\": { \r\n      \"spawnCategory\": \"smallAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"deserts\",\"jungles\",\"temperate\"], \r\n      \"health\": 4, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"GRASS_SNAKE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"temperate\"], \r\n      \"health\": 8, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"KING_SNAKE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"temperate\",\"swamps\",\"deserts\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    }, \r\n    \"MILK_SNAKE\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 8, \r\n      \"breedingItems\": [\"insectItems\",\"carnivore\"] \r\n    }, \r\n    \"PYTHON\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\",\"deserts\"], \r\n      \"health\": 15, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    }, \r\n    \"BLUEGILL\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"RAINBOW_TROUT\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"KOI\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"BETTAFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"GOLDFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"PRAWN\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"SHRIMP\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"saltWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"ANGLERFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"deepOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"JELLYFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"saltWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"GLOW_JELLYFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"deepOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"SEAHORSE\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"STINGRAY\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"MANTARAY\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"HAMMERHEAD_SHARK\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"warmOcean\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"fishItems\"] \r\n    }, \r\n    \"CLAM\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"saltWater\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"SEAURCHIN\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"saltWater\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"STARFISH\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"saltWater\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"HORSESHOE_CRAB\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"shallowOcean\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"SANDDOLLAR\": { \r\n      \"spawnCategory\": \"seaFloorSpawnSettings\", \r\n      \"spawnBiomes\": [\"shores\",\"shallowOcean\"], \r\n      \"health\": 10, \r\n      \"breedingItems\": [\"oceanScavenger\"] \r\n    }, \r\n    \"CATFISH\": { \r\n      \"spawnCategory\": \"fishSpawnSettings\", \r\n      \"spawnBiomes\": [\"freshWater\"], \r\n      \"health\": 3, \r\n      \"breedingItems\": [\"insectItems\"] \r\n    }, \r\n    \"ALLIGATOR\": { \r\n      \"spawnCategory\": \"mediumAnimalSpawnSettings\", \r\n      \"spawnBiomes\": [\"jungles\",\"swamps\",\"deserts\"], \r\n      \"isAggressive\": true, \r\n      \"health\": 25, \r\n      \"breedingItems\": [\"carnivore\"] \r\n    } \r\n  } \r\n}");
        myWriter.close();
    }

    protected static void createMergedSettings(JsonObject newJson) throws IOException {
        FileWriter myWriter = new FileWriter(FabricLoader.getInstance().getConfigDir() + File.separator + configFileName);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(newJson.toString());
        String prettyJson = gson.toJson(je);
        myWriter.write(prettyJson);
        myWriter.close();
    }

    protected static void createBackupSettingsFile(int configVersion) throws IOException {
        System.out.println("Current config file is outdated. Created backup and regenerated new config for Wildlife mod.");
        FileWriter myWriter = new FileWriter(FabricLoader.getInstance().getConfigDir() + File.separator + "WildlifeConfig.json.backup_version" + configVersion + ".json");
        BufferedReader br = new BufferedReader(new FileReader(FabricLoader.getInstance().getConfigDir() + File.separator + configFileName));
        for (Object line : br.lines().toArray()) {
            myWriter.write(line + System.lineSeparator());
        }
        myWriter.close();
        br.close();
    }

    private static InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = Wildlife.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream;
    }
}

