/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.data.condition.ResourceConditionContext;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Collection;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class ConditionalRecipeSerializer
implements class_1865<class_1860<?>> {
    private static final class_3956<DummyRecipe> DUMMY_RECIPE_TYPE = class_3956.method_17726((String)"supermartijn642corelib:dummy");
    public static final ConditionalRecipeSerializer INSTANCE = new ConditionalRecipeSerializer();

    public static JsonObject wrapRecipe(JsonObject recipe, Collection<ResourceCondition> conditions) {
        JsonObject json = new JsonObject();
        json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(INSTANCE).toString());
        JsonArray conditionsJson = new JsonArray();
        for (ResourceCondition condition : conditions) {
            JsonObject conditionJson = new JsonObject();
            conditionJson.addProperty("type", Registries.RESOURCE_CONDITION_SERIALIZERS.getIdentifier(condition.getSerializer()).toString());
            condition.getSerializer().serialize(conditionJson, condition);
            conditionsJson.add((JsonElement)conditionJson);
        }
        json.add("conditions", (JsonElement)conditionsJson);
        json.add("recipe", (JsonElement)recipe);
        return json;
    }

    private ConditionalRecipeSerializer() {
    }

    public class_1860<?> method_8121(class_2960 location, JsonObject json) {
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new RuntimeException("Conditional recipe '" + location + "' must have 'conditions' array!");
        }
        if (!json.has("recipe") || !json.get("recipe").isJsonObject()) {
            throw new RuntimeException("Conditional recipe '" + location + "' must have 'recipe' object!");
        }
        JsonArray conditions = json.getAsJsonArray("conditions");
        for (JsonElement conditionElement : conditions) {
            Object condition;
            if (!conditionElement.isJsonObject()) {
                throw new RuntimeException("Conditions array for recipe '" + location + "' must only contain objects!");
            }
            JsonObject conditionJson = conditionElement.getAsJsonObject();
            if (!(conditionJson.has("type") && conditionJson.get("type").isJsonPrimitive() && conditionJson.get("type").getAsJsonPrimitive().isString())) {
                throw new RuntimeException("Condition for recipe '" + location + "' is missing 'type' key!");
            }
            String type = conditionJson.get("type").getAsString();
            if (!RegistryUtil.isValidIdentifier(type)) {
                throw new RuntimeException("Condition for recipe '" + location + "' has invalid type '" + type + "'!");
            }
            ResourceConditionSerializer<?> serializer = Registries.RESOURCE_CONDITION_SERIALIZERS.getValue(new class_2960(type));
            if (serializer == null) {
                throw new RuntimeException("Condition for recipe '" + location + "' has unknown type '" + new class_2960(type) + "'!");
            }
            try {
                condition = serializer.deserialize(conditionJson);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered exception whilst testing condition '" + new class_2960(type) + "' for recipe '" + location + "'!");
            }
            if (condition.test(new ResourceConditionContext())) continue;
            return new DummyRecipe(location);
        }
        return class_1863.method_17720((class_2960)location, (JsonObject)json.getAsJsonObject("recipe"));
    }

    public class_1860<?> method_8122(class_2960 resourceLocation, class_2540 friendlyByteBuf) {
        return new DummyRecipe(resourceLocation);
    }

    public void method_8124(class_2540 friendlyByteBuf, class_1860<?> recipe) {
    }

    private record DummyRecipe(class_2960 identifier) implements class_1860<class_1263>
    {
        public boolean method_8115(class_1263 container, class_1937 level) {
            return false;
        }

        public class_1799 method_8116(class_1263 container, class_5455 registryAccess) {
            return class_1799.field_8037;
        }

        public boolean method_8113(int i, int j) {
            return false;
        }

        public class_1799 method_8110(class_5455 registryAccess) {
            return class_1799.field_8037;
        }

        public class_2960 method_8114() {
            return this.identifier;
        }

        public class_1865<?> method_8119() {
            return INSTANCE;
        }

        public class_3956<?> method_17716() {
            return DUMMY_RECIPE_TYPE;
        }

        public boolean method_31584() {
            return true;
        }
    }
}

