/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.registry.Registries;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class BaseBlock
extends class_2248 {
    private final boolean saveTileData;
    private final BlockProperties properties;

    private BaseBlock(boolean saveTileData, class_4970.class_2251 properties, BlockProperties blockProperties) {
        super(properties);
        this.saveTileData = saveTileData;
        this.properties = blockProperties;
        if (blockProperties != null) {
            this.field_23156 = blockProperties.lootTable;
        }
    }

    public BaseBlock(boolean saveTileData, class_4970.class_2251 properties) {
        this(saveTileData, properties, null);
    }

    public BaseBlock(boolean saveTileData, BlockProperties properties) {
        this(saveTileData, properties.toUnderlying(), properties);
    }

    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        if (!this.saveTileData) {
            return;
        }
        class_2487 tag = stack.method_7969();
        class_2487 class_24872 = tag == null ? null : (tag = tag.method_10545("tileData") ? tag.method_10562("tileData") : null);
        if (tag == null || tag.method_33133()) {
            return;
        }
        class_2586 entity = worldIn.method_8321(pos);
        if (entity instanceof BaseBlockEntity) {
            ((BaseBlockEntity)entity).readData(tag);
        }
    }

    public class_2960 method_26162() {
        if (this.field_23156 == null) {
            if (this.properties != null && this.properties.noLootTable) {
                this.field_23156 = class_39.field_844;
            } else if (this.properties != null && this.properties.lootTable != null) {
                this.field_23156 = this.properties.lootTable;
            } else if (this.properties != null && this.properties.lootTableBlock != null) {
                class_2248 block = this.properties.lootTableBlock.get();
                if (block == null) {
                    CoreLib.LOGGER.warn("Received null block from BlockProperties#lootTableFrom's supplier for block '" + Registries.BLOCKS.getIdentifier(this) + "'!");
                    return super.method_26162();
                }
                if (block.field_23155.field_10666 == null) {
                    return super.method_26162();
                }
                this.field_23156 = block.field_23155.field_10666;
            } else {
                return super.method_26162();
            }
        }
        return this.field_23156;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List items = super.method_9560(state, builder);
        if (!this.saveTileData) {
            return items;
        }
        class_2586 entity = (class_2586)builder.method_51876(class_181.field_1228);
        if (!(entity instanceof BaseBlockEntity)) {
            return items;
        }
        class_2487 entityTag = ((BaseBlockEntity)entity).writeItemStackData();
        if (entityTag == null || entityTag.method_33133()) {
            return items;
        }
        class_2487 tag = new class_2487();
        tag.method_10566("tileData", (class_2520)entityTag);
        for (class_1799 stack : items) {
            if (!(stack.method_7909() instanceof class_1747) || ((class_1747)stack.method_7909()).method_7711() != this) continue;
            stack.method_7980(tag);
        }
        return items;
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(world, pos, state);
        if (!this.saveTileData) {
            return stack;
        }
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof BaseBlockEntity)) {
            return stack;
        }
        class_2487 entityTag = ((BaseBlockEntity)entity).writeItemStackData();
        if (entityTag == null || entityTag.method_33133()) {
            return stack;
        }
        class_2487 tag = new class_2487();
        tag.method_10566("tileData", (class_2520)entityTag);
        if (stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() == this) {
            stack.method_7980(tag);
        }
        return stack;
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        return this.interact((class_2680)state, (class_1937)level, (class_2338)pos, (class_1657)player, (class_1268)hand, (class_2350)hitResult.method_17780(), (class_243)hitResult.method_17784()).interactionResult;
    }

    protected InteractionFeedback interact(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_2350 hitSide, class_243 hitLocation) {
        return InteractionFeedback.PASS;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> information, class_1836 flag) {
        this.appendItemInformation(stack, level, information::add, flag.method_8035());
        super.method_9568(stack, level, information, flag);
    }

    protected void appendItemInformation(class_1799 stack, @Nullable class_1922 level, Consumer<class_2561> info, boolean advanced) {
    }

    public class_1792 method_8389() {
        return super.method_8389();
    }

    public String method_9539() {
        class_2960 identifier = Registries.BLOCKS.getIdentifier(this);
        return identifier.method_12836() + ".block." + identifier.method_12832();
    }

    protected static enum InteractionFeedback {
        PASS(class_1269.field_5811),
        CONSUME(class_1269.field_21466),
        SUCCESS(class_1269.field_5812);

        private final class_1269 interactionResult;

        private InteractionFeedback(class_1269 interactionResult) {
            this.interactionResult = interactionResult;
        }
    }
}

