/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.equipment.goggles.GoggleOverlayRenderer;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import snownee.jade.addon.create.CreatePlugin;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public class GogglesProvider
implements IBlockComponentProvider {
    private static final Set<String> REMOVE_KEYS = Set.of("create.tooltip.chute.contains", "create.tooltip.deployer.contains");
    private final class_2248 PISTON_EXTENSION_POLE = GogglesProvider.block("piston_extension_pole");

    private static class_2248 block(String id) {
        return (class_2248)class_7923.field_41175.method_10223(new class_2960("create", id));
    }

    public class_2960 getUid() {
        return CreatePlugin.GOGGLES;
    }

    public void appendTooltip(ITooltip tooltip1, BlockAccessor accessor, IPluginConfig config) {
        boolean exceptionAdded;
        FluidTankBlockEntity tank;
        if (config.get(CreatePlugin.GOGGLES_DETAILED) && !accessor.showDetails()) {
            return;
        }
        class_1937 world = accessor.getLevel();
        class_2338 pos = GoggleOverlayRenderer.proxiedOverlayPosition((class_1937)world, (class_2338)accessor.getPosition());
        class_2586 te = world.method_8321(pos);
        boolean wearingGoggles = !config.get(CreatePlugin.REQUIRES_GOGGLES) || GogglesItem.isWearingGoggles((class_1657)accessor.getPlayer());
        boolean hasGoggleInformation = te instanceof IHaveGoggleInformation && !(te instanceof SpoutBlockEntity) && !(te instanceof ItemDrainBlockEntity) && !(te instanceof BasinBlockEntity) && (!(te instanceof FluidTankBlockEntity) || (tank = (FluidTankBlockEntity)te).getControllerBE() == null || tank.getControllerBE().boiler.isActive());
        boolean hasHoveringInformation = te instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ArrayList<Object> tooltip = new ArrayList<Object>();
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)te;
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, accessor.showDetails());
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add(Components.immutableEmpty());
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)te;
            hoverAddedInformation = hte.addToTooltip(tooltip, accessor.showDetails());
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (te instanceof IDisplayAssemblyExceptions && (exceptionAdded = ((IDisplayAssemblyExceptions)te).addExceptionToTooltip(tooltip))) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (!hasHoveringInformation) {
            hasHoveringInformation = hoverAddedInformation = TrainRelocator.addToTooltip(tooltip, (boolean)accessor.showDetails());
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            return;
        }
        tooltip.removeIf(c -> {
            for (class_2561 sibling : c.method_10855()) {
                class_2588 contents;
                class_7417 patt4944$temp = sibling.method_10851();
                if (!(patt4944$temp instanceof class_2588) || !REMOVE_KEYS.contains((contents = (class_2588)patt4944$temp).method_11022())) continue;
                return true;
            }
            return false;
        });
        tooltip.replaceAll(c -> {
            class_2585 literal;
            class_7417 patt5141$temp = c.method_10851();
            if (patt5141$temp instanceof class_2585 && (literal = (class_2585)patt5141$temp).comp_737().startsWith("    ")) {
                class_5250 mutableComponent = class_2561.method_43470((String)literal.comp_737().substring(4)).method_27696(c.method_10866());
                c.method_10855().forEach(arg_0 -> ((class_5250)mutableComponent).method_10852(arg_0));
                return mutableComponent;
            }
            return c;
        });
        class_2680 state = world.method_8320(pos);
        if (wearingGoggles && state.method_27852(this.PISTON_EXTENSION_POLE)) {
            class_2350[] directions = Iterate.directionsInAxis((class_2350.class_2351)((class_2350)state.method_11654((class_2769)class_2318.field_10927)).method_10166());
            int poles = 1;
            boolean pistonFound = false;
            for (class_2350 dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles(world, pos, dir);
                poles += attachedPoles;
                pistonFound |= world.method_8320(pos.method_10079(dir, attachedPoles + 1)).method_26204() instanceof MechanicalPistonBlock;
            }
            if (!pistonFound) {
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(Components.immutableEmpty());
            }
            tooltip.add(Lang.translateDirect((String)"gui.goggles.pole_length", (Object[])new Object[0]).method_10852((class_2561)Components.literal((String)(" " + poles))));
        }
        tooltip.stream().map(c -> {
            if (c.getString().isBlank()) {
                return IElementHelper.get().spacer(3, 3);
            }
            return IElementHelper.get().text(c);
        }).forEach(arg_0 -> ((ITooltip)tooltip1).add(arg_0));
    }

    public boolean enabledByDefault() {
        return false;
    }
}

