/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.tileentity;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7923;
import shetiphian.core.common.Function;
import shetiphian.core.common.NameHelper;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.ILoadStateAware;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.StorageAccessMode;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.LocationManager;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;

public class TileEntityEnderTank
extends TileEntityBase
implements IRGB16_Tile,
ILoadStateAware {
    private String code = "000";
    private String ownerID = null;
    private String owner = "all";
    private class_1799 personalItem;
    private final ArrayList<class_1799> pumpUpgrades = new ArrayList();
    public long lastClick = 0L;
    private final List<String> usedUpgrades = new ArrayList<String>();
    private String comparedHandler = "";

    public TileEntityEnderTank(class_2338 pos, class_2680 state) {
        super(Roster.Tiles.ENDERTANK, pos, state);
    }

    public void buildNBT(class_2487 nbtTag) {
        nbtTag.method_10582("code", this.getCode());
        nbtTag.method_10582("owner", this.owner);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            nbtTag.method_10582("owner.id", this.ownerID);
        }
        nbtTag.method_10582("owner_id", this.getOwnerID());
        if (!this.pumpUpgrades.isEmpty()) {
            class_2499 listItems = new class_2499();
            for (class_1799 stack : this.pumpUpgrades) {
                class_2487 compound = new class_2487();
                stack.method_7953(compound);
                listItems.add((Object)compound);
            }
            nbtTag.method_10566("upgrade.pump", (class_2520)listItems);
        }
        if (this.personalItem != null) {
            class_2487 compound = new class_2487();
            this.personalItem.method_7953(compound);
            nbtTag.method_10566("upgrade.access", (class_2520)compound);
            nbtTag.method_10582("personal", class_7923.field_41178.method_10221((Object)this.personalItem.method_7909()).toString());
        }
        if (!this.usedUpgrades.isEmpty()) {
            class_2499 listNBT = new class_2499();
            for (String upgrade : this.usedUpgrades) {
                listNBT.add((Object)class_2519.method_23256((String)upgrade));
            }
            nbtTag.method_10566("used_upgrades", (class_2520)listNBT);
        }
        if (!Strings.isNullOrEmpty((String)this.comparedHandler)) {
            nbtTag.method_10582("compared", this.comparedHandler);
        }
    }

    public void processNBT(class_2487 nbtTag) {
        this.setCode(nbtTag.method_10558("code"));
        this.owner = nbtTag.method_10558("owner");
        if (nbtTag.method_10545("owner.id")) {
            this.ownerID = nbtTag.method_10558("owner.id");
        }
        if (nbtTag.method_10545("upgrade.pump")) {
            this.pumpUpgrades.clear();
            class_2499 listItems = nbtTag.method_10554("upgrade.pump", 10);
            for (int entry2 = 0; entry2 < listItems.size(); ++entry2) {
                class_2487 compound = listItems.method_10602(entry2);
                class_1799 stack = class_1799.method_7915((class_2487)compound);
                if (stack.method_7960()) continue;
                if (stack.method_7947() != 1) {
                    stack.method_7939(1);
                }
                this.pumpUpgrades.add(stack);
            }
        }
        if (nbtTag.method_10545("upgrade.access")) {
            class_1799 stack = class_1799.method_7915((class_2487)nbtTag.method_10562("upgrade.access"));
            if (!stack.method_7960() && stack.method_7947() != 1) {
                stack.method_7939(1);
            }
            this.personalItem = stack;
        }
        if (nbtTag.method_10545("used_upgrades")) {
            this.usedUpgrades.clear();
            class_2499 listNBT = nbtTag.method_10554("used_upgrades", 8);
            listNBT.listIterator().forEachRemaining(entry -> this.usedUpgrades.add(entry.method_10714()));
        }
        this.comparedHandler = nbtTag.method_10558("compared");
    }

    public void processNBT_SaveOnly(class_2487 nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            this.owner = NameHelper.getDisplayNameFor((String)this.ownerID);
        }
    }

    public boolean applyItem(class_1799 stack) {
        String key = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        if (this.usedUpgrades.contains(key)) {
            return false;
        }
        this.usedUpgrades.add(key);
        return true;
    }

    public <T extends TransferVariant<?>> Storage<T> getTankStorage(Class<T> type, class_2350 facing) {
        Optional<Storage<T>> optional;
        StorageAccessMode accessMode;
        if (this.canBeAutomated() && (accessMode = this.getAccessForFace(facing)) != null && (optional = this.getEnderContainer().getTankFor(type, accessMode)).isPresent()) {
            return optional.get();
        }
        return null;
    }

    private boolean canBeAutomated() {
        return this.isPublic() ? EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.public_automation : (this.isTeam() ? EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.team_automation : EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.personal_automation);
    }

    private StorageAccessMode getAccessForFace(class_2350 facing) {
        class_2680 state;
        class_2350 tFacing;
        if (facing == null) {
            return StorageAccessMode.FULL;
        }
        if (this.field_11863 != null && (tFacing = BlockEnderTank.getFacing(state = this.field_11863.method_8320(this.field_11867))).method_10166() == facing.method_10166()) {
            if (BlockEnderTank.isPowered(state)) {
                return facing == tFacing ? StorageAccessMode.EXTRACT_ONLY : StorageAccessMode.INSERT_ONLY;
            }
            return StorageAccessMode.FULL;
        }
        return null;
    }

    public EnderContainer getEnderContainer() {
        return TankHelper.getTank(this.field_11863, this.getOwnerID(), this.getCode());
    }

    public int getComparatorOutput() {
        if (Strings.isNullOrEmpty((String)this.comparedHandler) && !Strings.isNullOrEmpty((String)HandlerRegistry.getDefaultKey())) {
            this.useDefaultHandler();
        }
        if (!Strings.isNullOrEmpty((String)this.comparedHandler)) {
            if (HandlerRegistry.getProviders().containsKey(this.comparedHandler)) {
                return this.getEnderContainer().getComparatorOutput(this.comparedHandler);
            }
            this.useDefaultHandler();
        }
        return 0;
    }

    private void useDefaultHandler() {
        this.comparedHandler = HandlerRegistry.getDefaultKey();
        if (this.field_11863 != null) {
            this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
        }
    }

    public boolean compareNextHandler(class_1657 player) {
        if (player != null && this.canEdit(player)) {
            String firstEntry = null;
            boolean target = false;
            boolean changed = false;
            for (String key : HandlerRegistry.getProviders().keySet()) {
                if (firstEntry == null) {
                    firstEntry = key;
                    if (Strings.isNullOrEmpty((String)this.comparedHandler)) {
                        this.comparedHandler = key;
                        changed = true;
                        break;
                    }
                }
                if (target) {
                    this.comparedHandler = key;
                    changed = true;
                    break;
                }
                if (!key.equals(this.comparedHandler)) continue;
                target = true;
            }
            if (!(changed || Strings.isNullOrEmpty(firstEntry) || firstEntry.equals(this.comparedHandler))) {
                this.comparedHandler = firstEntry;
                changed = true;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)" :").method_10852((class_2561)class_2561.method_43471((String)class_1802.field_8857.method_7876())).method_27693(" ").method_10852(this.getComparatorTypeDisplayName()), true);
            return changed;
        }
        return false;
    }

    public class_2561 getComparatorTypeDisplayName() {
        return this.getEnderContainer().getDisplayName(this.comparedHandler);
    }

    public long getPumpCapacity() {
        return this.pumpUpgrades.isEmpty() ? 20250L : (long)this.pumpUpgrades.size() * 81000L;
    }

    public byte getPumpUpgradeCount() {
        return (byte)this.pumpUpgrades.size();
    }

    public void addPumpUpgrade(class_1799 stack) {
        this.pumpUpgrades.add(stack);
    }

    public boolean canEdit(class_1657 player) {
        boolean canEdit = true;
        String msg = "";
        if (!player.method_31549().field_7477) {
            if (this.isTeam()) {
                canEdit = !EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.team_edit_lock || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = !EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.personal_edit_lock || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.method_5667().toString());
                msg = "private.denied";
            }
        }
        if (!canEdit && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canEdit;
    }

    public boolean canUse(class_1657 player) {
        boolean canUse = true;
        String msg = "";
        if (!player.method_31549().field_7477) {
            if (this.isTeam()) {
                canUse = !EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.team_use_lock || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.public_tanks;
                msg = "public.disabled";
            } else {
                canUse = !EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.personal_use_lock || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.method_5667().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks.tank." + msg);
        }
        return canUse;
    }

    public boolean canLink(class_1657 player) {
        boolean canLink = true;
        String msg = "";
        if (!player.method_31549().field_7477) {
            if (this.isTeam()) {
                if (EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.team_buckets) {
                    canLink = !EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.team_link_lock || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "tank.team.denied";
                } else {
                    canLink = false;
                    msg = "bucket.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.personal_buckets) {
                    canLink = !EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.personal_link_lock || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.method_5667().toString());
                    msg = "tank.private.denied";
                } else {
                    canLink = false;
                    msg = "bucket.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            TankInfoHelper.sendError(player, "endertanks." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(class_1657 player) {
        String team = Function.getPlayerTeamID((class_1657)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    private String getOwner() {
        return !Strings.isNullOrEmpty((String)this.owner) ? this.owner : "all";
    }

    public String getOwnerID() {
        if (this.getOwner().equalsIgnoreCase("all")) {
            return "all";
        }
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            return this.ownerID;
        }
        return this.getOwner();
    }

    public String getOwnerName() {
        return TankInfoHelper.getDisplayNameFromOwnerID(this.ownerID);
    }

    public void setOwner(class_1657 player, class_1799 stack) {
        this.clearMyLocation();
        this.personalItem = stack;
        this.owner = player.method_5476().getString();
        this.ownerID = player.method_5667().toString();
        this.setMyLocation();
    }

    public void setOwner(String ownerName, String ownerID, class_1799 stack) {
        this.clearMyLocation();
        if (ownerID != null) {
            this.personalItem = stack;
            this.owner = ownerName;
            this.ownerID = ownerID;
        }
        this.setMyLocation();
    }

    public class_1799 getPersonalItem() {
        if (this.personalItem != null && !this.personalItem.method_7960()) {
            if (this.personalItem.method_7947() != 1) {
                this.personalItem.method_7939(1);
            }
            return this.personalItem;
        }
        return class_1799.field_8037;
    }

    public ArrayList<class_1799> getPumpUpgrades() {
        ArrayList<class_1799> upgrades = new ArrayList<class_1799>();
        if (!this.pumpUpgrades.isEmpty()) {
            for (class_1799 stack : this.pumpUpgrades) {
                if (stack == null) continue;
                if (stack.method_7947() != 1) {
                    stack.method_7939(1);
                }
                upgrades.add(stack);
            }
        }
        return upgrades;
    }

    public boolean isPublic() {
        return this.getOwner().equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.ownerID != null && this.ownerID.startsWith("#");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code.toUpperCase();
    }

    public void setCode(String code) {
        this.clearMyLocation();
        while (((String)code).length() < 3) {
            code = "0" + (String)code;
        }
        this.code = ((String)code).toUpperCase();
        this.setMyLocation();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.ownerID);
    }

    public RGB16 getRGB16(class_1657 player) {
        if (player == null) {
            return null;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(class_1767.method_7791((int)value).method_7792());
    }

    public boolean setRGB16(short rgbIndex, class_1657 player) {
        return this.doColorRing(class_1767.method_7791((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(class_1767 color, class_1657 player) {
        if (player == null || !this.canEdit(player) || !EnderTanks.CONFIG.COMMON.enable_in_world_coloring) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0 || ring > 2) {
            return false;
        }
        char charColor = Integer.toHexString(color.method_7789()).charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Function.syncTile((class_2586)this);
            return true;
        }
        return false;
    }

    private int getRingHit(class_1657 player) {
        class_265[] shapes = BlockEnderTank.SHAPES.get(this.method_11010().method_11654((class_2769)BlockEnderTank.FACING));
        return Function.getSubShapeHit((class_1297)player, (class_2338)this.field_11867, (class_265[])shapes) - 1;
    }

    private void setMyLocation() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            LocationManager.set(this.getOwnerID(), this.getCode(), this);
        }
    }

    private void clearMyLocation() {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            LocationManager.clear(this.getOwnerID(), this.getCode(), this);
        }
    }

    public void onLoad() {
        this.setMyLocation();
    }

    public void onChunkUnloaded() {
        this.clearMyLocation();
    }
}

