/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.item.IToolMode;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Roster;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.client.EnderTanksClient;
import shetiphian.endertanks.common.misc.FluidTransferUtil;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;
import shetiphian.endertanks.mixins.ET_FluidBlock_Accessor;

public class ItemEnderBucket
extends class_1792
implements ITabFiller,
IColored,
IToolMode {
    public ItemEnderBucket(class_1792.class_1793 settings) {
        super(settings);
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            EnderTanksClient.colorize(this);
            EnderTanksClient.addItemPredicate(this, "type", (stack, world, entity, number) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f));
        });
    }

    public void fillCreativeTab(class_1761.class_7704 entries, class_1761.class_8128 context) {
        for (String code : StackHelper.BASE_CODES) {
            entries.method_45420(ItemEnderBucket.setMode(StackHelper.create(this, code, null), EnumMode.NORMAL));
        }
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        if (!EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.public_buckets && StackHelper.isPublic(stack)) {
            if (!EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.personal_buckets) {
                String teamID = Function.getPlayerTeamID((class_1657)player);
                if (!Strings.isNullOrEmpty((String)teamID)) {
                    StackHelper.setOwner(stack, "#" + teamID);
                }
            } else {
                StackHelper.setOwner(stack, player.method_5667().toString());
            }
        }
        ItemEnderBucket.setMode(stack, EnumMode.NORMAL);
    }

    @NotNull
    private static class_2487 getTag(@NotNull class_1799 stack) {
        class_2487 nbtTag = stack.method_7948();
        if (!nbtTag.method_10545("mode")) {
            nbtTag.method_10582("mode", EnumMode.NORMAL.toString());
        }
        return nbtTag;
    }

    public static EnumMode getMode(class_1799 stack) {
        return EnumMode.byName(ItemEnderBucket.getTag(stack).method_10558("mode"));
    }

    private static class_1799 setMode(class_1799 stack, EnumMode type) {
        ItemEnderBucket.getTag(stack).method_10582("mode", type.toString());
        return stack;
    }

    public boolean changeMode(class_1657 player, class_1799 stack, boolean reverse) {
        if (!stack.method_7960() && stack.method_7909() instanceof ItemEnderBucket) {
            EnumMode mode = ItemEnderBucket.getMode(stack).next(reverse);
            ItemEnderBucket.setMode(stack, mode);
            if (player != null) {
                TankInfoHelper.sendInfo(player, class_2561.method_43471((String)mode.getTooltip()));
            }
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.method_8608()) {
            boolean placeFluid = ItemEnderBucket.getMode(stack).preformPlace(player.method_5715());
            class_2338 pos = null;
            boolean hitTypeBlock = false;
            class_2350 facing = class_2350.method_10162((class_5819)world.field_9229);
            class_3965 mop = ItemEnderBucket.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)(!placeFluid ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348));
            if (mop != null && mop.method_17783() != class_239.class_240.field_1333) {
                hitTypeBlock = true;
                pos = mop.method_17777();
                facing = mop.method_17780();
            }
            if (pos != null && world.method_8320(pos).method_26204() == Roster.Blocks.ENDERTANK) {
                class_2586 tile;
                if (placeFluid && (tile = world.method_8321(pos)) instanceof TileEntityEnderTank) {
                    TileEntityEnderTank tankTile = (TileEntityEnderTank)tile;
                    if (tankTile.hasError()) {
                        TankInfoHelper.sendLinkError(player, 2);
                    } else {
                        if (tankTile.canLink(player)) {
                            return class_1271.method_22427((Object)StackHelper.create(this, tankTile.getCode(), tankTile.getOwnerID()));
                        }
                        TankInfoHelper.sendLinkError(player, tankTile.isTeam() ? 3 : 1);
                    }
                }
                return class_1271.method_22427((Object)stack);
            }
            if (!StackHelper.isPublic(stack) || EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.public_buckets) {
                boolean showInfo = true;
                if (pos != null) {
                    showInfo = placeFluid ? this.placeLiquid(stack, player, hand, world, pos, facing, hitTypeBlock) : this.pickupLiquid(stack, player, hand, world, pos, facing);
                }
                if (showInfo) {
                    String[] network = new String[]{StackHelper.getOwnerID(stack), StackHelper.getCode(stack)};
                    TankInfoHelper.sendTankInfo(player, StackHelper.getOwnerName(stack), network[0], network[1], player.method_5715());
                }
            } else {
                TankInfoHelper.sendError(player, "endertanks.bucket.public.disabled");
            }
        }
        return class_1271.method_22427((Object)stack);
    }

    private boolean pickupLiquid(class_1799 stack, class_1657 player, class_1268 hand, class_1937 world, class_2338 pos, class_2350 facing) {
        class_2680 state;
        class_2248 class_22482;
        SingleVariantStorage bucket;
        Storage bucketTank = TankHelper.getTank(world, StackHelper.getOwnerID(stack), StackHelper.getCode(stack)).getTankFor(FluidVariant.class).orElse(null);
        if (bucketTank == null) {
            return false;
        }
        Storage fromHandler = (Storage)FluidStorage.SIDED.find(world, pos, (Object)facing);
        if (fromHandler != null) {
            return FluidTransferUtil.move((Storage<FluidVariant>)fromHandler, (Storage<FluidVariant>)bucketTank, 81000L);
        }
        if (bucketTank instanceof SingleVariantStorage && (bucket = (SingleVariantStorage)bucketTank).getCapacity() - bucket.getAmount() >= 81000L && (class_22482 = (state = world.method_8320(pos)).method_26204()) instanceof class_2404) {
            class_2404 fluidBlock = (class_2404)class_22482;
            if ((Integer)state.method_11654((class_2769)class_2404.field_11278) == 0) {
                class_3611 fluid;
                class_3611 class_36112 = fluid = fluidBlock instanceof ET_FluidBlock_Accessor ? ((ET_FluidBlock_Accessor)fluidBlock).getFluid().method_15751() : null;
                if (fluid != null && (bucket.getAmount() == 0L || ((FluidVariant)bucket.getResource()).getFluid().equals(fluid)) && fluidBlock.method_9700((class_1936)world, pos, state) != class_1799.field_8037) {
                    world.method_8396(player, pos, FluidVariantAttributes.getFillSound((FluidVariant)FluidVariant.of((class_3611)fluid)), class_3419.field_15245, 1.0f, 1.0f);
                    if (!player.method_31549().field_7477) {
                        FluidTransferUtil.fill((Storage<FluidVariant>)bucketTank, fluid, 81000L);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean placeLiquid(class_1799 stack, class_1657 player, class_1268 hand, class_1937 world, class_2338 pos, class_2350 facing, boolean hitTypeBlock) {
        class_2680 state;
        SingleVariantStorage bucket;
        Storage bucketTank = TankHelper.getTank(world, StackHelper.getOwnerID(stack), StackHelper.getCode(stack)).getTankFor(FluidVariant.class).orElse(null);
        if (bucketTank == null) {
            return false;
        }
        Storage toHandler = (Storage)FluidStorage.SIDED.find(world, pos, (Object)facing);
        if (toHandler != null) {
            FluidTransferUtil.move((Storage<FluidVariant>)bucketTank, (Storage<FluidVariant>)toHandler, 81000L);
        }
        if (hitTypeBlock && bucketTank instanceof SingleVariantStorage && (bucket = (SingleVariantStorage)bucketTank).getAmount() >= 81000L && !(state = ((FluidVariant)bucket.getResource()).getFluid().method_15785().method_15759()).method_26215() && world.method_8501(pos.method_10093(facing), state)) {
            world.method_8396(player, pos, FluidVariantAttributes.getEmptySound((FluidVariant)((FluidVariant)bucket.getResource())), class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_31549().field_7477) {
                FluidTransferUtil.drain((Storage<FluidVariant>)bucketTank, (FluidVariant)bucket.getResource(), 81000L);
            }
            return true;
        }
        return false;
    }

    public String method_7866(class_1799 stack) {
        return "item.endertanks.bucket." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"info.endertanks.tank.code")).method_10852((class_2561)class_2561.method_43470((String)(" " + StackHelper.getCode(stack)))));
        class_2561 owner = TankInfoHelper.formatTankOwner(StackHelper.getOwnerName(stack));
        if (owner != null) {
            tooltip.add(owner);
        }
        tooltip.add((class_2561)class_2561.method_43471((String)ItemEnderBucket.getMode(stack).getTooltip()));
        ADD_CHANGE_INSTRUCTIONS.accept(tooltip, null);
    }

    @Environment(value=EnvType.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && !data.stack.method_7960()) {
            int value = class_3532.method_15340((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    private static enum EnumMode {
        NORMAL("info.endertanks.bucket.mode.normal"),
        INVERT("info.endertanks.bucket.mode.invert"),
        PICKUP("info.endertanks.bucket.mode.pickup"),
        PLACE("info.endertanks.bucket.mode.place");

        private final String tooltip;

        private EnumMode(String tooltip) {
            this.tooltip = tooltip;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public static EnumMode byName(String name) {
            for (EnumMode entry : EnumMode.values()) {
                if (!entry.toString().equalsIgnoreCase(name)) continue;
                return entry;
            }
            return NORMAL;
        }

        private EnumMode next(boolean reverse) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORMAL -> {
                    if (reverse) {
                        yield PLACE;
                    }
                    yield INVERT;
                }
                case INVERT -> {
                    if (reverse) {
                        yield NORMAL;
                    }
                    yield PICKUP;
                }
                case PICKUP -> {
                    if (reverse) {
                        yield INVERT;
                    }
                    yield PLACE;
                }
                case PLACE -> reverse ? PICKUP : NORMAL;
            };
        }

        private boolean preformPlace(boolean isSneaking) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NORMAL -> isSneaking;
                case INVERT -> {
                    if (!isSneaking) {
                        yield true;
                    }
                    yield false;
                }
                case PICKUP -> false;
                case PLACE -> true;
            };
        }
    }
}

