/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.block;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1945;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import shetiphian.core.common.DistExecutor;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ToolHelper;
import shetiphian.endertanks.EnderTanks;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.api.HandlerRegistry;
import shetiphian.endertanks.api.ITankHandler;
import shetiphian.endertanks.client.EnderTanksClient;
import shetiphian.endertanks.common.block.HitBoxHelper;
import shetiphian.endertanks.common.item.ItemEnderBucket;
import shetiphian.endertanks.common.misc.EnderContainer;
import shetiphian.endertanks.common.misc.FluidTransferUtil;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class BlockEnderTank
extends class_2237
implements IColored {
    public static final class_2753 FACING = class_2753.method_11845((String)"facing", (class_2350[])class_2350.values());
    private static final class_2754<EnumType> VARIANT = class_2754.method_11850((String)"variant", EnumType.class);
    private static final class_2746 POWERED = class_2746.method_11825((String)"powered");
    public static final HashMap<class_2350, class_265[]> SHAPES = new HashMap();

    public BlockEnderTank() {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10443).method_31710(class_3620.field_16009).method_36557(5.0f));
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
        DistExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> {
            EnderTanksClient.colorize(this);
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)this, class_1921.method_23581());
        });
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, VARIANT, POWERED});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileEntityEnderTank(pos, state);
    }

    private TileEntityEnderTank getTile(class_1922 world, class_2338 pos) {
        class_2586 tile = world.method_8321(pos);
        return tile instanceof TileEntityEnderTank ? (TileEntityEnderTank)tile : null;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        if (SHAPES.isEmpty()) {
            Map<class_2350, class_265> tank_body = HitBoxHelper.getBody();
            Map<class_2350, class_265> top_ring = HitBoxHelper.getRing_Top();
            Map<class_2350, class_265> middle_ring = HitBoxHelper.getRing_Middle();
            Map<class_2350, class_265> bottom_ring = HitBoxHelper.getRing_Bottom();
            for (class_2350 direction : class_2350.values()) {
                class_265[] shapes = new class_265[]{tank_body.getOrDefault(direction, class_259.method_1073()), top_ring.getOrDefault(direction, class_259.method_1073()), middle_ring.getOrDefault(direction, class_259.method_1073()), bottom_ring.getOrDefault(direction, class_259.method_1073())};
                SHAPES.put(direction, shapes);
            }
        }
        if (!SHAPES.isEmpty()) {
            return SHAPES.get(BlockEnderTank.getFacing(state))[0];
        }
        return class_259.method_1077();
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return this.onBlockActivated(state, world, pos, player, player.method_5998(hand));
    }

    public class_1269 onBlockActivated(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1799 heldItem) {
        Storage storage;
        Storage tankHandler;
        TileEntityEnderTank tankTile = this.getTile((class_1922)world, pos);
        if (tankTile == null) {
            return class_1269.field_5811;
        }
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        if (!heldItem.method_7960() && !(heldItem.method_7909() instanceof ItemEnderBucket) && tankTile.canUse(player) && (tankHandler = (Storage)tankTile.getEnderContainer().getTankFor(FluidVariant.class).orElse(null)) instanceof SingleVariantStorage && (storage = (Storage)FluidStorage.ITEM.find(heldItem, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)player.method_6058()))) != null) {
            if (!FluidTransferUtil.moveWithSound((Storage<FluidVariant>)storage, (Storage<FluidVariant>)tankHandler, Long.MAX_VALUE, player, false) && !FluidTransferUtil.moveWithSound((Storage<FluidVariant>)tankHandler, (Storage<FluidVariant>)storage, Long.MAX_VALUE, player, true)) {
                return class_1269.field_5814;
            }
            return class_1269.field_5812;
        }
        if (!player.method_5715()) {
            if (tankTile.lastClick <= System.currentTimeMillis()) {
                tankTile.lastClick = System.currentTimeMillis() + 200L;
                if (heldItem.method_7960() || !(heldItem.method_7909() instanceof class_1747) && !ToolHelper.isWrench((class_1799)heldItem)) {
                    TankInfoHelper.sendTankInfo(player, tankTile);
                }
            }
            return class_1269.field_5812;
        }
        if (!heldItem.method_7960()) {
            class_1767 color;
            int subHit;
            if (tankTile.isPublic()) {
                boolean changed = false;
                if (Values.listPersonal.contains(heldItem.method_7909())) {
                    if (EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.personal_tanks) {
                        changed = true;
                        tankTile.setOwner(player, heldItem.method_7972().method_7971(1));
                        Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.PRIVATE))), (boolean)true);
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.private.disabled");
                    }
                }
                if (!changed && Values.listTeam.contains(heldItem.method_7909())) {
                    if (EnderTanks.CONFIG.COMMON.ACCESS_SETTINGS.team_tanks) {
                        String teamID = Function.getPlayerTeamID((class_1657)player);
                        if (!Strings.isNullOrEmpty((String)teamID)) {
                            changed = true;
                            tankTile.setOwner(Function.getTeamDisplayName((String)teamID), "#" + teamID, heldItem.method_7972().method_7971(1));
                            Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)EnumType.TEAM))), (boolean)true);
                        } else {
                            TankInfoHelper.sendError(player, "shetiphian.team.noteam");
                        }
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.team.disabled");
                    }
                }
                if (changed) {
                    if (!player.method_31549().field_7477) {
                        heldItem.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
            }
            if (!tankTile.canEdit(player)) {
                return class_1269.field_5812;
            }
            short capacity = TankHelper.getCapacityInBuckets(world, tankTile.getOwnerID(), tankTile.getCode());
            if (capacity < EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.tank_size_max) {
                int newValue = 0;
                if (Values.listSmallCap_Single.contains(heldItem.method_7909())) {
                    newValue = -1;
                    if (tankTile.applyItem(heldItem)) {
                        newValue = EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.small_capacity_upgrade;
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                    }
                }
                if (newValue == 0 && Values.listSmallCap_Multi.contains(heldItem.method_7909())) {
                    newValue = EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.small_capacity_upgrade;
                }
                if (newValue == 0 && capacity + EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.large_capacity_upgrade <= EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.tank_size_max) {
                    if (Values.listLargeCap_Single.contains(heldItem.method_7909())) {
                        newValue = -1;
                        if (tankTile.applyItem(heldItem)) {
                            newValue = EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.large_capacity_upgrade;
                        } else {
                            TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                        }
                    }
                    if (newValue == 0 && Values.listLargeCap_Multi.contains(heldItem.method_7909())) {
                        newValue = EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.large_capacity_upgrade;
                    }
                }
                if (newValue > 0) {
                    TankHelper.setCapacityInBuckets(world, tankTile.getOwnerID(), tankTile.getCode(), (short)(capacity + newValue));
                    if (!player.method_31549().field_7477) {
                        heldItem.method_7934(1);
                    }
                    TankInfoHelper.sendCapacityInfo(player, tankTile);
                    return class_1269.field_5812;
                }
            }
            if (tankTile.getPumpUpgradeCount() < EnderTanks.CONFIG.COMMON.UPGRADE_SETTINGS.tank_pump_max) {
                boolean upgrade_pump = false;
                if (Values.listPump_Single.contains(heldItem.method_7909())) {
                    if (tankTile.applyItem(heldItem)) {
                        upgrade_pump = true;
                    } else {
                        TankInfoHelper.sendError(player, "endertanks.tank.upgrade_used");
                    }
                } else if (Values.listPump_Multi.contains(heldItem.method_7909())) {
                    upgrade_pump = true;
                }
                if (upgrade_pump) {
                    tankTile.addPumpUpgrade(heldItem.method_7972().method_7971(1));
                    if (!player.method_31549().field_7477) {
                        heldItem.method_7934(1);
                    }
                    TankInfoHelper.sendPumpInfo(player, tankTile);
                    Function.syncTile((class_2586)tankTile);
                    return class_1269.field_5812;
                }
            }
            if (EnderTanks.CONFIG.COMMON.enable_in_world_coloring && (subHit = Function.getSubShapeHit((class_1297)player, (class_2338)pos, (class_265[])SHAPES.get(state.method_11654((class_2769)FACING)))) > 0 && subHit < 4 && (color = DyeHelper.getDyeColor((class_1792)heldItem.method_7909())) != null && tankTile.doColorRing(color, player)) {
                if (!player.method_31549().field_7477) {
                    heldItem.method_7934(1);
                }
                world.method_8408(pos, (class_2248)this);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5812;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null && tile.canEdit(player)) {
            return super.method_9594(state, player, world, pos);
        }
        return -1.0f;
    }

    public class_2680 method_9605(class_1750 context) {
        boolean isPowered = context.method_8045().method_49803(context.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8038().method_10153())).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(isPowered));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
        TileEntityEnderTank tile = this.getTile((class_1922)world, pos);
        if (tile != null) {
            Object code = StackHelper.getCode(stack);
            while (((String)code).length() < 3) {
                code = "0" + (String)code;
            }
            class_1799 personalItem = StackHelper.getPersonalItem(stack);
            tile.setCode((String)code);
            if (!personalItem.method_7960()) {
                tile.setOwner(StackHelper.getOwnerName(stack), StackHelper.getOwnerID(stack), personalItem);
                Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : EnumType.PRIVATE)))), (boolean)true);
            }
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean isMoving) {
        this.updatePoweredState(state, world, pos);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        this.updatePoweredState(state, world, pos);
    }

    private void updatePoweredState(class_2680 state, class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            boolean isPowered = world.method_49803(pos);
            if ((Boolean)state.method_11654((class_2769)POWERED) != isPowered) {
                Function.setBlock((class_1945)world, (class_2338)pos, (class_2680)((class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(isPowered))), (boolean)false);
            }
            if (isPowered) {
                world.method_39279(pos, (class_2248)this, 20);
            }
        }
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        this.updatePoweredState(state, (class_1937)world, pos);
        if (!world.method_8608() && ((Boolean)state.method_11654((class_2769)POWERED)).booleanValue()) {
            TileEntityEnderTank tankTile = this.getTile((class_1922)world, pos);
            if (tankTile != null) {
                class_2350 tankFacing = BlockEnderTank.getFacing(state);
                class_2338 fromPos = pos.method_10093(tankFacing.method_10153());
                class_2338 toPos = pos.method_10093(tankFacing);
                long pumpCapacity = tankTile.getPumpCapacity();
                EnderContainer enderContainer = tankTile.getEnderContainer();
                HandlerRegistry.getProviders().forEach((key, provider) -> {
                    ITankHandler<?> handler = enderContainer.getOrCreateHandler((String)key);
                    if (handler != null) {
                        handler.preformPumpAction((class_1937)world, pos, tankFacing, fromPos, toPos, pumpCapacity, random);
                    }
                });
            }
            world.method_39279(pos, (class_2248)this, 20);
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        List drops = super.method_9560(state, builder);
        class_2586 builderTile = (class_2586)builder.method_51876(class_181.field_1228);
        if (builderTile instanceof TileEntityEnderTank) {
            class_1799 personal;
            TileEntityEnderTank tile = (TileEntityEnderTank)builderTile;
            class_1297 builderEntity = (class_1297)builder.method_51876(class_181.field_1226);
            if (builderEntity != null && builderEntity.method_5715() && !(personal = tile.getPersonalItem()).method_7960()) {
                drops.add(personal);
            }
            drops.addAll(tile.getPumpUpgrades());
        }
        return drops;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null) {
            return StackHelper.create(class_1792.method_7867((class_2248)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
        }
        return new class_1799((class_1935)this);
    }

    public String method_9539() {
        return "block.endertanks.tank.public";
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (rotation != class_2470.field_11467) {
            class_2350 facing = BlockEnderTank.getFacing(state);
            if (rotation == class_2470.field_11464) {
                return (class_2680)state.method_11657((class_2769)FACING, (Comparable)facing.method_10153());
            }
            int value = facing.ordinal() + (rotation == class_2470.field_11463 ? 1 : -1);
            value = value < 0 ? 5 : (value > 5 ? 0 : value);
            return (class_2680)state.method_11657((class_2769)FACING, (Comparable)class_2350.method_10143((int)value));
        }
        return state;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        if (world.method_8608()) {
            return 0;
        }
        TileEntityEnderTank tile = this.getTile((class_1922)world, pos);
        return tile != null ? tile.getComparatorOutput() : 0;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderTank tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile((class_1922)data.world, data.pos)) != null) {
            int value = class_3532.method_15340((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    public static class_2350 getFacing(class_2680 state) {
        class_2350 facing;
        try {
            facing = (class_2350)state.method_11654((class_2769)FACING);
        }
        catch (Exception e) {
            facing = class_2350.field_11033;
            EnderTanks.LOGGER.error("PropertyEnum 'BlockEnderTank.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + state);
        }
        return facing;
    }

    public static boolean isPowered(class_2680 state) {
        boolean powered;
        try {
            powered = (Boolean)state.method_11654((class_2769)POWERED);
        }
        catch (Exception e) {
            powered = false;
            EnderTanks.LOGGER.error("PropertyEnum 'BlockEnderTank.POWERED' not found in provided BlockState, returning 'false'. Provided BlockState: " + state);
        }
        return powered;
    }

    public static enum EnumType implements class_3542
    {
        PUBLIC("public"),
        PRIVATE("private"),
        TEAM("team");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

