/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5425;

public class CappedStructureSurfaceProcessor
extends class_3491 {
    public static final Codec<CappedStructureSurfaceProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3828.field_25013.fieldOf("delegate").forGetter(cappedProcessor -> cappedProcessor.delegate), (App)Codec.BOOL.fieldOf("allow_void_sides").orElse((Object)false).forGetter(cappedProcessor -> cappedProcessor.allowVoidSides)).apply((Applicative)instance, CappedStructureSurfaceProcessor::new));
    private static final Pair<class_3499.class_3501, Integer> DEFAULT_AIR_BLOCK = Pair.of((Object)new class_3499.class_3501(class_2338.field_10980, class_2246.field_10124.method_9564(), null), (Object)0);
    private static final Pair<class_3499.class_3501, Integer> DEFAULT_SOLID_BLOCK = Pair.of((Object)new class_3499.class_3501(class_2338.field_10980, class_2246.field_10340.method_9564(), null), (Object)0);
    private final class_3491 delegate;
    private final boolean allowVoidSides;

    public CappedStructureSurfaceProcessor(class_3491 structureProcessor, boolean allowVoidSides) {
        this.delegate = structureProcessor;
        this.allowVoidSides = allowVoidSides;
    }

    public final List<class_3499.class_3501> method_49887(class_5425 serverLevelAccessor, class_2338 nbtOriginPos, class_2338 chunkCenter, List<class_3499.class_3501> nbtOriginBlockInfo, List<class_3499.class_3501> worldOriginBlockInfo, class_3492 structurePlaceSettings) {
        if (!worldOriginBlockInfo.isEmpty()) {
            if (nbtOriginBlockInfo.size() != worldOriginBlockInfo.size()) {
                int listSize = nbtOriginBlockInfo.size();
                class_156.method_33559((String)("Original block info list not in sync with processed list, skipping processing. Original size: " + listSize + ", Processed size: " + worldOriginBlockInfo.size()));
            } else {
                class_3341 boundingBox = structurePlaceSettings.method_15124() == null ? class_3341.method_14665() : structurePlaceSettings.method_15124();
                Object2ObjectArrayMap nbtPosToData = new Object2ObjectArrayMap();
                for (int index = 0; index < worldOriginBlockInfo.size(); ++index) {
                    class_3499.class_3501 info = worldOriginBlockInfo.get(index);
                    if (!boundingBox.method_14662((class_2382)info.comp_1341())) continue;
                    nbtPosToData.put(info.comp_1341(), Pair.of((Object)info, (Object)index));
                }
                ArrayList shuffledPositionList = new ArrayList(nbtPosToData.keySet());
                Collections.shuffle(shuffledPositionList);
                for (class_2338 currentPosition : shuffledPositionList) {
                    class_3499.class_3501 structureBlockInfo3;
                    Pair currentInfo = (Pair)nbtPosToData.get(currentPosition);
                    class_3499.class_3501 structureBlockInfoOriginalNbtOrigin = nbtOriginBlockInfo.get((Integer)currentInfo.getSecond());
                    class_3499.class_3501 structureBlockInfoWorld = worldOriginBlockInfo.get((Integer)currentInfo.getSecond());
                    if (structureBlockInfoWorld == null || structureBlockInfoWorld.comp_1342().method_26215() || !structureBlockInfoWorld.comp_1342().method_26227().method_15769()) continue;
                    class_2338 belowPos = structureBlockInfoWorld.comp_1341().method_10074();
                    class_2338 abovePos = structureBlockInfoWorld.comp_1341().method_10084();
                    if (!this.allowVoidSides && belowPos.method_10264() < 0 || !this.allowVoidSides && (!nbtPosToData.containsKey(belowPos) || !nbtPosToData.containsKey(abovePos))) continue;
                    class_2680 belowState = ((class_3499.class_3501)nbtPosToData.getOrDefault(belowPos, DEFAULT_SOLID_BLOCK).getFirst()).comp_1342();
                    class_2680 aboveState = ((class_3499.class_3501)nbtPosToData.getOrDefault(abovePos, DEFAULT_AIR_BLOCK).getFirst()).comp_1342();
                    if (!belowState.method_26225() || belowState.method_27852(class_2246.field_16540) || aboveState.method_26225() && !aboveState.method_27852(class_2246.field_16540) || (structureBlockInfo3 = this.delegate.method_15110((class_4538)serverLevelAccessor, structureBlockInfoOriginalNbtOrigin.comp_1341(), structureBlockInfoWorld.comp_1341(), structureBlockInfoOriginalNbtOrigin, structureBlockInfoWorld, structurePlaceSettings)) == null || structureBlockInfoWorld.equals((Object)structureBlockInfo3)) continue;
                    worldOriginBlockInfo.set((Integer)currentInfo.getSecond(), structureBlockInfo3);
                }
            }
        }
        return worldOriginBlockInfo;
    }

    protected class_3828<?> method_16772() {
        return RSProcessors.CAPPED_STRUCTURE_SURFACE_PROCESSOR.get();
    }
}

