/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericMemoryPack
implements class_3262 {
    private final Map<class_2960, class_7367<InputStream>> data = new HashMap<class_2960, class_7367<InputStream>>();
    private final JsonObject metaData;
    private final class_3264 allowedType;
    private final String id;

    protected GenericMemoryPack(class_3264 type, String id, JsonObject meta) {
        this.metaData = meta;
        this.allowedType = type;
        this.id = id;
    }

    private boolean isTypeAllowed(class_3264 type) {
        return this.allowedType.equals((Object)type);
    }

    public void putData(class_3264 type, class_2960 location, class_7367<InputStream> supplier) {
        if (!this.isTypeAllowed(type)) {
            return;
        }
        this.data.put(location, supplier);
    }

    public void putJson(class_3264 type, class_2960 location, JsonElement json) {
        this.putData(type, location, (class_7367<InputStream>)((class_7367)() -> new ByteArrayInputStream(Constants.GSON.toJson(json).getBytes(StandardCharsets.UTF_8))));
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... files) {
        String file = String.join((CharSequence)"/", files);
        if (file.contains("/") || file.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(@NotNull class_3264 type, @NotNull class_2960 location) {
        if (!this.isTypeAllowed(type)) {
            return null;
        }
        return this.data.getOrDefault(location, null);
    }

    public void method_14408(@NotNull class_3264 type, @NotNull String namespace, @NotNull String path, @NotNull class_3262.class_7664 output) {
        if (!this.isTypeAllowed(type)) {
            return;
        }
        this.data.entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).method_12836().equals(namespace)).filter(entry -> ((class_2960)entry.getKey()).method_12832().startsWith(path)).forEach(entry -> output.accept((Object)((class_2960)entry.getKey()), (Object)((class_7367)entry.getValue())));
    }

    @NotNull
    public Set<String> method_14406(@NotNull class_3264 type) {
        if (!this.isTypeAllowed(type)) {
            return Collections.emptySet();
        }
        return this.data.keySet().stream().map(class_2960::method_12836).collect(Collectors.toSet());
    }

    @Nullable
    public <T> T method_14407(@NotNull class_3270<T> serializer) {
        if (!serializer.method_14420().equals("pack")) {
            return null;
        }
        return (T)serializer.method_14421(this.metaData);
    }

    @NotNull
    public String method_14409() {
        return this.id;
    }

    public boolean method_45178() {
        return true;
    }

    public void close() {
        for (class_7367<InputStream> value : this.data.values()) {
            try {
                ((InputStream)value.get()).close();
            }
            catch (IOException e) {
                Constants.LOGGER.error("Failed to close input stream", (Throwable)e);
            }
        }
    }
}

