/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.archeologyplus.mixin;

import java.util.Objects;
import java.util.UUID;
import net.emilsg.archeologyplus.register.items.ModItems;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309 {
    private static final UUID SPEED_UUID = UUID.fromString("5e1c2f38-3bb9-4b17-86df-a9a443f1078e");
    private static final class_1322 SPEED_MODIFIER = new class_1322(SPEED_UUID, "Idol speed attribute", 0.01, class_1322.class_1323.field_6328);
    private static final UUID RESISTANCE_UUID = UUID.fromString("926bacf9-f1f2-4d91-8d7c-28585c7edfa7");
    private static final class_1322 RESISTANCE_MODIFIER = new class_1322(RESISTANCE_UUID, "Idol resistance attribute", 2.0, class_1322.class_1323.field_6328);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract Iterable<class_1799> method_5877();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tickIdolItems(CallbackInfo ci) {
        class_1937 world = this.method_37908();
        boolean sunAndDay = this.heldItem(ModItems.SUN_IDOL) && world.method_8530();
        boolean moonAndNight = this.heldItem(ModItems.MOON_IDOL) && world.method_23886();
        boolean inWater = this.method_5777(class_3486.field_15517);
        boolean shell = this.heldItem(ModItems.SEASHELL_IDOL);
        boolean onFire = this.method_5809();
        boolean fireIdol = this.heldItem(ModItems.FIRE_IDOL);
        if (!world.field_9236) {
            if (shell && !inWater) {
                this.method_6092(new class_1293(class_1294.field_5923, 200, 0, false, false, true));
            } else if (shell && inWater) {
                this.method_6092(new class_1293(class_1294.field_5925, 200, 0, false, false, true));
            }
            if (fireIdol && !onFire) {
                this.method_6092(new class_1293(class_1294.field_5918, 200, 0, false, false, true));
            }
            if ((sunAndDay || moonAndNight) && this.shouldApplyModifiers()) {
                this.addModifiers();
            } else if (!(this.shouldApplyModifiers() || sunAndDay || moonAndNight)) {
                this.removeModifiers();
            }
        }
    }

    @Inject(method={"getBlockBreakingSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> cirF) {
        boolean isHoldingSeashellItem;
        class_1657 player = (class_1657)this;
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        float originalSpeed = ((Float)cirF.getReturnValue()).floatValue();
        boolean hasAquaAffinity = class_1890.method_8200((class_1309)player);
        boolean bl = isHoldingSeashellItem = mainHand.method_7909() == ModItems.SEASHELL_IDOL || offHand.method_7909() == ModItems.SEASHELL_IDOL;
        if (player.method_5777(class_3486.field_15517) && !hasAquaAffinity && !isHoldingSeashellItem) {
            originalSpeed /= 5.0f;
        }
        cirF.setReturnValue((Object)Float.valueOf(originalSpeed));
    }

    private boolean shouldApplyModifiers() {
        class_1324 speedAttribute = this.method_5996(class_5134.field_23719);
        class_1324 healthAttribute = this.method_5996(class_5134.field_23724);
        return Objects.requireNonNull(speedAttribute).method_6199(SPEED_UUID) == null && Objects.requireNonNull(healthAttribute).method_6199(RESISTANCE_UUID) == null;
    }

    private boolean heldItem(class_1792 item) {
        return this.method_5998(class_1268.field_5808).method_31574(item) || this.method_5998(class_1268.field_5810).method_31574(item);
    }

    private void addModifiers() {
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_26835(SPEED_MODIFIER);
        Objects.requireNonNull(this.method_5996(class_5134.field_23725)).method_26835(RESISTANCE_MODIFIER);
    }

    private void removeModifiers() {
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6202(SPEED_MODIFIER);
        Objects.requireNonNull(this.method_5996(class_5134.field_23725)).method_6202(RESISTANCE_MODIFIER);
    }
}

