/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.handler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.betteranimationscollection.BetterAnimationsCollection;
import fuzs.betteranimationscollection.config.ClientConfig;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1113;
import net.minecraft.class_1145;
import net.minecraft.class_1146;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_638;

public class RemoteSoundHandler {
    public static final RemoteSoundHandler INSTANCE = new RemoteSoundHandler();
    private static final int MAX_SOUND_ANIMATION_TIME = 20;
    private final Map<class_2960, Class<? extends class_1308>> ambientSounds = Maps.newConcurrentMap();
    private final Set<Class<? extends class_1308>> noisyEntities = Sets.newConcurrentHashSet();
    private final Set<Class<? extends class_1308>> attackableEntities = Sets.newHashSet();
    private final SoundDetectionListener soundListener = new SoundDetectionListener();

    public EventResult onLivingTick(class_1309 entity) {
        this.soundListener.ensureInitialized();
        if (!entity.method_37908().field_9236 || !(entity instanceof class_1308)) {
            return EventResult.PASS;
        }
        class_1308 mob = (class_1308)entity;
        Stream.concat(this.noisyEntities.stream(), this.attackableEntities.stream()).forEach(clazz -> {
            if (clazz.isAssignableFrom(entity.getClass()) && mob.field_6191 >= 0) {
                mob.field_6191 = -mob.method_5970() + 20;
            }
        });
        for (Class<? extends class_1308> clazz2 : this.attackableEntities) {
            if (!clazz2.isAssignableFrom(entity.getClass()) || mob.field_6254 <= 0 || mob.field_6235 != mob.field_6254) continue;
            mob.field_6191 = -mob.method_5970();
        }
        return EventResult.PASS;
    }

    public void addAmbientSounds(Class<? extends class_1308> entityClazz, Collection<class_3414> soundEvents) {
        this.noisyEntities.add(entityClazz);
        for (class_3414 soundEvent : soundEvents) {
            this.ambientSounds.put(soundEvent.method_14833(), entityClazz);
        }
    }

    public void removeAmbientSounds(Class<? extends class_1308> entityClazz) {
        this.ambientSounds.values().removeIf(clazz -> clazz.equals(entityClazz));
    }

    public void addAttackableEntity(Class<? extends class_1308> entityClazz) {
        this.attackableEntities.add(entityClazz);
    }

    private class SoundDetectionListener
    implements class_1145 {
        private boolean initialized;

        private SoundDetectionListener() {
        }

        public void ensureInitialized() {
            if (!this.initialized) {
                class_310.method_1551().method_1483().method_4878((class_1145)this);
                this.initialized = true;
            }
        }

        public void method_4884(class_1113 soundIn, class_1146 accessor) {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            Class<? extends class_1308> entityClazz = RemoteSoundHandler.this.ambientSounds.get(soundIn.method_4775());
            if (entityClazz != null) {
                class_243 center = new class_243(soundIn.method_4784() + 0.0625, soundIn.method_4779() + 0.0625, soundIn.method_4778() + 0.0625);
                double soundDetectionRange = ((ClientConfig)BetterAnimationsCollection.CONFIG.get(ClientConfig.class)).soundDetectionRange;
                class_238 axisAlignedBB = new class_238(center, center).method_1014(soundDetectionRange + 0.0625);
                List entities = level.method_18467(entityClazz, axisAlignedBB);
                entities.stream().min((o1, o2) -> (int)Math.signum(o1.method_19538().method_1022(center) - o2.method_19538().method_1022(center))).ifPresent(entity -> {
                    entity.field_6191 = -entity.method_5970();
                });
            }
        }
    }
}

