/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import com.google.common.collect.Lists;
import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.handler.RemoteSoundHandler;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1308;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class SoundDetectionElement
extends ModelElement {
    private final Class<? extends class_1308> mobClazz;
    private final class_3414[] sounds;

    public SoundDetectionElement(Class<? extends class_1308> mobClazz, class_3414 ... sounds) {
        this.mobClazz = mobClazz;
        this.sounds = sounds;
        RemoteSoundHandler.INSTANCE.addAmbientSounds(mobClazz, Lists.newArrayList((Object[])sounds));
    }

    @Override
    public void setupModelConfig(ForgeConfigSpec.Builder builder, ValueCallback callback) {
        callback.accept(builder.comment(new String[]{"Mob sounds to play a unique animation for.", "Useful for adding support for modded mob variants which have different sounds from their vanilla counterparts.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color."}).define("mob_sounds", Stream.of(this.sounds).map(arg_0 -> ((class_2378)class_7923.field_41172).method_10221(arg_0)).filter(Objects::nonNull).map(class_2960::toString).collect(Collectors.toList())), v -> {
            RemoteSoundHandler.INSTANCE.removeAmbientSounds(this.mobClazz);
            ConfigDataSet soundEvents = ConfigDataSet.from((class_5321)class_7924.field_41225, (List)v, (Class[])new Class[0]);
            RemoteSoundHandler.INSTANCE.addAmbientSounds(this.mobClazz, (Collection<class_3414>)soundEvents);
        });
    }
}

