/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.rei;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.event.EventJS;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_2960;

public class RemoveREIRecipeEventJS
extends EventJS {
    private final Map<CategoryIdentifier<?>, Collection<class_2960>> recipesRemoved;
    private final CategoryRegistry categories;
    private final DisplayRegistry displays;

    public RemoveREIRecipeEventJS(Map<CategoryIdentifier<?>, Collection<class_2960>> recipesRemoved) {
        this.recipesRemoved = recipesRemoved;
        this.categories = CategoryRegistry.getInstance();
        this.displays = DisplayRegistry.getInstance();
    }

    public CategoryRegistry getCategories() {
        return this.categories;
    }

    public DisplayRegistry getDisplays() {
        return this.displays;
    }

    public List<?> getDisplaysFor(class_2960 category) {
        return this.displays.get(CategoryIdentifier.of((class_2960)category));
    }

    public Collection<class_2960> getCategoryIds() {
        return CollectionUtils.map((Iterable)this.categories, CategoryRegistry.CategoryConfiguration::getIdentifier);
    }

    public void remove(class_2960 category, class_2960 ... recipesToRemove) {
        CategoryIdentifier catId = CategoryIdentifier.of((class_2960)category);
        if (this.categories.tryGet(catId).isEmpty()) {
            KubeJS.LOGGER.warn("Failed to remove recipes for type {}: Category doesn't exist!", (Object)category);
            KubeJS.LOGGER.info("Use event.categoryIds to get a list of all categories.");
            return;
        }
        this.recipesRemoved.computeIfAbsent(catId, _0 -> new HashSet()).addAll(List.of(recipesToRemove));
    }

    public void removeFromAll(class_2960 ... recipesToRemove) {
        List<class_2960> asList = List.of(recipesToRemove);
        for (CategoryRegistry.CategoryConfiguration catId : this.categories) {
            this.recipesRemoved.computeIfAbsent(catId.getCategoryIdentifier(), _0 -> new HashSet()).addAll(asList);
        }
    }
}

