/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.latvian.mods.kubejs.bindings.TextWrapper;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.util.NotificationBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public class NotificationToast
implements class_368 {
    public static final Map<Integer, BiFunction<class_310, String, ToastIcon>> ICONS = new HashMap<Integer, BiFunction<class_310, String, ToastIcon>>(Map.of(1, TextureIcon::new, 2, ItemIcon::new, 3, AtlasIcon::of));
    private final NotificationBuilder notification;
    private final long duration;
    private final ToastIcon icon;
    private final List<class_5481> text;
    private int width;
    private int height;
    private long lastChanged;
    private boolean changed;

    public NotificationToast(class_310 mc, NotificationBuilder notification) {
        this.notification = notification;
        this.duration = notification.duration.toMillis();
        this.icon = ICONS.containsKey(this.notification.iconType) ? ICONS.get(this.notification.iconType).apply(mc, this.notification.icon) : null;
        this.text = new ArrayList<class_5481>(2);
        this.width = 0;
        this.height = 0;
        if (!TextWrapper.isEmpty(notification.text)) {
            this.text.addAll(mc.field_1772.method_1728((class_5348)notification.text, 240));
        }
        for (class_5481 l : this.text) {
            this.width = Math.max(this.width, mc.field_1772.method_30880(l));
        }
        this.width += 12;
        if (this.icon != null) {
            this.width += 24;
        }
        this.height = Math.max(this.text.size() * 10 + 12, 28);
        if (this.text.isEmpty() && this.icon != null) {
            this.width = 28;
            this.height = 28;
        }
    }

    public int method_29049() {
        return this.width;
    }

    public int method_29050() {
        return this.height;
    }

    private void drawRectangle(Matrix4f m, int x0, int y0, int x1, int y1, int r, int g, int b) {
        RenderSystem.setShader(class_757::method_34540);
        class_287 buf = class_289.method_1348().method_1349();
        buf.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buf.method_22918(m, (float)x0, (float)y1, 0.0f).method_1336(r, g, b, 255).method_1344();
        buf.method_22918(m, (float)x1, (float)y1, 0.0f).method_1336(r, g, b, 255).method_1344();
        buf.method_22918(m, (float)x1, (float)y0, 0.0f).method_1336(r, g, b, 255).method_1344();
        buf.method_22918(m, (float)x0, (float)y0, 0.0f).method_1336(r, g, b, 255).method_1344();
        class_286.method_43433((class_287.class_7433)buf.method_1326());
    }

    public class_368.class_369 method_1986(class_332 graphics, class_374 toastComponent, long l) {
        if (this.changed) {
            this.lastChanged = l;
            this.changed = false;
        }
        class_310 mc = toastComponent.method_1995();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22904(-2.0, 2.0, 0.0);
        Matrix4f m = poseStack.method_23760().method_23761();
        int w = this.method_29049();
        int h = this.method_29050();
        int oc = this.notification.outlineColor.getRgbJS();
        int ocr = class_5253.class_5254.method_27765((int)oc);
        int ocg = class_5253.class_5254.method_27766((int)oc);
        int ocb = class_5253.class_5254.method_27767((int)oc);
        int bc = this.notification.borderColor.getRgbJS();
        int bcr = class_5253.class_5254.method_27765((int)bc);
        int bcg = class_5253.class_5254.method_27766((int)bc);
        int bcb = class_5253.class_5254.method_27767((int)bc);
        int bgc = this.notification.backgroundColor.getRgbJS();
        int bgcr = class_5253.class_5254.method_27765((int)bgc);
        int bgcg = class_5253.class_5254.method_27766((int)bgc);
        int bgcb = class_5253.class_5254.method_27767((int)bgc);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawRectangle(m, 2, 0, w - 2, h, ocr, ocg, ocb);
        this.drawRectangle(m, 0, 2, w, h - 2, ocr, ocg, ocb);
        this.drawRectangle(m, 1, 1, w - 1, h - 1, ocr, ocg, ocb);
        this.drawRectangle(m, 2, 1, w - 2, h - 1, bcr, bcg, bcb);
        this.drawRectangle(m, 1, 2, w - 1, h - 2, bcr, bcg, bcb);
        this.drawRectangle(m, 2, 2, w - 2, h - 2, bgcr, bgcg, bgcb);
        if (this.icon != null) {
            this.icon.draw(mc, graphics, 14, h / 2, this.notification.iconSize);
        }
        int th = this.icon == null ? 6 : 26;
        int tv = (h - this.text.size() * 10) / 2 + 1;
        for (int i = 0; i < this.text.size(); ++i) {
            graphics.method_51430(mc.field_1772, this.text.get(i), th, tv + i * 10, 0xFFFFFF, this.notification.textShadow);
        }
        poseStack.method_22909();
        return l - this.lastChanged < this.duration ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
    }

    public static interface ToastIcon {
        public void draw(class_310 var1, class_332 var2, int var3, int var4, int var5);
    }

    public record AtlasIcon(class_1058 sprite) implements ToastIcon
    {
        public static AtlasIcon of(class_310 mc, String icon) {
            String[] s = icon.split("\\|");
            if (s.length == 2) {
                return new AtlasIcon((class_1058)mc.method_1549(new class_2960(s[0])).apply(new class_2960(s[1])));
            }
            return new AtlasIcon((class_1058)mc.method_1549(class_1723.field_21668).apply(new class_2960(icon)));
        }

        @Override
        public void draw(class_310 mc, class_332 graphics, int x, int y, int size) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.sprite.method_45852());
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f m = graphics.method_51448().method_23760().method_23761();
            int p0 = -size / 2;
            int p1 = p0 + size;
            float u0 = this.sprite.method_4594();
            float v0 = this.sprite.method_4593();
            float u1 = this.sprite.method_4577();
            float v1 = this.sprite.method_4575();
            class_287 buf = class_289.method_1348().method_1349();
            buf.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            buf.method_22918(m, (float)(x + p0), (float)(y + p1), 0.0f).method_22913(u0, v1).method_1336(255, 255, 255, 255).method_1344();
            buf.method_22918(m, (float)(x + p1), (float)(y + p1), 0.0f).method_22913(u1, v1).method_1336(255, 255, 255, 255).method_1344();
            buf.method_22918(m, (float)(x + p1), (float)(y + p0), 0.0f).method_22913(u1, v0).method_1336(255, 255, 255, 255).method_1344();
            buf.method_22918(m, (float)(x + p0), (float)(y + p0), 0.0f).method_22913(u0, v0).method_1336(255, 255, 255, 255).method_1344();
            class_286.method_43433((class_287.class_7433)buf.method_1326());
        }
    }

    public record ItemIcon(class_1799 stack) implements ToastIcon
    {
        public ItemIcon(class_310 ignored, String icon) {
            this(ItemStackJS.of(icon));
        }

        @Override
        public void draw(class_310 mc, class_332 graphics, int x, int y, int size) {
            class_4587 m = RenderSystem.getModelViewStack();
            m.method_22903();
            m.method_22904((double)x - 2.0, (double)y + 2.0, 0.0);
            float s = (float)size / 16.0f;
            m.method_22905(s, s, s);
            RenderSystem.applyModelViewMatrix();
            graphics.method_51445(this.stack, -8, -8);
            m.method_22909();
            RenderSystem.applyModelViewMatrix();
        }
    }

    public record TextureIcon(class_2960 texture) implements ToastIcon
    {
        public TextureIcon(class_310 ignored, String icon) {
            this(new class_2960(icon));
        }

        @Override
        public void draw(class_310 mc, class_332 graphics, int x, int y, int size) {
            RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f m = graphics.method_51448().method_23760().method_23761();
            int p0 = -size / 2;
            int p1 = p0 + size;
            class_287 buf = class_289.method_1348().method_1349();
            buf.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
            buf.method_22918(m, (float)(x + p0), (float)(y + p1), 0.0f).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
            buf.method_22918(m, (float)(x + p1), (float)(y + p1), 0.0f).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, 255).method_1344();
            buf.method_22918(m, (float)(x + p1), (float)(y + p0), 0.0f).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
            buf.method_22918(m, (float)(x + p0), (float)(y + p0), 0.0f).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
            class_286.method_43433((class_287.class_7433)buf.method_1326());
        }
    }
}

