/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.block.BlockItemBuilder;
import dev.latvian.mods.kubejs.block.BlockRightClickedEventJS;
import dev.latvian.mods.kubejs.block.BlockTintFunction;
import dev.latvian.mods.kubejs.block.KubeJSBlockProperties;
import dev.latvian.mods.kubejs.block.MapColorHelper;
import dev.latvian.mods.kubejs.block.RandomTickCallbackJS;
import dev.latvian.mods.kubejs.block.SoundTypeWrapper;
import dev.latvian.mods.kubejs.block.callbacks.AfterEntityFallenOnBlockCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockExplodedCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockStateMirrorCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockStateModifyCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockStateModifyPlacementCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.BlockStateRotateCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.CanBeReplacedCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.EntityFallenOnBlockCallbackJS;
import dev.latvian.mods.kubejs.block.callbacks.EntitySteppedOnBlockCallbackJS;
import dev.latvian.mods.kubejs.block.entity.BlockEntityBuilder;
import dev.latvian.mods.kubejs.block.entity.BlockEntityInfo;
import dev.latvian.mods.kubejs.client.ModelGenerator;
import dev.latvian.mods.kubejs.client.VariantBlockStateGenerator;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.loot.LootBuilder;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public abstract class BlockBuilder
extends BuilderBase<class_2248> {
    private static final Consumer<LootBuilder> EMPTY = loot -> {};
    private static final class_4970.class_4973 ALWAYS_FALSE_STATE_PREDICATE = (blockState, blockGetter, blockPos) -> false;
    private static final class_4970.class_4972<?> ALWAYS_FALSE_STATE_ARG_PREDICATE = (blockState, blockGetter, blockPos, type) -> false;
    public transient class_2498 soundType;
    public transient Function<class_2680, class_3620> mapColorFn;
    public transient float hardness = 1.5f;
    public transient float resistance = 3.0f;
    public transient float lightLevel = 0.0f;
    public transient boolean opaque = true;
    public transient boolean fullBlock = false;
    public transient boolean requiresTool = false;
    public transient String renderType = "solid";
    public transient BlockTintFunction tint;
    public final transient JsonObject textures;
    public transient String model;
    public transient BlockItemBuilder itemBuilder;
    public transient List<class_238> customShape;
    public transient boolean noCollision;
    public transient boolean notSolid;
    public transient float slipperiness = Float.NaN;
    public transient float speedFactor = Float.NaN;
    public transient float jumpFactor = Float.NaN;
    public Consumer<RandomTickCallbackJS> randomTickCallback;
    public Consumer<LootBuilder> lootTable;
    public JsonObject blockstateJson;
    public JsonObject modelJson;
    public transient boolean noValidSpawns;
    public transient boolean suffocating;
    public transient boolean viewBlocking;
    public transient boolean redstoneConductor;
    public transient boolean transparent;
    public transient class_2766 instrument;
    public transient Set<class_2769<?>> blockStateProperties;
    public transient Consumer<BlockStateModifyCallbackJS> defaultStateModification;
    public transient Consumer<BlockStateModifyPlacementCallbackJS> placementStateModification;
    public transient Predicate<CanBeReplacedCallbackJS> canBeReplacedFunction;
    public transient Consumer<EntitySteppedOnBlockCallbackJS> stepOnCallback;
    public transient Consumer<EntityFallenOnBlockCallbackJS> fallOnCallback;
    public transient Consumer<AfterEntityFallenOnBlockCallbackJS> afterFallenOnCallback;
    public transient Consumer<BlockExplodedCallbackJS> explodedCallback;
    public transient Consumer<BlockStateRotateCallbackJS> rotateStateModification;
    public transient Consumer<BlockStateMirrorCallbackJS> mirrorStateModification;
    public transient Consumer<BlockRightClickedEventJS> rightClick;
    public transient BlockEntityInfo blockEntityInfo;

    public BlockBuilder(class_2960 i) {
        super(i);
        this.soundType = class_2498.field_11547;
        this.mapColorFn = MapColorHelper.NONE;
        this.textures = new JsonObject();
        this.textureAll(this.id.method_12836() + ":block/" + this.id.method_12832());
        this.model = "";
        this.itemBuilder = this.getOrCreateItemBuilder();
        this.itemBuilder.blockBuilder = this;
        this.customShape = new ArrayList<class_238>();
        this.noCollision = false;
        this.notSolid = false;
        this.randomTickCallback = null;
        this.lootTable = null;
        this.blockstateJson = null;
        this.modelJson = null;
        this.noValidSpawns = false;
        this.suffocating = true;
        this.viewBlocking = true;
        this.redstoneConductor = true;
        this.transparent = false;
        this.blockStateProperties = new HashSet();
        this.defaultStateModification = null;
        this.placementStateModification = null;
        this.canBeReplacedFunction = null;
    }

    @Override
    public final RegistryInfo getRegistryType() {
        return RegistryInfo.BLOCK;
    }

    @Override
    public class_2248 transformObject(class_2248 obj) {
        obj.kjs$setBlockBuilder(this);
        return obj;
    }

    @Override
    public void createAdditionalObjects() {
        if (this.itemBuilder != null) {
            RegistryInfo.ITEM.addBuilder(this.itemBuilder);
        }
        if (this.blockEntityInfo != null) {
            RegistryInfo.BLOCK_ENTITY_TYPE.addBuilder(new BlockEntityBuilder(this.id, this.blockEntityInfo));
        }
    }

    @Override
    @Info(value="Sets the display name for this object, e.g. `Stone`.\n\nThis will be overridden by a lang file if it exists.\n")
    public BuilderBase<class_2248> displayName(class_2561 name) {
        if (this.itemBuilder != null) {
            this.itemBuilder.displayName(name);
        }
        return super.displayName(name);
    }

    @Override
    public void generateDataJsons(DataJsonGenerator generator) {
        if (this.lootTable == EMPTY) {
            return;
        }
        LootBuilder lootBuilder = new LootBuilder(null);
        lootBuilder.type = "minecraft:block";
        if (this.lootTable != null) {
            this.lootTable.accept(lootBuilder);
        } else if (((class_2248)this.get()).method_8389() != class_1802.field_8162) {
            lootBuilder.addPool(pool -> {
                pool.survivesExplosion();
                pool.addItem(new class_1799((class_1935)this.get()));
            });
        }
        JsonObject json = lootBuilder.toJson();
        generator.json(this.newID("loot_tables/blocks/", ""), (JsonElement)json);
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        if (this.blockstateJson != null) {
            generator.json(this.newID("blockstates/", ""), (JsonElement)this.blockstateJson);
        } else {
            generator.blockState(this.id, this::generateBlockStateJson);
        }
        if (this.modelJson != null) {
            generator.json(this.newID("models/block/", ""), (JsonElement)this.modelJson);
        } else {
            this.generateBlockModelJsons(generator);
        }
        if (this.itemBuilder != null) {
            if (this.itemBuilder.modelJson != null) {
                generator.json(this.newID("models/item/", ""), (JsonElement)this.itemBuilder.modelJson);
            } else {
                generator.itemModel(this.itemBuilder.id, this::generateItemModelJson);
            }
        }
    }

    protected void generateItemModelJson(ModelGenerator m) {
        if (!this.model.isEmpty()) {
            m.parent(this.model);
        } else {
            m.parent(this.newID("block/", "").toString());
        }
    }

    protected void generateBlockModelJsons(AssetJsonGenerator generator) {
        generator.blockModel(this.id, mg -> {
            String particle = this.textures.get("particle").getAsString();
            if (this.areAllTexturesEqual(this.textures, particle)) {
                mg.parent("minecraft:block/cube_all");
                mg.texture("all", particle);
            } else {
                mg.parent("block/cube");
                mg.textures(this.textures);
            }
            if (this.tint != null || !this.customShape.isEmpty()) {
                ArrayList<class_238> boxes = new ArrayList<class_238>(this.customShape);
                if (boxes.isEmpty()) {
                    boxes.add(new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
                }
                for (class_238 box : boxes) {
                    mg.element(e -> {
                        e.box(box);
                        for (class_2350 direction : class_2350.values()) {
                            e.face(direction, face -> {
                                face.tex("#" + direction.method_15434());
                                face.cull();
                                if (this.tint != null) {
                                    face.tintindex(0);
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    protected void generateBlockStateJson(VariantBlockStateGenerator bs) {
        bs.simpleVariant("", (String)(this.model.isEmpty() ? this.id.method_12836() + ":block/" + this.id.method_12832() : this.model));
    }

    protected boolean areAllTexturesEqual(JsonObject tex, String t) {
        for (class_2350 direction : class_2350.values()) {
            if (tex.get(direction.method_15434()).getAsString().equals(t)) continue;
            return false;
        }
        return true;
    }

    public BlockBuilder material(String material) {
        ConsoleJS.STARTUP.warn("blockBuilder.material(string) is no longer supported! Use .soundType(SoundType) and .mapColor(MapColor) instead!");
        return this;
    }

    @Info(value="Sets the block's sound type. Defaults to wood.")
    public BlockBuilder soundType(class_2498 m) {
        if (m == null || m == class_2498.field_44608) {
            this.soundType = class_2498.field_44608;
            ConsoleJS.STARTUP.error("Invalid sound type!");
            ConsoleJS.STARTUP.warn("Valid sound types: " + SoundTypeWrapper.INSTANCE.getMap().keySet());
            return this;
        }
        this.soundType = m;
        return this;
    }

    public BlockBuilder noSoundType() {
        return this.soundType(class_2498.field_44608);
    }

    public BlockBuilder woodSoundType() {
        return this.soundType(class_2498.field_11547);
    }

    public BlockBuilder stoneSoundType() {
        return this.soundType(class_2498.field_11544);
    }

    public BlockBuilder gravelSoundType() {
        return this.soundType(class_2498.field_11529);
    }

    public BlockBuilder grassSoundType() {
        return this.soundType(class_2498.field_11535);
    }

    public BlockBuilder sandSoundType() {
        return this.soundType(class_2498.field_11526);
    }

    public BlockBuilder cropSoundType() {
        return this.soundType(class_2498.field_17580);
    }

    public BlockBuilder glassSoundType() {
        return this.soundType(class_2498.field_11537);
    }

    @Info(value="Sets the block's map color. Defaults to NONE.")
    public BlockBuilder mapColor(class_3620 m) {
        this.mapColorFn = MapColorHelper.reverse(m);
        return this;
    }

    @Info(value="Sets the block's map color dynamically per block state. If unset, defaults to NONE.")
    public BlockBuilder dynamicMapColor(@Nullable Function<class_2680, Object> m) {
        this.mapColorFn = m == null ? MapColorHelper.NONE : s -> MapColorHelper.of(m.apply((class_2680)s));
        return this;
    }

    @Info(value="Sets the hardness of the block. Defaults to 1.5.\n\nSetting this to -1 will make the block unbreakable like bedrock.\n")
    public BlockBuilder hardness(float h) {
        this.hardness = h;
        return this;
    }

    @Info(value="Sets the blast resistance of the block. Defaults to 3.\n")
    public BlockBuilder resistance(float r) {
        this.resistance = r;
        return this;
    }

    @Info(value="Makes the block unbreakable.")
    public BlockBuilder unbreakable() {
        this.hardness = -1.0f;
        this.resistance = Float.MAX_VALUE;
        return this;
    }

    @Info(value="Sets the light level of the block. Defaults to 0 (no light).")
    public BlockBuilder lightLevel(float light) {
        this.lightLevel = light;
        return this;
    }

    @Info(value="Sets the opacity of the block. Opaque blocks do not let light through.")
    public BlockBuilder opaque(boolean o) {
        this.opaque = o;
        return this;
    }

    @Info(value="Sets the block should be a full block or not, like cactus or doors.")
    public BlockBuilder fullBlock(boolean f) {
        this.fullBlock = f;
        return this;
    }

    @Info(value="Makes the block require a tool to have drops when broken.")
    public BlockBuilder requiresTool(boolean f) {
        this.requiresTool = f;
        return this;
    }

    @Info(value="Makes the block require a tool to have drops when broken.")
    public BlockBuilder requiresTool() {
        return this.requiresTool(true);
    }

    @Info(value="Sets the render type of the block. Can be `cutout`, `cutout_mipped`, `translucent`, or `basic`.\n")
    public BlockBuilder renderType(String l) {
        this.renderType = l;
        return this;
    }

    @Info(value="Set the color of a specific layer of the block.\n")
    public BlockBuilder color(int index, BlockTintFunction color) {
        if (!(this.tint instanceof BlockTintFunction.Mapped)) {
            this.tint = new BlockTintFunction.Mapped();
        }
        ((BlockTintFunction.Mapped)this.tint).map.put(index, (Object)color);
        return this;
    }

    @Info(value="Set the color of a specific layer of the block.\n")
    public BlockBuilder color(BlockTintFunction color) {
        this.tint = color;
        return this;
    }

    @Info(value="Texture the block on all sides with the same texture.\n")
    public BlockBuilder textureAll(String tex) {
        for (class_2350 direction : class_2350.values()) {
            this.textureSide(direction, tex);
        }
        this.textures.addProperty("particle", tex);
        return this;
    }

    @Info(value="Texture a specific side of the block.\n")
    public BlockBuilder textureSide(class_2350 direction, String tex) {
        return this.texture(direction.method_15434(), tex);
    }

    @Info(value="Texture a specific texture key of the block.\n")
    public BlockBuilder texture(String id, String tex) {
        this.textures.addProperty(id, tex);
        return this;
    }

    @Info(value="Set the block's model.\n")
    public BlockBuilder model(String m) {
        this.model = m;
        if (this.itemBuilder != null) {
            this.itemBuilder.parentModel(m);
        }
        return this;
    }

    @Info(value="Modifies the block's item representation.\n")
    public BlockBuilder item(@Nullable Consumer<BlockItemBuilder> i) {
        if (i == null) {
            this.itemBuilder = null;
            this.lootTable = EMPTY;
        } else {
            if (this.itemBuilder == null) {
                this.itemBuilder = this.getOrCreateItemBuilder();
                this.itemBuilder.blockBuilder = this;
                ScriptType.STARTUP.console.warn("`item` is called with non-null builder callback after block item is set to null! Creating another block item as fallback.");
            }
            i.accept(this.itemBuilder);
        }
        return this;
    }

    @HideFromJS
    protected BlockItemBuilder getOrCreateItemBuilder() {
        return this.itemBuilder == null ? (this.itemBuilder = new BlockItemBuilder(this.id)) : this.itemBuilder;
    }

    @Info(value="Set the block to have no corresponding item.\n")
    public BlockBuilder noItem() {
        return this.item(null);
    }

    @Info(value="Set the shape of the block.")
    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1, boolean scale16) {
        if (scale16) {
            this.customShape.add(new class_238(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0));
        } else {
            this.customShape.add(new class_238(x0, y0, z0, x1, y1, z1));
        }
        return this;
    }

    @Info(value="Set the shape of the block.")
    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1) {
        return this.box(x0, y0, z0, x1, y1, z1, true);
    }

    public static class_265 createShape(List<class_238> boxes) {
        if (boxes.isEmpty()) {
            return class_259.method_1077();
        }
        class_265 shape = class_259.method_1078((class_238)boxes.get(0));
        for (int i = 1; i < boxes.size(); ++i) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_259.method_1078((class_238)boxes.get(i)));
        }
        return shape;
    }

    @Info(value="Makes the block not collide with entities.")
    public BlockBuilder noCollision() {
        this.noCollision = true;
        return this;
    }

    @Info(value="Makes the block not be solid.")
    public BlockBuilder notSolid() {
        this.notSolid = true;
        return this;
    }

    @Deprecated(forRemoval=true)
    public BlockBuilder setWaterlogged(boolean waterlogged) {
        ScriptType.STARTUP.console.warn("\"BlockBuilder.waterlogged\" is a deprecated property! Please use \"BlockBuilder.property(BlockProperties.WATERLOGGED)\" instead.");
        if (waterlogged) {
            this.property((class_2769<?>)class_2741.field_12508);
        }
        return this;
    }

    @Deprecated(forRemoval=true)
    public boolean getWaterlogged() {
        ScriptType.STARTUP.console.warn("\"BlockBuilder.waterlogged\" is a deprecated property! Please use \"BlockBuilder.property(BlockProperties.WATERLOGGED)\" instead.");
        return this.canBeWaterlogged();
    }

    @Info(value="Makes the block can be waterlogged.")
    public BlockBuilder waterlogged() {
        return this.property((class_2769<?>)class_2741.field_12508);
    }

    @Info(value="Checks if the block can be waterlogged.")
    public boolean canBeWaterlogged() {
        return this.blockStateProperties.contains(class_2741.field_12508);
    }

    @Info(value="Clears all drops for the block.")
    public BlockBuilder noDrops() {
        this.lootTable = EMPTY;
        return this;
    }

    @Info(value="Set how slippery the block is.")
    public BlockBuilder slipperiness(float f) {
        this.slipperiness = f;
        return this;
    }

    @Info(value="Set how fast you can walk on the block.\n\nAny value above 1 will make you walk insanely fast as your speed is multiplied by this value each tick.\n\nRecommended values are between 0.1 and 1, useful for mimicking soul sand or ice.\n")
    public BlockBuilder speedFactor(float f) {
        this.speedFactor = f;
        return this;
    }

    @Info(value="Set how high you can jump on the block.")
    public BlockBuilder jumpFactor(float f) {
        this.jumpFactor = f;
        return this;
    }

    @Info(value="Sets random tick callback for this black.")
    public BlockBuilder randomTick(@Nullable Consumer<RandomTickCallbackJS> randomTickCallback) {
        this.randomTickCallback = randomTickCallback;
        return this;
    }

    @Info(value="Makes mobs not spawn on the block.")
    public BlockBuilder noValidSpawns(boolean b) {
        this.noValidSpawns = b;
        return this;
    }

    @Info(value="Makes the block suffocating.")
    public BlockBuilder suffocating(boolean b) {
        this.suffocating = b;
        return this;
    }

    @Info(value="Makes the block view blocking.")
    public BlockBuilder viewBlocking(boolean b) {
        this.viewBlocking = b;
        return this;
    }

    @Info(value="Makes the block a redstone conductor.")
    public BlockBuilder redstoneConductor(boolean b) {
        this.redstoneConductor = b;
        return this;
    }

    @Info(value="Makes the block transparent.")
    public BlockBuilder transparent(boolean b) {
        this.transparent = b;
        return this;
    }

    @Info(value="Helper method for setting the render type of the block to `cutout` correctly.")
    public BlockBuilder defaultCutout() {
        return this.renderType("cutout").notSolid().noValidSpawns(true).suffocating(false).viewBlocking(false).redstoneConductor(false).transparent(true);
    }

    @Info(value="Helper method for setting the render type of the block to `translucent` correctly.")
    public BlockBuilder defaultTranslucent() {
        return this.defaultCutout().renderType("translucent");
    }

    @Info(value="Note block instrument.")
    public BlockBuilder instrument(class_2766 i) {
        this.instrument = i;
        return this;
    }

    @Info(value="Tags both the block and the item with the given tag.")
    public BlockBuilder tag(class_2960 tag) {
        return this.tagBoth(tag);
    }

    @Info(value="Tags both the block and the item with the given tag.")
    public BlockBuilder tagBoth(class_2960 tag) {
        this.tagBlock(tag);
        this.tagItem(tag);
        return this;
    }

    @Info(value="Tags the block with the given tag.")
    public BlockBuilder tagBlock(class_2960 tag) {
        super.tag(tag);
        return this;
    }

    @Info(value="Tags the item with the given tag.")
    public BlockBuilder tagItem(class_2960 tag) {
        this.itemBuilder.tag(tag);
        return this;
    }

    @Info(value="Set the default state of the block.")
    public BlockBuilder defaultState(Consumer<BlockStateModifyCallbackJS> callbackJS) {
        this.defaultStateModification = callbackJS;
        return this;
    }

    @Info(value="Set the callback for determining the blocks state when placed.")
    public BlockBuilder placementState(Consumer<BlockStateModifyPlacementCallbackJS> callbackJS) {
        this.placementStateModification = callbackJS;
        return this;
    }

    @Info(value="Set if the block can be replaced by something else.")
    public BlockBuilder canBeReplaced(Predicate<CanBeReplacedCallbackJS> callbackJS) {
        this.canBeReplacedFunction = callbackJS;
        return this;
    }

    @Info(value="Set what happens when an entity steps on the block\nThis is called every tick for every entity standing on the block, so be careful what you do here.\n")
    public BlockBuilder steppedOn(Consumer<EntitySteppedOnBlockCallbackJS> callbackJS) {
        this.stepOnCallback = callbackJS;
        return this;
    }

    @Info(value="Set what happens when an entity falls on the block. Do not use this for moving them, use bounce instead!")
    public BlockBuilder fallenOn(Consumer<EntityFallenOnBlockCallbackJS> callbackJS) {
        this.fallOnCallback = callbackJS;
        return this;
    }

    @Info(value="Bounces entities that land on this block by bounciness * their fall velocity.\nDo not make bounciness negative, as that is a recipe for a long and laggy trip to the void\n")
    public BlockBuilder bounciness(float bounciness) {
        return this.afterFallenOn(ctx -> ctx.bounce(bounciness));
    }

    @Info(value="Set how this block bounces/moves entities that land on top of this. Do not use this to modify the block, use fallOn instead!\nUse ctx.bounce(height) or ctx.setVelocity(x, y, z) to change the entities velocity.\n")
    public BlockBuilder afterFallenOn(Consumer<AfterEntityFallenOnBlockCallbackJS> callbackJS) {
        this.afterFallenOnCallback = callbackJS;
        return this;
    }

    @Info(value="Set how this block reacts after an explosion. Note the block has already been destroyed at this point")
    public BlockBuilder exploded(Consumer<BlockExplodedCallbackJS> callbackJS) {
        this.explodedCallback = callbackJS;
        return this;
    }

    @Info(value="Add a blockstate property to the block.\n\nFor example, facing, lit, etc.\n")
    public BlockBuilder property(class_2769<?> property) {
        if (property.method_11898().size() <= 1) {
            throw new IllegalArgumentException(String.format("Block \"%s\" has an illegal Blockstate Property \"%s\" which has <= 1 possible values. (%d possible values)", this.id, property.method_11899(), property.method_11898().size()));
        }
        this.blockStateProperties.add(property);
        return this;
    }

    @Info(value="Set the callback used for determining how the block rotates")
    public BlockBuilder rotateState(Consumer<BlockStateRotateCallbackJS> callbackJS) {
        this.rotateStateModification = callbackJS;
        return this;
    }

    @Info(value="Set the callback used for determining how the block is mirrored")
    public BlockBuilder mirrorState(Consumer<BlockStateMirrorCallbackJS> callbackJS) {
        this.mirrorStateModification = callbackJS;
        return this;
    }

    @Info(value="Set the callback used for right-clicking on the block")
    public BlockBuilder rightClick(Consumer<BlockRightClickedEventJS> callbackJS) {
        this.rightClick = callbackJS;
        return this;
    }

    @Info(value="Creates a Block Entity for this block")
    public BlockBuilder blockEntity(Consumer<BlockEntityInfo> callback) {
        this.blockEntityInfo = new BlockEntityInfo(this);
        callback.accept(this.blockEntityInfo);
        return this;
    }

    public class_4970.class_2251 createProperties() {
        KubeJSBlockProperties properties = new KubeJSBlockProperties(this);
        properties.method_9626(this.soundType);
        properties.method_51520(this.mapColorFn);
        if (this.resistance >= 0.0f) {
            properties.method_9629(this.hardness, this.resistance);
        } else {
            properties.method_9632(this.hardness);
        }
        properties.method_9631(state -> (int)(this.lightLevel * 15.0f));
        if (this.noCollision) {
            properties.method_9634();
        }
        if (this.notSolid) {
            properties.method_22488();
        }
        if (this.requiresTool) {
            properties.method_29292();
        }
        if (this.lootTable == EMPTY) {
            properties.method_42327();
        }
        if (!Float.isNaN(this.slipperiness)) {
            properties.method_9628(this.slipperiness);
        }
        if (!Float.isNaN(this.speedFactor)) {
            properties.method_23351(this.speedFactor);
        }
        if (!Float.isNaN(this.jumpFactor)) {
            properties.method_23352(this.jumpFactor);
        }
        if (this.noValidSpawns) {
            properties.method_26235((class_4970.class_4972)UtilsJS.cast(ALWAYS_FALSE_STATE_ARG_PREDICATE));
        }
        if (!this.suffocating) {
            properties.method_26243(ALWAYS_FALSE_STATE_PREDICATE);
        }
        if (!this.viewBlocking) {
            properties.method_26245(ALWAYS_FALSE_STATE_PREDICATE);
        }
        if (!this.redstoneConductor) {
            properties.method_26236(ALWAYS_FALSE_STATE_PREDICATE);
        }
        if (this.randomTickCallback != null) {
            properties.method_9640();
        }
        if (this.instrument != null) {
            properties.method_51368(this.instrument);
        }
        return properties;
    }
}

