/*
 * Decompiled with CFR 0.152.
 */
package com.dynview.config;

import com.dynview.DynView;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class CommonConfiguration {
    public int minChunkViewDist = 5;
    public int maxChunkViewDist = 15;
    public int meanAvgTickTime = 45;
    public int viewDistanceUpdateRate = 30;
    public boolean logMessages = true;
    public boolean chunkunload = true;
    public boolean adjustSimulationDistance = true;
    public int minSimulationDist = 4;
    public int maxSimulationDist = 10;

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "The minimum chunk view distance allowed to use. Default: 5, minimum 3, maximum 200");
        entry.addProperty("minChunkViewDist", (Number)this.minChunkViewDist);
        root.add("minChunkViewDist", (JsonElement)entry);
        JsonObject entry2 = new JsonObject();
        entry2.addProperty("desc:", "The maximum chunk view distance allowed to use. Set to the max a player could benefit from. Default: 15, minimum 1, maximum 200");
        entry2.addProperty("maxChunkViewDist", (Number)this.maxChunkViewDist);
        root.add("maxChunkViewDist", (JsonElement)entry2);
        JsonObject entry3 = new JsonObject();
        entry3.addProperty("desc:", "The average tick time to stabilize the distances around. Setting it higher than 50ms is not advised, as after 50ms the TPS will go below 20. Default: 45ms, min: 10, max:100");
        entry3.addProperty("meanAvgTickTime", (Number)this.meanAvgTickTime);
        root.add("meanAvgTickTime", (JsonElement)entry3);
        JsonObject entry4 = new JsonObject();
        entry4.addProperty("desc:", "The change frequency of distances in seconds. Default: 30, min:1, max:1000");
        entry4.addProperty("viewDistanceUpdateRate", (Number)this.viewDistanceUpdateRate);
        root.add("viewDistanceUpdateRate", (JsonElement)entry4);
        JsonObject entry8 = new JsonObject();
        entry8.addProperty("desc:", "The minimum simulation distance allowed to use. Default: 4, minimum 1, maximum 200");
        entry8.addProperty("minSimulationDist", (Number)this.minSimulationDist);
        root.add("minSimulationDist", (JsonElement)entry8);
        JsonObject entry9 = new JsonObject();
        entry9.addProperty("desc:", "The maximum simulation distance allowed to use. Default: 10, minimum 1, maximum 200");
        entry9.addProperty("maxSimulationDist", (Number)this.maxSimulationDist);
        root.add("maxSimulationDist", (JsonElement)entry9);
        JsonObject entry7 = new JsonObject();
        entry7.addProperty("desc:", "Enables automatic simulation distance adjustment. Default: true");
        entry7.addProperty("adjustSimulationDistance", Boolean.valueOf(this.adjustSimulationDistance));
        root.add("adjustSimulationDistance", (JsonElement)entry7);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "Whether to output log messages for actions done. This can be helpful to balance the other settings nicely. Default = true");
        entry5.addProperty("logMessages", Boolean.valueOf(this.logMessages));
        root.add("logMessages", (JsonElement)entry5);
        JsonObject entry6 = new JsonObject();
        entry6.addProperty("desc:", "Enable slow chunk unloading(~1minute) after load, helps with lag caused by mods hot-loading chunks frequently. Default: true");
        entry6.addProperty("chunkunload", Boolean.valueOf(this.chunkunload));
        root.add("chunkunload", (JsonElement)entry6);
        return root;
    }

    public void deserialize(JsonObject data) {
        if (data == null) {
            DynView.LOGGER.error("Config file was empty!");
            return;
        }
        this.minChunkViewDist = data.get("minChunkViewDist").getAsJsonObject().get("minChunkViewDist").getAsInt();
        this.minSimulationDist = data.get("minSimulationDist").getAsJsonObject().get("minSimulationDist").getAsInt();
        this.maxSimulationDist = data.get("maxSimulationDist").getAsJsonObject().get("maxSimulationDist").getAsInt();
        this.maxChunkViewDist = data.get("maxChunkViewDist").getAsJsonObject().get("maxChunkViewDist").getAsInt();
        this.meanAvgTickTime = data.get("meanAvgTickTime").getAsJsonObject().get("meanAvgTickTime").getAsInt();
        this.viewDistanceUpdateRate = data.get("viewDistanceUpdateRate").getAsJsonObject().get("viewDistanceUpdateRate").getAsInt();
        this.logMessages = data.get("logMessages").getAsJsonObject().get("logMessages").getAsBoolean();
        this.chunkunload = data.get("chunkunload").getAsJsonObject().get("chunkunload").getAsBoolean();
        this.adjustSimulationDistance = data.get("adjustSimulationDistance").getAsJsonObject().get("adjustSimulationDistance").getAsBoolean();
    }
}

