/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.networking;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.compacting.CompressionLadder;
import io.github.mattidragon.extendeddrawers.compacting.CompressionRecipeManager;
import java.util.List;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2359;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public record CompressionOverrideSyncPacket(List<CompressionLadder> overrides) implements FabricPacket
{
    public static final PacketType<CompressionOverrideSyncPacket> TYPE = PacketType.create((class_2960)ExtendedDrawers.id("compression_override_sync"), CompressionOverrideSyncPacket::new);

    public CompressionOverrideSyncPacket(class_2540 buf) {
        this(buf.method_34066(buf1 -> {
            CompressionLadder ladder = new CompressionLadder(buf1.method_34066(buf2 -> {
                class_1792 item = (class_1792)buf2.method_42064((class_2359)class_7923.field_41178);
                if (item == null) {
                    throw new NoSuchElementException("Invalid item in compression ladder deserialization");
                }
                class_2487 nbt = buf2.method_10798();
                int size = buf2.method_10816();
                return new CompressionLadder.Step(ItemVariant.of((class_1935)item, (class_2487)nbt), size);
            }));
            if (ladder.steps().isEmpty()) {
                throw new IllegalStateException("No steps in ladder");
            }
            int compression = 0;
            for (CompressionLadder.Step step : ladder.steps()) {
                if (compression >= step.size()) {
                    throw new IllegalStateException("Illegal ladder order");
                }
                compression = step.size();
            }
            return ladder;
        }));
    }

    public static void register() {
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> ServerPlayNetworking.send((class_3222)player, (FabricPacket)new CompressionOverrideSyncPacket(CompressionRecipeManager.of(player.field_13995.method_3772()).getOverrides())));
    }

    public void write(class_2540 buf) {
        buf.method_34062(this.overrides, (buf1, ladder) -> buf1.method_34062(ladder.steps(), (buf2, step) -> {
            buf2.method_42065((class_2359)class_7923.field_41178, (Object)step.item().getItem());
            buf2.method_10794(step.item().getNbt());
            buf2.method_10804(step.size());
        }));
    }

    public PacketType<?> getType() {
        return TYPE;
    }
}

