/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.config;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.LongFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererManager;
import io.github.mattidragon.configloader.api.ConfigManager;
import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.client.config.IdentifierController;
import io.github.mattidragon.extendeddrawers.client.renderer.AbstractDrawerBlockEntityRenderer;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.ClientCategory;
import io.github.mattidragon.extendeddrawers.config.category.MutableClientCategory;
import io.github.mattidragon.extendeddrawers.config.category.MutableMiscCategory;
import io.github.mattidragon.extendeddrawers.config.category.MutableStorageCategory;
import io.github.mattidragon.extendeddrawers.misc.CreativeBreakingBehaviour;
import io.github.mattidragon.extendeddrawers.network.cache.CachingMode;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_746;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class ConfigScreenFactory {
    public static final ValueFormatter<Float> FLOAT_FORMATTER;

    public static class_437 createScreen(class_437 parent, ConfigData config, Consumer<ConfigData> saveConsumer) {
        MutableClientCategory client = config.client().toMutable();
        MutableStorageCategory storage = config.storage().toMutable();
        MutableMiscCategory misc = config.misc().toMutable();
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"config.extended_drawers")).category(ConfigScreenFactory.createStorageCategory(storage)).category(ConfigScreenFactory.createMiscCategory(misc)).category(ConfigScreenFactory.createClientCategory(client)).save(() -> saveConsumer.accept(new ConfigData(client.toImmutable(), storage.toImmutable(), misc.toImmutable()))).build().generateScreen(parent);
    }

    private static ConfigCategory createStorageCategory(MutableStorageCategory instance) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage.drawerCapacity")).binding((Object)ConfigData.DEFAULT.storage().drawerCapacity(), instance::drawerCapacity, instance::drawerCapacity).controller(option -> LongFieldControllerBuilder.create((Option)option).min((Number)1L)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.storage.drawerCapacity.description")})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage.compactingCapacity")).binding((Object)ConfigData.DEFAULT.storage().compactingCapacity(), instance::compactingCapacity, instance::compactingCapacity).controller(option -> LongFieldControllerBuilder.create((Option)option).min((Number)1L)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.storage.compactingCapacity.description")})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage.stackSizeAffectsCapacity")).binding((Object)ConfigData.DEFAULT.storage().stackSizeAffectsCapacity(), instance::stackSizeAffectsCapacity, instance::stackSizeAffectsCapacity).controller(TickBoxControllerBuilder::create).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.storage.stackSizeAffectsCapacity.description")})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage.slotCountAffectsCapacity")).binding((Object)ConfigData.DEFAULT.storage().slotCountAffectsCapacity(), instance::slotCountAffectsCapacity, instance::slotCountAffectsCapacity).controller(TickBoxControllerBuilder::create).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.storage.slotCountAffectsCapacity.description")})).build()).group(OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage.upgradeMultipliers")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.storage.upgradeMultipliers.description")})).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage.upgradeMultipliers.1")).binding((Object)ConfigData.DEFAULT.storage().t1UpgradeMultiplier(), instance::t1UpgradeMultiplier, instance::t1UpgradeMultiplier).controller(option -> IntegerFieldControllerBuilder.create((Option)option).min((Number)1)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43469((String)"config.extended_drawers.storage.upgradeMultipliers.n.description", (Object[])new Object[]{1})})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage.upgradeMultipliers.2")).binding((Object)ConfigData.DEFAULT.storage().t2UpgradeMultiplier(), instance::t2UpgradeMultiplier, instance::t2UpgradeMultiplier).controller(option -> IntegerFieldControllerBuilder.create((Option)option).min((Number)1)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43469((String)"config.extended_drawers.storage.upgradeMultipliers.n.description", (Object[])new Object[]{2})})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage.upgradeMultipliers.3")).binding((Object)ConfigData.DEFAULT.storage().t3UpgradeMultiplier(), instance::t3UpgradeMultiplier, instance::t3UpgradeMultiplier).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43469((String)"config.extended_drawers.storage.upgradeMultipliers.n.description", (Object[])new Object[]{3})})).controller(option -> IntegerFieldControllerBuilder.create((Option)option).min((Number)1)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.storage.upgradeMultipliers.4")).binding((Object)ConfigData.DEFAULT.storage().t4UpgradeMultiplier(), instance::t4UpgradeMultiplier, instance::t4UpgradeMultiplier).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43469((String)"config.extended_drawers.storage.upgradeMultipliers.n.description", (Object[])new Object[]{4})})).controller(option -> IntegerFieldControllerBuilder.create((Option)option).min((Number)1)).build()).build()).build();
    }

    private static ConfigCategory createMiscCategory(MutableMiscCategory instance) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.insertAllTime")).binding((Object)ConfigData.DEFAULT.misc().insertAllTime(), instance::insertAllTime, instance::insertAllTime).controller(option -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)option).min((Number)1)).max((Number)20)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.misc.insertAllTime.description")})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.frontBreakingBehaviour")).binding((Object)ConfigData.DEFAULT.misc().frontBreakingBehaviour(), instance::frontBreakingBehaviour, instance::frontBreakingBehaviour).controller(option -> EnumControllerBuilder.create((Option)option).enumClass(CreativeBreakingBehaviour.class).formatValue(CreativeBreakingBehaviour::getDisplayName)).description(value -> ConfigScreenFactory.creativeBreakingBehaviourDescription((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.frontBreakingBehaviour.description"), value)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.sideBreakingBehaviour")).binding((Object)ConfigData.DEFAULT.misc().sideBreakingBehaviour(), instance::sideBreakingBehaviour, instance::sideBreakingBehaviour).controller(option -> EnumControllerBuilder.create((Option)option).enumClass(CreativeBreakingBehaviour.class).formatValue(CreativeBreakingBehaviour::getDisplayName)).description(value -> ConfigScreenFactory.creativeBreakingBehaviourDescription((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.sideBreakingBehaviour.description"), value)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.cachingMode")).binding((Object)ConfigData.DEFAULT.misc().cachingMode(), instance::cachingMode, instance::cachingMode).controller(option -> EnumControllerBuilder.create((Option)option).enumClass(CachingMode.class).formatValue(CachingMode::getDisplayName)).description(option -> OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.misc.cachingMode.description").method_10852((class_2561)class_2561.method_43471((String)"config.extended_drawers.cachingMode.%s.description".formatted(option.method_15434())))})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.blockUpgradeRemovalsWithOverflow")).binding((Object)ConfigData.DEFAULT.misc().blockUpgradeRemovalsWithOverflow(), instance::blockUpgradeRemovalsWithOverflow, instance::blockUpgradeRemovalsWithOverflow).controller(TickBoxControllerBuilder::create).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.misc.blockUpgradeRemovalsWithOverflow.description")})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.allowRecursion")).binding((Object)ConfigData.DEFAULT.misc().allowRecursion(), instance::allowRecursion, instance::allowRecursion).controller(TickBoxControllerBuilder::create).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.misc.allowRecursion.description").method_10852((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.allowRecursion.warning").method_27692(class_124.field_1054))})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.drawersDropContentsOnBreak")).binding((Object)ConfigData.DEFAULT.misc().drawersDropContentsOnBreak(), instance::drawersDropContentsOnBreak, instance::drawersDropContentsOnBreak).controller(TickBoxControllerBuilder::create).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.misc.drawersDropContentsOnBreak.description").method_10852((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.drawersDropContentsOnBreak.warning").method_27692(class_124.field_1054))})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.misc.dropDrawersInCreative")).binding((Object)ConfigData.DEFAULT.misc().dropDrawersInCreative(), instance::dropDrawersInCreative, instance::dropDrawersInCreative).controller(TickBoxControllerBuilder::create).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.misc.dropDrawersInCreative.description")})).build()).build();
    }

    private static ConfigCategory createClientCategory(MutableClientCategory instance) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client")).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.itemRenderDistance")).binding((Object)ConfigData.DEFAULT.client().itemRenderDistance(), instance::itemRenderDistance, instance::itemRenderDistance).controller(option -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)option).min((Number)16)).max((Number)256)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.itemRenderDistance.description")})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.iconRenderDistance")).binding((Object)ConfigData.DEFAULT.client().iconRenderDistance(), instance::iconRenderDistance, instance::iconRenderDistance).controller(option -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)option).min((Number)16)).max((Number)256)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.iconRenderDistance.description")})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.textRenderDistance")).binding((Object)ConfigData.DEFAULT.client().textRenderDistance(), instance::textRenderDistance, instance::textRenderDistance).controller(option -> ((IntegerFieldControllerBuilder)IntegerFieldControllerBuilder.create((Option)option).min((Number)16)).max((Number)256)).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.textRenderDistance.description")})).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.displayEmptyCount")).binding((Object)ConfigData.DEFAULT.client().displayEmptyCount(), instance::displayEmptyCount, instance::displayEmptyCount).controller(TickBoxControllerBuilder::create).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.displayEmptyCount.description")})).build()).group(ConfigScreenFactory.createLayoutGroup(instance.layout())).group(ConfigScreenFactory.createIconGroup(instance.icons())).build();
    }

    private static OptionGroup createIconGroup(MutableClientCategory.MutableIconGroup icons) {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.icons")).collapsed(true).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.lockedIcon")).binding((Object)ConfigData.DEFAULT.client().icons().lockedIcon(), icons::lockedIcon, icons::lockedIcon).customController(IdentifierController::new).description(id -> OptionDescription.createBuilder().customImage((CompletableFuture)ImageRendererManager.registerImage((class_2960)id, () -> () -> new IconRenderer((class_2960)id)).thenApply(Optional::of)).text(new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.lockedIcon.description")}).build()).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.voidingIcon")).binding((Object)ConfigData.DEFAULT.client().icons().voidingIcon(), icons::voidingIcon, icons::voidingIcon).customController(IdentifierController::new).description(id -> OptionDescription.createBuilder().customImage((CompletableFuture)ImageRendererManager.registerImage((class_2960)id, () -> () -> new IconRenderer((class_2960)id)).thenApply(Optional::of)).text(new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.voidingIcon.description")}).build()).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.hiddenIcon")).binding((Object)ConfigData.DEFAULT.client().icons().hiddenIcon(), icons::hiddenIcon, icons::hiddenIcon).customController(IdentifierController::new).description(id -> OptionDescription.createBuilder().customImage((CompletableFuture)ImageRendererManager.registerImage((class_2960)id, () -> () -> new IconRenderer((class_2960)id)).thenApply(Optional::of)).text(new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.hiddenIcon.description")}).build()).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.dupingIcon")).binding((Object)ConfigData.DEFAULT.client().icons().dupingIcon(), icons::dupingIcon, icons::dupingIcon).customController(IdentifierController::new).description(id -> OptionDescription.createBuilder().customImage((CompletableFuture)ImageRendererManager.registerImage((class_2960)id, () -> () -> new IconRenderer((class_2960)id)).thenApply(Optional::of)).text(new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.dupingIcon.description")}).build()).build()).build();
    }

    private static OptionGroup createLayoutGroup(MutableClientCategory.MutableLayoutGroup instance) {
        LayoutRenderer layoutRenderer = new LayoutRenderer();
        Option smallItemScale = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.smallItemScale")).binding((Object)Float.valueOf(ConfigData.DEFAULT.client().layout().smallItemScale()), instance::smallItemScale, instance::smallItemScale).controller(option -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).formatValue(FLOAT_FORMATTER)).description(OptionDescription.createBuilder().customImage(CompletableFuture.completedFuture(Optional.of(layoutRenderer))).text(new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.smallItemScale.description")}).build()).build();
        Option largeItemScale = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.largeItemScale")).binding((Object)Float.valueOf(ConfigData.DEFAULT.client().layout().largeItemScale()), instance::largeItemScale, instance::largeItemScale).controller(option -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).formatValue(FLOAT_FORMATTER)).description(OptionDescription.createBuilder().customImage(CompletableFuture.completedFuture(Optional.of(layoutRenderer))).text(new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.largeItemScale.description")}).build()).build();
        Option smallTextScale = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.smallTextScale")).binding((Object)Float.valueOf(ConfigData.DEFAULT.client().layout().smallTextScale()), instance::smallTextScale, instance::smallTextScale).controller(option -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).formatValue(FLOAT_FORMATTER)).description(OptionDescription.createBuilder().customImage(CompletableFuture.completedFuture(Optional.of(layoutRenderer))).text(new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.smallTextScale.description")}).build()).build();
        Option largeTextScale = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.largeTextScale")).binding((Object)Float.valueOf(ConfigData.DEFAULT.client().layout().largeTextScale()), instance::largeTextScale, instance::largeTextScale).controller(option -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).step((Number)Float.valueOf(0.05f))).formatValue(FLOAT_FORMATTER)).description(OptionDescription.createBuilder().customImage(CompletableFuture.completedFuture(Optional.of(layoutRenderer))).text(new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.largeTextScale.description")}).build()).build();
        Option textOffset = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.textOffset")).binding((Object)Float.valueOf(ConfigData.DEFAULT.client().layout().textOffset()), instance::textOffset, instance::textOffset).controller(option -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.05f))).formatValue(FLOAT_FORMATTER)).description(OptionDescription.createBuilder().customImage(CompletableFuture.completedFuture(Optional.of(layoutRenderer))).text(new class_2561[]{class_2561.method_43471((String)"config.extended_drawers.client.textOffset.description")}).build()).build();
        layoutRenderer.init((Option<Float>)smallItemScale, (Option<Float>)largeItemScale, (Option<Float>)smallTextScale, (Option<Float>)largeTextScale, (Option<Float>)textOffset);
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"config.extended_drawers.client.layout")).collapsed(true).option(smallItemScale).option(largeItemScale).option(smallTextScale).option(largeTextScale).option(textOffset).build();
    }

    private static OptionDescription creativeBreakingBehaviourDescription(class_2561 text, CreativeBreakingBehaviour value) {
        return OptionDescription.of((class_2561[])new class_2561[]{text, class_2561.method_43471((String)("config.extended_drawers.creativeBreakingBehaviour." + value.method_15434() + ".description"))});
    }

    static {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
        format.setMaximumFractionDigits(3);
        FLOAT_FORMATTER = value -> class_2561.method_43470((String)format.format(value));
    }

    @Environment(value=EnvType.CLIENT)
    private static class LayoutRenderer
    implements ImageRenderer {
        private Option<Float> smallItemScale = null;
        private Option<Float> largeItemScale = null;
        private Option<Float> smallTextScale = null;
        private Option<Float> largeTextScale = null;
        private Option<Float> textOffset = null;
        private boolean initialized = false;

        private LayoutRenderer() {
        }

        public void init(Option<Float> smallItemScale, Option<Float> largeItemScale, Option<Float> smallTextScale, Option<Float> largeTextScale, Option<Float> textOffset) {
            this.smallItemScale = smallItemScale;
            this.largeItemScale = largeItemScale;
            this.smallTextScale = smallTextScale;
            this.largeTextScale = largeTextScale;
            this.textOffset = textOffset;
            this.initialized = true;
        }

        public int render(class_332 context, int x, int y, int renderWidth, float tickDelta) {
            if (!this.initialized) {
                return 0;
            }
            Function atlas = class_310.method_1551().method_1549(class_1723.field_21668);
            int size = renderWidth / 3;
            ConfigData config = (ConfigData)ExtendedDrawers.CONFIG.get();
            ClientCategory client = config.client();
            ConfigData newConfig = new ConfigData(new ClientCategory(client.itemRenderDistance(), client.iconRenderDistance(), client.textRenderDistance(), client.displayEmptyCount(), new ClientCategory.LayoutGroup(((Float)this.smallItemScale.pendingValue()).floatValue(), ((Float)this.largeItemScale.pendingValue()).floatValue(), ((Float)this.smallTextScale.pendingValue()).floatValue(), ((Float)this.largeTextScale.pendingValue()).floatValue(), ((Float)this.textOffset.pendingValue()).floatValue()), client.icons()), config.storage(), config.misc());
            AbstractDrawerBlockEntityRenderer<class_2586> renderer = AbstractDrawerBlockEntityRenderer.createRendererTool();
            class_4587 matrices = context.method_51448();
            class_746 player = class_310.method_1551().field_1724;
            class_2338 playerPos = player == null ? class_2338.field_10980 : player.method_24515();
            try (ConfigManager.OverrideCloser ignored = ExtendedDrawers.CONFIG.override((Object)newConfig);){
                context.method_25298(x, y, 0, size, size, (class_1058)atlas.apply(ExtendedDrawers.id("block/single_drawer")));
                context.method_25298(x + size, y, 0, size, size, (class_1058)atlas.apply(ExtendedDrawers.id("block/quad_drawer")));
                context.method_25298(x + 2 * size, y, 0, size, size, (class_1058)atlas.apply(ExtendedDrawers.id("block/compacting_drawer")));
                matrices.method_22903();
                matrices.method_46416((float)x, (float)y, 1.0f);
                matrices.method_22905((float)size, (float)size, (float)(-size));
                matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
                matrices.method_22904(0.5, -0.5, 0.0);
                class_1058 voidingSprite = (class_1058)atlas.apply(new class_2960("minecraft", "item/lava_bucket"));
                class_1058 lockSprite = (class_1058)atlas.apply(ExtendedDrawers.id("item/lock"));
                class_1058 upgrade2Sprite = (class_1058)atlas.apply(ExtendedDrawers.id("item/t2_upgrade"));
                class_1058 upgrade4Sprite = (class_1058)atlas.apply(ExtendedDrawers.id("item/t4_upgrade"));
                renderer.renderSlot(ItemVariant.of((class_1935)class_1802.field_20412), String.valueOf((Object)128L), false, false, List.of(lockSprite), matrices, (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, 0, playerPos, null);
                matrices.method_22904(0.75, 0.25, 0.0);
                renderer.renderSlot(ItemVariant.of((class_1935)class_1802.field_8725), String.valueOf((Object)16L), true, false, List.of(lockSprite), matrices, (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, 0, playerPos, null);
                matrices.method_22904(0.5, 0.0, 0.0);
                renderer.renderSlot(ItemVariant.of((class_1935)class_1802.field_8054), String.valueOf((Object)32L), true, false, List.of(voidingSprite), matrices, (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, 0, playerPos, null);
                matrices.method_22904(-0.5, -0.5, 0.0);
                renderer.renderSlot(ItemVariant.of((class_1935)class_1802.field_8479), String.valueOf((Object)64L), true, false, List.of(lockSprite, voidingSprite, upgrade2Sprite), matrices, (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, 0, playerPos, null);
                matrices.method_22904(0.5, 0.0, 0.0);
                renderer.renderSlot(ItemVariant.of((class_1935)class_1802.field_8601), String.valueOf((Object)128L), true, false, List.of(upgrade4Sprite), matrices, (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, 0, playerPos, null);
                matrices.method_22904(0.75, 0.5, 0.0);
                renderer.renderIcons(List.of(lockSprite, voidingSprite, upgrade4Sprite), true, 0xF000F0, class_4608.field_21444, matrices, (class_4597)context.method_51450());
                renderer.renderSlot(ItemVariant.of((class_1935)class_1802.field_8620), String.valueOf((Object)9L), true, false, List.of(), matrices, (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, 0, playerPos, null);
                matrices.method_22904(0.25, -0.5, 0.0);
                renderer.renderSlot(ItemVariant.of((class_1935)class_1802.field_8675), String.valueOf((Object)81L), true, false, List.of(), matrices, (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, 0, playerPos, null);
                matrices.method_22904(-0.5, 0.0, 0.0);
                renderer.renderSlot(ItemVariant.of((class_1935)class_1802.field_8773), String.valueOf((Object)1L), true, false, List.of(), matrices, (class_4597)context.method_51450(), 0xF000F0, class_4608.field_21444, 0, playerPos, null);
                matrices.method_22909();
            }
            return size;
        }

        public void close() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record IconRenderer(class_2960 id) implements ImageRenderer
    {
        public int render(class_332 graphics, int x, int y, int renderWidth, float tickDelta) {
            Function blockAtlas = class_310.method_1551().method_1549(class_1723.field_21668);
            class_1058 sprite = (class_1058)blockAtlas.apply(this.id);
            graphics.method_25298(x + renderWidth / 3, y, 0, renderWidth / 3, renderWidth / 3, sprite);
            return renderWidth / 3;
        }

        public void close() {
        }
    }
}

