/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.CompactingDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.network.node.CompactingDrawerBlockNode;
import io.github.mattidragon.extendeddrawers.network.node.DrawerNetworkBlockNode;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.storage.CompactingDrawerStorage;
import io.github.mattidragon.extendeddrawers.storage.ModifierAccess;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CompactingDrawerBlock
extends StorageDrawerBlock<CompactingDrawerBlockEntity> {
    public CompactingDrawerBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        class_2487 nbt = class_1747.method_38072((class_1799)stack);
        if (nbt == null || !(world instanceof class_1937)) {
            return;
        }
        class_1937 realWorld = (class_1937)world;
        class_2487 storageNbt = nbt.method_10562("storage");
        if (ExtendedDrawers.SHIFT_ACCESS.isShiftPressed()) {
            Object object = class_7923.field_41178.method_10223(class_2960.method_12829((String)storageNbt.method_10558("upgrade")));
            if (object instanceof UpgradeItem) {
                UpgradeItem upgrade = (UpgradeItem)((Object)object);
                tooltip.add((class_2561)upgrade.method_7848().method_27661().method_27692(class_124.field_1075));
            }
            class_5250 modifierText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"V").method_27692(storageNbt.method_10577("voiding") ? class_124.field_1068 : class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"L").method_27692(storageNbt.method_10577("locked") ? class_124.field_1068 : class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"H").method_27692(storageNbt.method_10577("hidden") ? class_124.field_1068 : class_124.field_1063));
            if (storageNbt.method_10577("duping")) {
                modifierText.method_10852((class_2561)class_2561.method_43470((String)"D").method_27692(class_124.field_1068));
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.extended_drawers.modifiers", (Object[])new Object[]{modifierText}).method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extended_drawers.shift_for_modifiers").method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43473());
        CompactingDrawerBlockEntity drawer = new CompactingDrawerBlockEntity(class_2338.field_10980, ModBlocks.COMPACTING_DRAWER.method_9564());
        drawer.method_31662(realWorld);
        drawer.method_11014(nbt);
        CompactingDrawerStorage storage = drawer.storage;
        List<ResourceAmount> list = Arrays.stream(storage.getActiveSlots()).map(slot -> new ResourceAmount((Object)slot.getResource(), slot.getTrueAmount())).filter(resource -> !((ItemVariant)resource.resource()).isBlank()).toList();
        if (list.isEmpty()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.extended_drawers.drawer_contents").method_27692(class_124.field_1080));
        for (ResourceAmount slot2 : list) {
            tooltip.add((class_2561)class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(slot2.amount()))).method_27693(" ").method_10852(((ItemVariant)slot2.resource()).toStack().method_7964()).method_27692(class_124.field_1080));
        }
    }

    @Override
    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        CompactingDrawerBlockEntity drawer;
        if (!state.method_27852(newState.method_26204()) && (drawer = (CompactingDrawerBlockEntity)((Object)this.getBlockEntity(world, pos))) != null && ((ConfigData)ExtendedDrawers.CONFIG.get()).misc().drawersDropContentsOnBreak()) {
            CompactingDrawerStorage.Slot[] slots = drawer.storage.getSlots();
            long amount = drawer.storage.getTrueAmount();
            for (int i = slots.length - 1; i >= 0; --i) {
                CompactingDrawerStorage.Slot slot = slots[i];
                if (slot.isBlocked()) continue;
                long toDrop = amount / slot.getCompression();
                ItemUtils.offerOrDropStacks(world, pos, null, null, slot.getResource(), toDrop);
                amount -= toDrop * slot.getCompression();
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    @Override
    protected class_2591<CompactingDrawerBlockEntity> getType() {
        return ModBlocks.COMPACTING_DRAWER_BLOCK_ENTITY;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        CompactingDrawerBlockEntity drawer = (CompactingDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return 0;
        }
        return StorageUtil.calculateComparatorOutput((Storage)drawer.storage);
    }

    @Override
    protected ModifierAccess getModifierAccess(CompactingDrawerBlockEntity drawer, class_241 facePos) {
        return drawer.storage;
    }

    @Override
    public int getSlotIndex(CompactingDrawerBlockEntity drawer, class_241 facePos) {
        int slotCount = drawer.storage.getActiveSlotCount();
        int topSlot = switch (slotCount) {
            case 1 -> 0;
            case 2 -> 0;
            case 3 -> 1;
            default -> throw new IllegalStateException("Illegal slot count");
        };
        int leftSlot = switch (slotCount) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 0;
            default -> throw new IllegalStateException("Illegal slot count");
        };
        int rightSlot = switch (slotCount) {
            case 1 -> 2;
            case 2 -> 1;
            case 3 -> 2;
            default -> throw new IllegalStateException("Illegal slot count");
        };
        if (facePos.field_1342 < 0.5f) {
            return topSlot;
        }
        if (facePos.field_1343 < 0.5f) {
            return leftSlot;
        }
        return rightSlot;
    }

    public CompactingDrawerStorage.Slot getSlot(CompactingDrawerBlockEntity drawer, int slot) {
        return drawer.storage.getSlot(slot);
    }

    @Override
    public DrawerNetworkBlockNode getNode() {
        return CompactingDrawerBlockNode.INSTANCE;
    }
}

