/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import io.github.mattidragon.extendeddrawers.block.base.DrawerInteractionHandler;
import io.github.mattidragon.extendeddrawers.block.base.NetworkBlock;
import io.github.mattidragon.extendeddrawers.block.entity.ShadowDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.misc.DrawerInteractionStatusManager;
import io.github.mattidragon.extendeddrawers.network.NetworkRegistry;
import io.github.mattidragon.extendeddrawers.network.cache.NetworkStorageCache;
import io.github.mattidragon.extendeddrawers.network.node.AccessPointBlockNode;
import io.github.mattidragon.extendeddrawers.network.node.DrawerNetworkBlockNode;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class AccessPointBlock
extends NetworkBlock
implements DrawerInteractionHandler {
    public AccessPointBlock(class_4970.class_2251 settings) {
        super(settings);
        ItemStorage.SIDED.registerForBlocks((world, pos, state, entity, dir) -> {
            CombinedStorage<ItemVariant, DrawerStorage> combinedStorage;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                combinedStorage = NetworkStorageCache.get(serverWorld, pos);
            } else {
                combinedStorage = Storage.empty();
            }
            return combinedStorage;
        }, new class_2248[]{this});
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            return StorageUtil.calculateComparatorOutput(NetworkStorageCache.get(serverWorld, pos));
        }
        return 0;
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!player.method_7294()) {
            return class_1269.field_5811;
        }
        if (!(world instanceof class_3218)) {
            return class_1269.field_33562;
        }
        class_3218 serverWorld = (class_3218)world;
        CombinedStorage<ItemVariant, DrawerStorage> storage = NetworkStorageCache.get(serverWorld, pos);
        try (Transaction t = Transaction.openOuter();){
            int inserted;
            class_1799 playerStack = player.method_5998(hand);
            boolean isDoubleClick = DrawerInteractionStatusManager.getAndResetInsertStatus(player, pos, 0);
            if (isDoubleClick) {
                inserted = (int)StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player), storage, itemVariant -> {
                    for (StorageView view : storage) {
                        if (!((ItemVariant)view.getResource()).equals(itemVariant)) continue;
                        return true;
                    }
                    return false;
                }, (long)Long.MAX_VALUE, (TransactionContext)t);
            } else {
                if (playerStack.method_7960()) {
                    class_1269 class_12692 = class_1269.field_5811;
                    return class_12692;
                }
                inserted = (int)storage.insert((Object)ItemVariant.of((class_1799)playerStack), (long)playerStack.method_7947(), (TransactionContext)t);
                playerStack.method_7934(inserted);
            }
            if (inserted == 0) {
                class_1269 class_12693 = class_1269.field_33562;
                return class_12693;
            }
            t.commit();
            class_1269 class_12694 = class_1269.field_5812;
            return class_12694;
        }
    }

    @Override
    public class_1269 toggleLock(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        if (!(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 serverWorld = (class_3218)world;
        List storages = NetworkStorageCache.get((class_3218)serverWorld, (class_2338)pos).parts;
        boolean newState = storages.stream().map(DrawerStorage::isLocked).mapToInt(value -> value != false ? 1 : -1).sum() <= 0;
        storages.forEach(storage -> storage.setLocked(newState));
        return storages.isEmpty() ? class_1269.field_5811 : class_1269.field_5812;
    }

    @Override
    public class_1269 toggleVoid(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        if (!(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 serverWorld = (class_3218)world;
        List storages = NetworkStorageCache.get((class_3218)serverWorld, (class_2338)pos).parts;
        boolean newState = storages.stream().map(DrawerStorage::isVoiding).mapToInt(value -> value != false ? 1 : -1).sum() <= 0;
        storages.forEach(storage -> storage.setVoiding(newState));
        return storages.isEmpty() ? class_1269.field_5811 : class_1269.field_5812;
    }

    @Override
    public class_1269 toggleDuping(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        if (!(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 serverWorld = (class_3218)world;
        List storages = NetworkStorageCache.get((class_3218)serverWorld, (class_2338)pos).parts;
        boolean newState = storages.stream().map(DrawerStorage::isDuping).mapToInt(value -> value != false ? 1 : -1).sum() <= 0;
        storages.forEach(storage -> storage.setDuping(newState));
        return storages.isEmpty() ? class_1269.field_5811 : class_1269.field_5812;
    }

    @Override
    public class_1269 toggleHide(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        if (!(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 serverWorld = (class_3218)world;
        List storages = NetworkStorageCache.get((class_3218)serverWorld, (class_2338)pos).parts;
        List<ShadowDrawerBlockEntity> shadowDrawers = NetworkRegistry.UNIVERSE.getServerGraphWorld(serverWorld).getLoadedGraphsAt(pos).flatMap(BlockGraph::getNodes).map(NodeHolder::getBlockPos).map(arg_0 -> ((class_3218)serverWorld).method_8321(arg_0)).filter(ShadowDrawerBlockEntity.class::isInstance).map(ShadowDrawerBlockEntity.class::cast).toList();
        int sum = storages.stream().map(DrawerStorage::isHidden).mapToInt(value -> value != false ? 1 : -1).sum();
        boolean newState = (sum += shadowDrawers.stream().map(ShadowDrawerBlockEntity::isHidden).mapToInt(value -> value != false ? 1 : -1).sum()) <= 0;
        storages.forEach(storage -> storage.setHidden(newState));
        shadowDrawers.forEach(drawer -> drawer.setHidden(newState));
        return storages.size() + shadowDrawers.size() == 0 ? class_1269.field_5811 : class_1269.field_5812;
    }

    @Override
    public DrawerNetworkBlockNode getNode() {
        return AccessPointBlockNode.INSTANCE;
    }
}

