/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Collections;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.JsonHelper;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;

public class EffectProviderRecipe
implements class_1860<class_8566> {
    private final class_2960 id;
    @Nullable
    private final class_1291 effect;
    private final class_2371<class_1856> providers;

    public EffectProviderRecipe(class_2960 id, @Nullable class_1291 effect, class_2371<class_1856> providers) {
        this.id = id;
        this.effect = effect;
        this.providers = providers;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public String method_8112() {
        return "effect_provider";
    }

    public class_2371<class_1856> method_8117() {
        return this.providers;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean matches(class_8566 inv, class_1937 worldIn) {
        return false;
    }

    public class_1799 assemble(class_8566 container, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return Jeed.getEffectProviderSerializer();
    }

    public class_3956<?> method_17716() {
        return Jeed.getEffectProviderType();
    }

    public Collection<class_1291> getEffects() {
        return this.effect == null ? class_7923.field_41174.method_10220().toList() : Collections.singletonList(this.effect);
    }

    public static class Serializer
    implements class_1865<EffectProviderRecipe> {
        public EffectProviderRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String effectID;
            class_2371<class_1856> providers = JsonHelper.readIngredients(class_3518.method_15261((JsonObject)json, (String)"providers"));
            if (providers.isEmpty()) {
                throw new JsonParseException("No effect providers for recipe");
            }
            JsonElement v = json.get("effect");
            if (v == null) {
                throw new JsonParseException("Missing effect for recipe");
            }
            if (v instanceof JsonObject) {
                JsonObject jo = (JsonObject)v;
                effectID = class_3518.method_15265((JsonObject)jo, (String)"id");
            } else {
                effectID = v.getAsString();
            }
            class_1291 effect = null;
            if (effectID != null && !effectID.equals("all") && !effectID.equals("minecraft:all")) {
                effect = JsonHelper.getEffect(new class_2960(effectID));
            }
            return new EffectProviderRecipe(recipeId, effect, providers);
        }

        @Nullable
        public EffectProviderRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            int i = buffer.method_10816();
            class_2371 providers = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            providers.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            class_2960 id = buffer.method_10810();
            class_1291 effect = null;
            if (!id.method_12832().equals("all")) {
                effect = JsonHelper.getEffect(id);
            }
            return new EffectProviderRecipe(recipeId, effect, (class_2371<class_1856>)providers);
        }

        public void toNetwork(class_2540 buffer, EffectProviderRecipe recipe) {
            buffer.method_10804(recipe.providers.size());
            for (class_1856 result : recipe.providers) {
                result.method_8088(buffer);
            }
            class_2960 res = recipe.effect == null ? new class_2960("all") : class_7923.field_41174.method_10221((Object)recipe.effect);
            buffer.method_10812(res);
        }
    }
}

