/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.brain.task.rascal;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.RascalEntity;
import com.faboslav.friendsandfoes.entity.ai.brain.RascalBrain;
import com.faboslav.friendsandfoes.entity.pose.RascalEntityPose;
import com.faboslav.friendsandfoes.init.FriendsAndFoesCriteria;
import com.faboslav.friendsandfoes.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.mixin.BundleItemAccessor;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_5138;
import net.minecraft.class_52;
import net.minecraft.class_60;
import net.minecraft.class_7045;
import net.minecraft.class_8567;

public final class RascalWaitForPlayerTask
extends class_4097<RascalEntity> {
    private static final int NOD_DURATION = 90;
    public static final float NOD_RANGE = 4.0f;
    private int nodTicks;
    private class_1309 nearestTarget;

    public RascalWaitForPlayerTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_22354, (Object)class_4141.field_18458, (Object)class_4140.field_18447, (Object)class_4141.field_18456, FriendsAndFoesMemoryModuleTypes.RASCAL_NOD_COOLDOWN.get(), (Object)class_4141.field_18457), 90);
    }

    protected boolean shouldRun(class_3218 world, RascalEntity rascal) {
        if (rascal.method_16914()) {
            return false;
        }
        class_1309 nearestTarget = rascal.method_18868().method_18904(class_4140.field_22354).orElse(null);
        if (nearestTarget == null) {
            nearestTarget = rascal.method_18868().method_18904(class_4140.field_18447).orElse(null);
        }
        if (nearestTarget == null || rascal.method_5739((class_1297)nearestTarget) > 4.0f || !nearestTarget.method_5805() || nearestTarget instanceof class_1657 && (nearestTarget.method_7325() || ((class_1657)nearestTarget).method_7337())) {
            return false;
        }
        this.nearestTarget = nearestTarget;
        return true;
    }

    protected void run(class_3218 world, RascalEntity rascal, long time) {
        rascal.method_18868().method_18875(class_4140.field_18445);
        rascal.method_5942().method_6344(0.0);
        rascal.method_5942().method_6340();
        rascal.method_5942().method_6360();
        rascal.method_5962().method_6240();
        rascal.method_6125(0.0f);
        rascal.field_6039 = 0.0f;
        rascal.field_5973 = 0.0f;
        rascal.field_6212 = 0.0f;
        rascal.field_6227 = 0.0f;
        class_4215.method_19554((class_1309)rascal, (class_1309)this.nearestTarget);
        rascal.method_5988().method_35111((class_1297)this.nearestTarget);
        rascal.method_5988().method_6231();
        this.nodTicks = 0;
        rascal.addToCaughtCount();
        rascal.disableAmbientSounds();
    }

    protected boolean shouldKeepRunning(class_3218 world, RascalEntity rascal, long time) {
        return this.nodTicks <= 90;
    }

    protected void keepRunning(class_3218 world, RascalEntity rascal, long time) {
        if (this.nodTicks == 20) {
            rascal.startNodAnimation();
            rascal.method_5988().method_35111((class_1297)this.nearestTarget);
        }
        if (this.nodTicks == 40 && rascal.shouldGiveReward()) {
            rascal.startGiveRewardAnimation();
        }
        if (this.nodTicks == 62 && rascal.shouldGiveReward()) {
            class_243 targetPos = this.nearestTarget.method_19538().method_1031(0.0, 1.0, 0.0);
            class_60 lootManager = world.method_8503().method_3857();
            if (lootManager != null) {
                class_52 rascalGoodItemsLootTable = lootManager.getLootTable(FriendsAndFoes.makeID("rewards/rascal_good_reward"));
                class_8567 lootContextParameterSet = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)targetPos).method_51874(class_181.field_1226, (Object)this.nearestTarget).method_51875(class_173.field_16235);
                ObjectArrayList rascalGoodRewards = rascalGoodItemsLootTable.method_51878(lootContextParameterSet);
                for (class_1799 rascalReward : rascalGoodRewards) {
                    class_1799 bundleItemStack = class_1802.field_27023.method_7854();
                    BundleItemAccessor.callAddToBundle(bundleItemStack, rascalReward);
                    class_4215.method_19949((class_1309)rascal, (class_1799)bundleItemStack, (class_243)this.nearestTarget.method_19538().method_1031(0.0, 1.0, 0.0));
                }
            }
            FriendsAndFoesCriteria.COMPLETE_HIDE_AND_SEEK_GAME.trigger((class_3222)this.nearestTarget, rascal);
        }
        ++this.nodTicks;
    }

    protected void finishRunning(class_3218 world, RascalEntity rascal, long time) {
        if (rascal.method_16914()) {
            RascalBrain.setNodCooldown(rascal);
            return;
        }
        rascal.spawnCloudParticles();
        rascal.playDisappearSound();
        if (rascal.shouldGiveReward()) {
            rascal.method_31472();
            return;
        }
        rascal.setPose(RascalEntityPose.IDLE);
        rascal.method_6092(new class_1293(class_1294.field_5905, 200));
        this.tryToTeleport(world, rascal);
        RascalBrain.setNodCooldown(rascal);
        rascal.enableAmbientSounds();
    }

    private void tryToTeleport(class_3218 world, RascalEntity rascal) {
        class_5138 structureAccessor = world.method_27056();
        for (int i = 0; i < 64; ++i) {
            boolean teleportResult;
            double z;
            double y;
            double x = rascal.method_23317() + (rascal.method_6051().method_43058() - 0.5) * 16.0;
            if (!structureAccessor.method_41413(new class_2338((int)x, (int)(y = class_3532.method_15350((double)(rascal.method_23318() + (double)(rascal.method_6051().method_43048(8) - 4)), (double)world.method_31607(), (double)(world.method_31607() + world.method_32819() - 1))), (int)(z = rascal.method_23321() + (rascal.method_6051().method_43058() - 0.5) * 16.0)), class_7045.field_37046).method_16657()) continue;
            if (rascal.method_5765()) {
                rascal.method_5848();
            }
            if (!(teleportResult = rascal.method_6082(x, y, z, false)) || !((double)rascal.method_5739((class_1297)this.nearestTarget) > 10.0)) continue;
            return;
        }
    }
}

