/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jeresources.api.drop.PlantDrop;
import jeresources.util.MapKeys;
import jeresources.util.PlantHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2261;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class PlantEntry {
    private class_2261 plant;
    private class_1799 plantStack;
    private Map<String, PlantDrop> drops = new LinkedHashMap<String, PlantDrop>();
    private int totalWeight = 0;
    private class_2680 soil = null;
    private class_2680 plantState = null;
    private class_2769<?> ageProperty = null;

    public static PlantEntry registerGrass() {
        List<PlantDrop> seeds = PlantHelper.getSeeds();
        PlantEntry grass = new PlantEntry(new class_1799((class_1935)class_2246.field_10214, 1), seeds.toArray(new PlantDrop[seeds.size()]));
        grass.totalWeight *= 8;
        return grass;
    }

    public class_2680 getSoil() {
        return this.soil;
    }

    public class_2680 getPlantState() {
        return this.plantState;
    }

    public class_2769<?> getAgeProperty() {
        return this.ageProperty;
    }

    public void setSoil(class_2680 soil) {
        this.soil = soil;
    }

    public void setPlantState(class_2680 plantState) {
        this.plantState = plantState;
    }

    public void setAgeProperty(class_2769<?> ageProperty) {
        this.ageProperty = ageProperty;
    }

    public PlantEntry(class_1799 itemStack, class_2261 plant, PlantDrop ... drops) {
        this.plantStack = itemStack;
        this.plant = plant;
        for (PlantDrop entry : drops) {
            this.totalWeight += entry.getWeight();
            String key = MapKeys.getKey(entry.getDrop());
            if (key == null) continue;
            this.drops.put(key, entry);
        }
    }

    public PlantEntry(class_1799 itemStack, PlantDrop ... drops) {
        this(itemStack, (class_2261)null, drops);
    }

    public <T extends class_2261> PlantEntry(T plant, PlantDrop ... drops) {
        this(new class_1799(plant), plant, drops);
    }

    public void add(PlantDrop entry) {
        String key = MapKeys.getKey(entry.getDrop());
        if (!this.drops.containsKey(key)) {
            return;
        }
        this.drops.put(key, new PlantDrop(entry.getDrop(), this.totalWeight + entry.getWeight()));
    }

    public class_2261 getPlant() {
        return this.plant;
    }

    public class_1799 getPlantItemStack() {
        return this.plantStack;
    }

    public List<PlantDrop> getDrops() {
        return new ArrayList<PlantDrop>(this.drops.values());
    }

    public List<class_1799> getLootDropStacks() {
        return this.getDrops().stream().map(PlantDrop::getDrop).collect(Collectors.toList());
    }

    public PlantDrop getDrop(class_1799 itemStack) {
        return this.drops.get(MapKeys.getKey(itemStack));
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }
}

