/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.mixins.EntityPredicateAccessor;
import fzzyhmstrs.emi_loot.parser.DistancePredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityEffectPredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityEquipmentPredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityFlagsPredicateParser;
import fzzyhmstrs.emi_loot.parser.EntityTypePredicateParser;
import fzzyhmstrs.emi_loot.parser.LocationPredicateParser;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.NbtPredicateParser;
import fzzyhmstrs.emi_loot.parser.TypeSpecificPredicateParser;
import fzzyhmstrs.emi_loot.util.LText;
import net.minecraft.class_2025;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2090;
import net.minecraft.class_2102;
import net.minecraft.class_2105;
import net.minecraft.class_2561;
import net.minecraft.class_3735;
import net.minecraft.class_7376;

public class EntityPredicateParser {
    public static class_2561 parseEntityPredicate(class_2048 predicate) {
        return LText.translatable("emi_loot.entity_predicate.base", EntityPredicateParser.parseEntityPredicateInternal(predicate).getString());
    }

    private static class_2561 parseEntityPredicateInternal(class_2048 predicate) {
        if (predicate.equals(class_2048.field_9599)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.warn("Entity predicate empty in table: " + LootTableParser.currentTable);
            }
            return LText.empty();
        }
        class_2050 typePredicate = ((EntityPredicateAccessor)predicate).getType();
        if (!typePredicate.equals(class_2050.field_9609)) {
            return EntityTypePredicateParser.parseEntityTypePredicate(typePredicate);
        }
        class_2025 distancePredicate = ((EntityPredicateAccessor)predicate).getDistance();
        if (!distancePredicate.equals(class_2025.field_9553)) {
            return DistancePredicateParser.parseDistancePredicate(distancePredicate);
        }
        class_2090 locationPredicate = ((EntityPredicateAccessor)predicate).getLocation();
        if (!locationPredicate.equals(class_2090.field_9685)) {
            return LocationPredicateParser.parseLocationPredicate(locationPredicate);
        }
        class_2090 steppingOnPredicate = ((EntityPredicateAccessor)predicate).getSteppingOn();
        if (!steppingOnPredicate.equals(class_2090.field_9685)) {
            return LocationPredicateParser.parseLocationPredicate(locationPredicate);
        }
        class_2102 entityEffectPredicate = ((EntityPredicateAccessor)predicate).getEffects();
        if (!entityEffectPredicate.equals(class_2102.field_9709)) {
            return EntityEffectPredicateParser.parseEntityEffectPredicate(entityEffectPredicate);
        }
        class_2105 nbt = ((EntityPredicateAccessor)predicate).getNbt();
        if (!nbt.equals(class_2105.field_9716)) {
            return NbtPredicateParser.parseNbtPredicate(nbt);
        }
        class_2040 entityFlagsPredicate = ((EntityPredicateAccessor)predicate).getFlags();
        if (!entityFlagsPredicate.equals(class_2040.field_9581)) {
            return EntityFlagsPredicateParser.parseEntityFlagsPredicate(entityFlagsPredicate);
        }
        class_3735 entityEquipmentPredicate = ((EntityPredicateAccessor)predicate).getEquipment();
        if (!entityEquipmentPredicate.equals(class_3735.field_16485)) {
            return EntityEquipmentPredicateParser.parseEntityEquipmentPredicate(entityEquipmentPredicate);
        }
        class_7376 typeSpecificPredicate = ((EntityPredicateAccessor)predicate).getTypeSpecific();
        if (!typeSpecificPredicate.equals(class_7376.field_38723)) {
            return TypeSpecificPredicateParser.parseTypeSpecificPredicate(typeSpecificPredicate);
        }
        class_2048 vehicle = ((EntityPredicateAccessor)predicate).getVehicle();
        if (!vehicle.equals(class_2048.field_9599)) {
            return EntityPredicateParser.parseEntityPredicate(vehicle);
        }
        class_2048 passenger = ((EntityPredicateAccessor)predicate).getPassenger();
        if (!passenger.equals(class_2048.field_9599)) {
            return EntityPredicateParser.parseEntityPredicate(passenger);
        }
        class_2048 targetedEntity = ((EntityPredicateAccessor)predicate).getTargetedEntity();
        if (!targetedEntity.equals(class_2048.field_9599)) {
            return EntityPredicateParser.parseEntityPredicate(targetedEntity);
        }
        if (EMILoot.DEBUG) {
            EMILoot.LOGGER.warn("Entity predicate undefined in table: " + LootTableParser.currentTable);
        }
        return LText.translatable("emi_loot.predicate.invalid");
    }
}

