/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.util;

import com.mojang.datafixers.util.Pair;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreDataCapability;
import com.tom.createores.recipe.VeinRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1860;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2818;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6872;
import net.minecraft.class_6880;

public class RandomSpreadGenerator {
    private List<VeinRecipe> recipes = new ArrayList<VeinRecipe>();

    public void loadAll(class_3218 level) {
        this.recipes.addAll(level.method_8433().method_30027(CreateOreExcavation.VEIN_RECIPES.getRecipeType()));
        this.recipes.sort(Comparator.comparingInt(VeinRecipe::getNegGenerationPriority).thenComparing(VeinRecipe::method_8114));
    }

    public VeinRecipe pick(class_2818 chunk) {
        int x = chunk.method_12004().field_9181;
        int z = chunk.method_12004().field_9180;
        int minY = class_5742.method_33100((int)chunk.method_31607());
        int maxY = minY + class_5742.method_33100((int)chunk.method_31605()) - 1;
        class_3218 level = (class_3218)chunk.method_12200();
        for (VeinRecipe recipe : this.recipes) {
            class_1923 chunkpos = recipe.getPlacement().method_40169(level.method_8412(), x, z);
            if (chunkpos.field_9181 != x || chunkpos.field_9180 != z) continue;
            class_2919 rng = new class_2919((class_5819)new class_5820(0L));
            rng.method_12663(level.method_8412(), x, z);
            class_6880 biome = chunk.method_16359(rng.method_43048(4), minY + rng.method_43048(maxY), rng.method_43048(4));
            if (!recipe.canGenerate(level, (class_6880<class_1959>)biome)) continue;
            return recipe;
        }
        return null;
    }

    private VeinRecipe pick(class_3218 level, class_1923 chunk, VeinRecipe last) {
        int minY = class_5742.method_33100((int)level.method_31607());
        int maxY = minY + class_5742.method_33100((int)level.method_31605()) - 1;
        for (VeinRecipe recipe : this.recipes) {
            class_1923 chunkpos = recipe.getPlacement().method_40169(level.method_8412(), chunk.field_9181, chunk.field_9180);
            if (chunkpos.field_9181 == chunk.field_9181 && chunkpos.field_9180 == chunk.field_9180) {
                class_2919 rng = new class_2919((class_5819)new class_5820(0L));
                rng.method_12663(level.method_8412(), chunk.field_9181, chunk.field_9180);
                class_2338 pos = new class_2338(class_5742.method_33101((int)rng.method_43048(4)), class_5742.method_33101((int)(minY + rng.method_43048(maxY))), class_5742.method_33101((int)rng.method_43048(4))).method_10081((class_2382)chunk.method_8323());
                if (level.method_42108(b -> recipe.canGenerate(level, (class_6880<class_1959>)b), pos, 1, 1, 1) != null) {
                    return recipe;
                }
            }
            if (recipe != last) continue;
            break;
        }
        return null;
    }

    public class_2338 locate(class_2960 id, class_2338 pPos, class_3218 level, int radius) {
        class_1860 recipe = level.method_8433().method_8130(id).orElse(null);
        if (recipe instanceof VeinRecipe) {
            VeinRecipe r = (VeinRecipe)recipe;
            int i = class_4076.method_18675((int)pPos.method_10263());
            int j = class_4076.method_18675((int)pPos.method_10260());
            for (int k = 0; k <= radius; ++k) {
                class_2338 pos = this.getNearestGenerated(level, i, j, k, level.method_8412(), r);
                if (pos == null) continue;
                return pos;
            }
        }
        return null;
    }

    public Pair<class_2338, VeinRecipe> locate(class_2338 pPos, class_3218 level, int radius) {
        int i = class_4076.method_18675((int)pPos.method_10263());
        int j = class_4076.method_18675((int)pPos.method_10260());
        for (int k = 0; k <= radius; ++k) {
            Pair found = null;
            float dist = Float.MAX_VALUE;
            for (int j2 = 0; j2 < this.recipes.size(); ++j2) {
                OreDataCapability.OreData data;
                float d;
                VeinRecipe r = this.recipes.get(j2);
                class_2338 pos = this.getNearestGenerated(level, i, j, k, level.method_8412(), r);
                if (pos == null || !((d = RandomSpreadGenerator.distance2d(pos, pPos)) < dist) || level.method_8477(pos) && (r = (data = OreDataCapability.getData(level.method_8500(pos))).getRecipe(level.method_8433())) == null) continue;
                found = Pair.of((Object)pos, (Object)r);
                dist = d;
            }
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private class_2338 getNearestGenerated(class_3218 pLevel, int pX, int pY, int pZ, long pSeed, VeinRecipe recipe) {
        class_6872 pSpreadPlacement = recipe.getPlacement();
        int i = pSpreadPlacement.method_41632();
        for (int j = -pZ; j <= pZ; ++j) {
            boolean flag = j == -pZ || j == pZ;
            for (int k = -pZ; k <= pZ; ++k) {
                int i1;
                int l;
                class_1923 chunkpos;
                VeinRecipe picked;
                boolean flag1;
                boolean bl = flag1 = k == -pZ || k == pZ;
                if (!flag && !flag1 || (picked = this.pick(pLevel, chunkpos = pSpreadPlacement.method_40169(pSeed, l = pX + i * j, i1 = pY + i * k), recipe)) != recipe) continue;
                return chunkpos.method_33943(0);
            }
        }
        return null;
    }

    public static float distance2d(class_2338 a, class_2338 b) {
        int i = b.method_10263() - a.method_10263();
        int j = b.method_10260() - a.method_10260();
        return class_3532.method_15355((float)(i * i + j * j));
    }
}

