/*
 * Decompiled with CFR 0.152.
 */
package io.github.uhq_games.regions_unexplored.registry;

import io.github.uhq_games.regions_unexplored.config.RegionsUnexploredConfig;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.RuBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.AquaticBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.AridBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.CaveBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.CoastalBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.ForestBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.FrozenBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.MountainBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.NetherBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.PlainsBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.TaigaBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.builder.WetBiomes;
import io.github.uhq_games.regions_unexplored.data.worldgen.biome.surface.RuSurfaceRuleData;
import io.github.uhq_games.regions_unexplored.world.level.region.RuRegionNether;
import io.github.uhq_games.regions_unexplored.world.level.region.RuRegionPrimary;
import io.github.uhq_games.regions_unexplored.world.level.region.RuRegionSecondary;
import net.minecraft.class_1959;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_6686;
import net.minecraft.class_6796;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import terrablender.api.Region;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

public class BiomeRegistry {
    public static void addBiomes() {
        BiomeRegistry.registerVillagerTypes();
    }

    public static void setupTerrablender() {
        Regions.register((Region)new RuRegionPrimary(RegionsUnexploredConfig.REGION_PRIMARY_WEIGHT));
        Regions.register((Region)new RuRegionSecondary(RegionsUnexploredConfig.REGION_SECONDARY_WEIGHT));
        Regions.register((Region)new RuRegionNether(RegionsUnexploredConfig.REGION_NETHER_WEIGHT));
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)"regions_unexplored", (class_6686.class_6708)RuSurfaceRuleData.nether());
        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)"regions_unexplored", (class_6686.class_6708)RuSurfaceRuleData.overworld());
    }

    public static void bootstrap(class_7891<class_1959> context) {
        class_7871 carversGetter = context.method_46799(class_7924.field_41238);
        class_7871 featuresGetter = context.method_46799(class_7924.field_41245);
        BiomeRegistry.register(context, RuBiomes.AUTUMNAL_MAPLE_FOREST, ForestBiomes.autumnalMapleForest((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BAMBOO_FOREST, ForestBiomes.bambooForest((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MAGNOLIA_WOODLAND, ForestBiomes.magnoliaHighlands((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.DECIDUOUS_FOREST, ForestBiomes.deciduousForest((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MAPLE_FOREST, ForestBiomes.mapleForest((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MAUVE_HILLS, ForestBiomes.mauveHills((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ORCHARD, ForestBiomes.orchard((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SILVER_BIRCH_FOREST, ForestBiomes.silverBirchForest((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.TEMPERATE_GROVE, ForestBiomes.temperateGrove((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.WILLOW_FOREST, ForestBiomes.willowForest((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BLACKWOOD_TAIGA, TaigaBiomes.blackwoodTaiga((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BOREAL_TAIGA, TaigaBiomes.borealTaiga((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GOLDEN_BOREAL_TAIGA, TaigaBiomes.goldenBorealTaiga((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.PINE_TAIGA, TaigaBiomes.pineTaiga((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.REDWOODS, TaigaBiomes.redwoods((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SPARSE_REDWOODS, TaigaBiomes.sparseRedwoods((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BARLEY_FIELDS, PlainsBiomes.barleyFields((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FLOWER_FIELDS, PlainsBiomes.flowerFields((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GRASSLAND, PlainsBiomes.grassland((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.CLOVER_PLAINS, PlainsBiomes.lupinePlains((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ROCKY_MEADOW, PlainsBiomes.rockyMeadow((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.POPPY_FIELDS, PlainsBiomes.poppyFields((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.PRAIRIE, PlainsBiomes.prairie((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.PUMPKIN_FIELDS, PlainsBiomes.pumpkinFields((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SHRUBLAND, PlainsBiomes.shrubland((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BAYOU, WetBiomes.bayou((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.EUCALYPTUS_FOREST, WetBiomes.eucalyptusForest((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FEN, WetBiomes.fen((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MARSH, WetBiomes.marsh((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FUNGAL_FEN, WetBiomes.fungalFen((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.OLD_GROWTH_BAYOU, WetBiomes.oldGrowthBayou((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SPARSE_RAINFOREST, WetBiomes.rainforest((class_7871<class_6796>)featuresGetter, carversGetter, false));
        BiomeRegistry.register(context, RuBiomes.RAINFOREST, WetBiomes.rainforest((class_7871<class_6796>)featuresGetter, carversGetter, true));
        BiomeRegistry.register(context, RuBiomes.BAOBAB_SAVANNA, AridBiomes.baobabSavanna((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.DRY_BUSHLAND, AridBiomes.dryBushland((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.JOSHUA_DESERT, AridBiomes.joshuaDesert((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.OUTBACK, AridBiomes.outback((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SAGUARO_DESERT, AridBiomes.saguaroDesert((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.STEPPE, AridBiomes.steppe((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ARID_MOUNTAINS, MountainBiomes.aridMountains((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.HIGHLAND_FIELDS, MountainBiomes.highlandFields((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MOUNTAINS, MountainBiomes.mountainsAndSlopes((class_7871<class_6796>)featuresGetter, carversGetter, false));
        BiomeRegistry.register(context, RuBiomes.PINE_SLOPES, MountainBiomes.mountainsAndSlopes((class_7871<class_6796>)featuresGetter, carversGetter, true));
        BiomeRegistry.register(context, RuBiomes.TOWERING_CLIFFS, MountainBiomes.toweringCliffs((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.CHALK_CLIFFS, CoastalBiomes.chalkCliffs((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GRASSY_BEACH, CoastalBiomes.grassyBeach((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GRAVEL_BEACH, CoastalBiomes.gravelBeach((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ALPHA_GROVE, AquaticBiomes.alphaGrove((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.COLD_RIVER, AquaticBiomes.coldRiver((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.HYACINTH_DEEPS, AquaticBiomes.hyacinthDeeps((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MUDDY_RIVER, AquaticBiomes.muddyRiver((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ROCKY_REEF, AquaticBiomes.rockyReef((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ASHEN_WOODLAND, AquaticBiomes.ashenWoodland((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.TROPICAL_RIVER, AquaticBiomes.tropicalRiver((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.TROPICS, AquaticBiomes.tropics((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.COLD_BOREAL_TAIGA, FrozenBiomes.coldBorealTaiga((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.COLD_DECIDUOUS_FOREST, FrozenBiomes.coldDeciduousForest((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FROZEN_PINE_TAIGA, FrozenBiomes.frozenPineTaiga((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.FROZEN_TUNDRA, FrozenBiomes.frozenTundra((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ICY_HEIGHTS, FrozenBiomes.icyHeights((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SPIRES, FrozenBiomes.spires((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.ANCIENT_DELTA, CaveBiomes.ancientDelta((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BIOSHROOM_CAVES, CaveBiomes.bioshroomCaves((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.PRISMACHASM, CaveBiomes.prismachasm((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.REDSTONE_CAVES, CaveBiomes.redstoneCaves((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.SCORCHING_CAVES, CaveBiomes.scorchingCaves((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.BLACKSTONE_BASIN, NetherBiomes.blackstoneBasin((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.INFERNAL_HOLT, NetherBiomes.infernalHolt((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.GLISTERING_MEADOW, NetherBiomes.glisteringMeadow((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.MYCOTOXIC_UNDERGROWTH, NetherBiomes.mycotoxicUndergrowth((class_7871<class_6796>)featuresGetter, carversGetter));
        BiomeRegistry.register(context, RuBiomes.REDSTONE_ABYSS, NetherBiomes.redstoneAbyss((class_7871<class_6796>)featuresGetter, carversGetter));
    }

    private static void registerVillagerTypes() {
        BiomeRegistry.registerVillagers(RuBiomes.AUTUMNAL_MAPLE_FOREST, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.BAMBOO_FOREST, class_3854.field_17072);
        BiomeRegistry.registerVillagers(RuBiomes.MAGNOLIA_WOODLAND, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.DECIDUOUS_FOREST, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.MAPLE_FOREST, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.MAUVE_HILLS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.ORCHARD, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.SILVER_BIRCH_FOREST, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.TEMPERATE_GROVE, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.WILLOW_FOREST, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.BLACKWOOD_TAIGA, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.BOREAL_TAIGA, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.GOLDEN_BOREAL_TAIGA, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.PINE_TAIGA, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.REDWOODS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.SPARSE_REDWOODS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.BARLEY_FIELDS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.FLOWER_FIELDS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.GRASSLAND, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.CLOVER_PLAINS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.ROCKY_MEADOW, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.POPPY_FIELDS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.PRAIRIE, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.PUMPKIN_FIELDS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.SHRUBLAND, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.BAYOU, class_3854.field_17076);
        BiomeRegistry.registerVillagers(RuBiomes.EUCALYPTUS_FOREST, class_3854.field_17072);
        BiomeRegistry.registerVillagers(RuBiomes.FEN, class_3854.field_17076);
        BiomeRegistry.registerVillagers(RuBiomes.MARSH, class_3854.field_17076);
        BiomeRegistry.registerVillagers(RuBiomes.FUNGAL_FEN, class_3854.field_17076);
        BiomeRegistry.registerVillagers(RuBiomes.OLD_GROWTH_BAYOU, class_3854.field_17076);
        BiomeRegistry.registerVillagers(RuBiomes.SPARSE_RAINFOREST, class_3854.field_17072);
        BiomeRegistry.registerVillagers(RuBiomes.RAINFOREST, class_3854.field_17072);
        BiomeRegistry.registerVillagers(RuBiomes.BAOBAB_SAVANNA, class_3854.field_17074);
        BiomeRegistry.registerVillagers(RuBiomes.DRY_BUSHLAND, class_3854.field_17074);
        BiomeRegistry.registerVillagers(RuBiomes.JOSHUA_DESERT, class_3854.field_17071);
        BiomeRegistry.registerVillagers(RuBiomes.OUTBACK, class_3854.field_17074);
        BiomeRegistry.registerVillagers(RuBiomes.SAGUARO_DESERT, class_3854.field_17071);
        BiomeRegistry.registerVillagers(RuBiomes.STEPPE, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.ARID_MOUNTAINS, class_3854.field_17074);
        BiomeRegistry.registerVillagers(RuBiomes.HIGHLAND_FIELDS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.MOUNTAINS, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.PINE_SLOPES, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.TOWERING_CLIFFS, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.CHALK_CLIFFS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.GRASSY_BEACH, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.GRAVEL_BEACH, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.ALPHA_GROVE, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.COLD_RIVER, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.HYACINTH_DEEPS, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.MUDDY_RIVER, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.ROCKY_REEF, class_3854.field_17072);
        BiomeRegistry.registerVillagers(RuBiomes.ASHEN_WOODLAND, class_3854.field_17077);
        BiomeRegistry.registerVillagers(RuBiomes.TROPICAL_RIVER, class_3854.field_17072);
        BiomeRegistry.registerVillagers(RuBiomes.TROPICS, class_3854.field_17072);
        BiomeRegistry.registerVillagers(RuBiomes.COLD_BOREAL_TAIGA, class_3854.field_17075);
        BiomeRegistry.registerVillagers(RuBiomes.COLD_DECIDUOUS_FOREST, class_3854.field_17075);
        BiomeRegistry.registerVillagers(RuBiomes.FROZEN_PINE_TAIGA, class_3854.field_17075);
        BiomeRegistry.registerVillagers(RuBiomes.FROZEN_TUNDRA, class_3854.field_17075);
        BiomeRegistry.registerVillagers(RuBiomes.ICY_HEIGHTS, class_3854.field_17075);
        BiomeRegistry.registerVillagers(RuBiomes.SPIRES, class_3854.field_17075);
        BiomeRegistry.registerVillagers(RuBiomes.BIOSHROOM_CAVES, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.ANCIENT_DELTA, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.PRISMACHASM, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.REDSTONE_CAVES, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.SCORCHING_CAVES, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.BLACKSTONE_BASIN, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.INFERNAL_HOLT, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.GLISTERING_MEADOW, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.MYCOTOXIC_UNDERGROWTH, class_3854.field_17073);
        BiomeRegistry.registerVillagers(RuBiomes.REDSTONE_ABYSS, class_3854.field_17073);
    }

    private static void register(class_7891<class_1959> context, class_5321<class_1959> key, class_1959 biome) {
        context.method_46838(key, (Object)biome);
    }

    private static void registerVillagers(class_5321<class_1959> key, class_3854 type) {
        class_3854.field_17078.put(key, type);
    }
}

