/*
 * Decompiled with CFR 0.152.
 */
package io.github.uhq_games.regions_unexplored.config;

import io.github.uhq_games.regions_unexplored.world.level.biome.DefaultBiomes;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.api.ConfigGroup;
import me.lortseam.completeconfig.data.Config;
import me.lortseam.completeconfig.data.ConfigOptions;

@ConfigEntries(includeAll=true)
public class RegionsUnexploredConfig
extends Config {
    @ConfigEntry(requiresRestart=true, comment="Enable this before changing the other region config files. If disabled, RU will use builtin biome placement.")
    public static Boolean TOGGLE_CUSTOM_REGIONS = false;
    @ConfigEntry(requiresRestart=true, comment="Sets Terrablender region weight for the primary region.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFE)
    public static int REGION_PRIMARY_WEIGHT = 11;
    @ConfigEntry(requiresRestart=true, comment="Sets Terrablender region weight for the secondary region.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFE)
    public static int REGION_SECONDARY_WEIGHT = 8;
    @ConfigEntry(requiresRestart=true, comment="Sets Terrablender region weight for the Nether region.")
    @ConfigEntry.BoundedInteger(min=0, max=0x7FFFFFFE)
    public static int REGION_NETHER_WEIGHT = 14;

    public RegionsUnexploredConfig() {
        super(ConfigOptions.mod((String)"regions_unexplored"), new ConfigContainer[0]);
    }

    @ConfigContainer.Transitive
    @ConfigEntries(includeAll=true)
    public static class Client
    implements ConfigGroup {
        @ConfigEntry(comment="Enables/Disables the blue magnolia leave particle")
        public static Boolean TOGGLE_BLUE_MAGNOLIA_LEAVES_PARTICLE = true;
        @ConfigEntry(comment="Enables/Disables the white magnolia leave particle")
        public static Boolean TOGGLE_WHITE_MAGNOLIA_LEAVES_PARTICLE = true;
        @ConfigEntry(comment="Enables/Disables the pink magnolia leave particle")
        public static Boolean TOGGLE_PINK_MAGNOLIA_LEAVES_PARTICLE = true;
        @ConfigEntry(comment="Enables/Disables the enchanted birch leave particle")
        public static Boolean TOGGLE_ENCHANTED_BIRCH_LEAVES_PARTICLE = true;
        @ConfigEntry(comment="Enables/Disables the silver birch leave particle")
        public static Boolean TOGGLE_SILVER_BIRCH_LEAVES_PARTICLE = true;
        @ConfigEntry(comment="Enables/Disables the mauve leave particle")
        public static Boolean TOGGLE_MAUVE_LEAVES_PARTICLE = true;
        @ConfigEntry(comment="Enables/Disables the orange maple leave particle")
        public static Boolean TOGGLE_ORANGE_MAPLE_LEAVES_PARTICLE = true;
        @ConfigEntry(comment="Enables/Disables the red maple leave particle")
        public static Boolean TOGGLE_RED_MAPLE_LEAVES_PARTICLE = true;
    }

    @ConfigContainer.Transitive
    @ConfigEntries(includeAll=true)
    public static class Regions
    implements ConfigGroup {
        public String getComment() {
            return "NOTICE: Make sure 'TOGGLE_CUSTOM_REGIONS' is enabled in the common config or this config will have no effect on generation!\nIf you have custom regions enabled: to get future update biomes to spawn, you will either need to delete the config and let it regen, or add the new biomes manually.";
        }

        @ConfigContainer.Transitive
        @ConfigEntries(includeAll=true)
        public static class SecondaryRegions
        implements ConfigGroup {

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class OtherBiomes
            implements ConfigGroup {
                @ConfigEntry(nameKey="regions.sha_cli")
                public static String SHA_CLI = DefaultBiomes.SECONDARY_SHATTERED_CLIFF_BIOME.method_29177().toString();

                public String getNameKey() {
                    return "regions.otherBiomes";
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class IslandBiomes
            implements ConfigGroup {
                @ConfigEntry(nameKey="regions.icy")
                public static String ICY = DefaultBiomes.SECONDARY_ISLAND_BIOMES[0].method_29177().toString();
                @ConfigEntry(nameKey="regions.cold")
                public static String COLD = DefaultBiomes.SECONDARY_ISLAND_BIOMES[1].method_29177().toString();
                @ConfigEntry(nameKey="regions.neutral")
                public static String NEUTRAL = DefaultBiomes.SECONDARY_ISLAND_BIOMES[2].method_29177().toString();
                @ConfigEntry(nameKey="regions.warm")
                public static String WARM = DefaultBiomes.SECONDARY_ISLAND_BIOMES[3].method_29177().toString();
                @ConfigEntry(nameKey="regions.hot")
                public static String HOT = DefaultBiomes.SECONDARY_ISLAND_BIOMES[4].method_29177().toString();

                public String getNameKey() {
                    return "regions.islandBiomes";
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class UndergroundBiomes
            implements ConfigGroup {
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_1 = DefaultBiomes.SECONDARY_CAVE_BIOMES[0].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_2 = DefaultBiomes.SECONDARY_CAVE_BIOMES[1].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_3 = DefaultBiomes.SECONDARY_CAVE_BIOMES[2].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_4 = DefaultBiomes.SECONDARY_CAVE_BIOMES[3].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_5 = DefaultBiomes.SECONDARY_CAVE_BIOMES[4].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_6 = DefaultBiomes.SECONDARY_CAVE_BIOMES[5].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_7 = DefaultBiomes.SECONDARY_CAVE_BIOMES[6].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_8 = DefaultBiomes.SECONDARY_CAVE_BIOMES[7].method_29177().toString();

                public String getNameKey() {
                    return "regions.undergroundBiomes";
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class ShoreBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.shoreBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class StoneBeachBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.SECONDARY_STONE_SHORE_BIOMES[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.SECONDARY_STONE_SHORE_BIOMES[1].method_29177().toString();

                    public String getNameKey() {
                        return "regions.stoneBeachBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class BeachBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.SECONDARY_BEACH_BIOMES[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.SECONDARY_BEACH_BIOMES[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_BEACH_BIOMES[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.SECONDARY_BEACH_BIOMES[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.SECONDARY_BEACH_BIOMES[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.beachBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class OceanBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.oceanBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class Oceans
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.SECONDARY_OCEAN_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.SECONDARY_OCEAN_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_OCEAN_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.SECONDARY_OCEAN_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.SECONDARY_OCEAN_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.oceans";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class DeepOceans
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.SECONDARY_OCEAN_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.SECONDARY_OCEAN_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_OCEAN_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.SECONDARY_OCEAN_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.SECONDARY_OCEAN_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.deepOceans";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class SwampBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.swampBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SWAMP_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SWAMP_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SWAMP_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SWAMP_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SWAMP_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SWAMP_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SWAMP_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SWAMP_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SWAMP_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SWAMP_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SWAMP_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SWAMP_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SWAMP_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SWAMP_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SWAMP_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SWAMP_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class RiverBiomesVariants
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.riverBiomesVariants";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES_VARIANT[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class RiverBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.riverBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_RIVER_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_RIVER_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_RIVER_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_RIVER_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_RIVER_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class PeakBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.peakBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class PeakBiomesVariants
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.SECONDARY_PEAK_BIOMES_VARIANT[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.SECONDARY_PEAK_BIOMES_VARIANT[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PEAK_BIOMES_VARIANT[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.SECONDARY_PEAK_BIOMES_VARIANT[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.SECONDARY_PEAK_BIOMES_VARIANT[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.peakBiomesVariants";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class PeakBiomesGroup
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.SECONDARY_PEAK_BIOMES[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.SECONDARY_PEAK_BIOMES[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PEAK_BIOMES[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.SECONDARY_PEAK_BIOMES[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.SECONDARY_PEAK_BIOMES[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.peakBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class SlopeBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.slopeBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class SlopeBiomesVariants
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.SECONDARY_SLOPE_BIOMES_VARIANT[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.SECONDARY_SLOPE_BIOMES_VARIANT[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SLOPE_BIOMES_VARIANT[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.SECONDARY_SLOPE_BIOMES_VARIANT[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.SECONDARY_SLOPE_BIOMES_VARIANT[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.slopeBiomesVariants";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class SlopeBiomesGroup
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.SECONDARY_SLOPE_BIOMES[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.SECONDARY_SLOPE_BIOMES[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SLOPE_BIOMES[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.SECONDARY_SLOPE_BIOMES[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.SECONDARY_SLOPE_BIOMES[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.slopeBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class ShatteredBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.shatteredBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_SHATTERED_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class PlateauBiomeVariants
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.plateauBiomesVariants";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES_VARIANT[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class PlateauBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.plateauBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_PLATEAU_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class MiddleBiomeVariants
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.middleBiomesVariants";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES_VARIANT[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class MiddleBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.middleBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.SECONDARY_MIDDLE_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }
        }

        @ConfigContainer.Transitive
        @ConfigEntries(includeAll=true)
        public static class PrimaryRegions
        implements ConfigGroup {

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class OtherBiomes
            implements ConfigGroup {
                @ConfigEntry(nameKey="regions.sha_cli")
                public static String SHA_CLI = DefaultBiomes.PRIMARY_SHATTERED_CLIFF_BIOME.method_29177().toString();

                public String getNameKey() {
                    return "regions.otherBiomes";
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class IslandBiomes
            implements ConfigGroup {
                @ConfigEntry(nameKey="regions.icy")
                public static String ICY = DefaultBiomes.PRIMARY_ISLAND_BIOMES[0].method_29177().toString();
                @ConfigEntry(nameKey="regions.cold")
                public static String COLD = DefaultBiomes.PRIMARY_ISLAND_BIOMES[1].method_29177().toString();
                @ConfigEntry(nameKey="regions.neutral")
                public static String NEUTRAL = DefaultBiomes.PRIMARY_ISLAND_BIOMES[2].method_29177().toString();
                @ConfigEntry(nameKey="regions.warm")
                public static String WARM = DefaultBiomes.PRIMARY_ISLAND_BIOMES[3].method_29177().toString();
                @ConfigEntry(nameKey="regions.hot")
                public static String HOT = DefaultBiomes.PRIMARY_ISLAND_BIOMES[4].method_29177().toString();

                public String getNameKey() {
                    return "regions.islandBiomes";
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class UndergroundBiomes
            implements ConfigGroup {
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_1 = DefaultBiomes.PRIMARY_CAVE_BIOMES[0].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_2 = DefaultBiomes.PRIMARY_CAVE_BIOMES[1].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_3 = DefaultBiomes.PRIMARY_CAVE_BIOMES[2].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_4 = DefaultBiomes.PRIMARY_CAVE_BIOMES[3].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_5 = DefaultBiomes.PRIMARY_CAVE_BIOMES[4].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_6 = DefaultBiomes.PRIMARY_CAVE_BIOMES[5].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_7 = DefaultBiomes.PRIMARY_CAVE_BIOMES[6].method_29177().toString();
                @ConfigEntry(nameKey="regions.cave")
                public static String CAVE_8 = DefaultBiomes.PRIMARY_CAVE_BIOMES[7].method_29177().toString();

                public String getNameKey() {
                    return "regions.undergroundBiomes";
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class ShoreBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.shoreBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class StoneBeachBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.PRIMARY_STONE_SHORE_BIOMES[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.PRIMARY_STONE_SHORE_BIOMES[1].method_29177().toString();

                    public String getNameKey() {
                        return "regions.stoneBeachBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class BeachBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.PRIMARY_BEACH_BIOMES[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.PRIMARY_BEACH_BIOMES[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_BEACH_BIOMES[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.PRIMARY_BEACH_BIOMES[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.PRIMARY_BEACH_BIOMES[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.beachBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class OceanBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.oceanBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class Oceans
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.PRIMARY_OCEAN_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.PRIMARY_OCEAN_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_OCEAN_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.PRIMARY_OCEAN_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.PRIMARY_OCEAN_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.oceans";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class DeepOceans
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.PRIMARY_OCEAN_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.PRIMARY_OCEAN_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_OCEAN_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.PRIMARY_OCEAN_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.PRIMARY_OCEAN_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.deepOceans";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class SwampBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.swampBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SWAMP_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SWAMP_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SWAMP_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SWAMP_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SWAMP_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SWAMP_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SWAMP_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SWAMP_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SWAMP_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SWAMP_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SWAMP_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SWAMP_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SWAMP_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SWAMP_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SWAMP_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SWAMP_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class RiverBiomesVariants
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.riverBiomesVariants";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES_VARIANT[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class RiverBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.riverBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_RIVER_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_RIVER_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_RIVER_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_RIVER_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_RIVER_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class PeakBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.peakBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class PeakBiomesVariants
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.PRIMARY_PEAK_BIOMES_VARIANT[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.PRIMARY_PEAK_BIOMES_VARIANT[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PEAK_BIOMES_VARIANT[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.PRIMARY_PEAK_BIOMES_VARIANT[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.PRIMARY_PEAK_BIOMES_VARIANT[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.peakBiomesVariants";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class PeakBiomesGroup
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.PRIMARY_PEAK_BIOMES[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.PRIMARY_PEAK_BIOMES[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PEAK_BIOMES[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.PRIMARY_PEAK_BIOMES[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.PRIMARY_PEAK_BIOMES[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.peakBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class SlopeBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.slopeBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class SlopeBiomesVariants
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.PRIMARY_SLOPE_BIOMES_VARIANT[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.PRIMARY_SLOPE_BIOMES_VARIANT[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SLOPE_BIOMES_VARIANT[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.PRIMARY_SLOPE_BIOMES_VARIANT[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.PRIMARY_SLOPE_BIOMES_VARIANT[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.slopeBiomesVariants";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class SlopeBiomesGroup
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.icy")
                    public static String ICY = DefaultBiomes.PRIMARY_SLOPE_BIOMES[0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.cold")
                    public static String COLD = DefaultBiomes.PRIMARY_SLOPE_BIOMES[1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SLOPE_BIOMES[2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.warm")
                    public static String WARM = DefaultBiomes.PRIMARY_SLOPE_BIOMES[3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.hot")
                    public static String HOT = DefaultBiomes.PRIMARY_SLOPE_BIOMES[4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.slopeBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class ShatteredBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.shatteredBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_SHATTERED_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class PlateauBiomeVariants
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.plateauBiomesVariants";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES_VARIANT[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class PlateauBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.plateauBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_PLATEAU_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class MiddleBiomeVariants
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.middleBiomesVariants";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES_VARIANT[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }

            @ConfigContainer.Transitive
            @ConfigEntries(includeAll=true)
            public static class MiddleBiomes
            implements ConfigGroup {
                public String getNameKey() {
                    return "regions.middleBiomes";
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class HotBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[4][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[4][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[4][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[4][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[4][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.hotBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class WarmBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[3][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[3][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[3][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[3][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[3][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.warmBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class NeutralBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[2][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[2][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[2][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[2][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[2][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.neutralBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class CoolBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[1][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[1][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[1][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[1][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[1][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.coolBiomes";
                    }
                }

                @ConfigContainer.Transitive
                @ConfigEntries(includeAll=true)
                public static class IcyBiomes
                implements ConfigGroup {
                    @ConfigEntry(nameKey="regions.arid")
                    public static String ARID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[0][0].method_29177().toString();
                    @ConfigEntry(nameKey="regions.dry")
                    public static String DRY = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[0][1].method_29177().toString();
                    @ConfigEntry(nameKey="regions.neutral")
                    public static String NEUTRAL = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[0][2].method_29177().toString();
                    @ConfigEntry(nameKey="regions.wet")
                    public static String WET = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[0][3].method_29177().toString();
                    @ConfigEntry(nameKey="regions.humid")
                    public static String HUMID = DefaultBiomes.PRIMARY_MIDDLE_BIOMES[0][4].method_29177().toString();

                    public String getNameKey() {
                        return "regions.icyBiomes";
                    }
                }
            }
        }
    }

    @ConfigContainer.Transitive
    @ConfigEntries(includeAll=true)
    public static class WorldGenOptions
    implements ConfigGroup {

        @ConfigContainer.Transitive
        @ConfigEntries(includeAll=true)
        public static class BlockColorOptions
        implements ConfigGroup {
            @ConfigEntry(comment="Sets Eucalyptus colour transition size. Bigger number = bigger distance between colours.")
            @ConfigEntry.BoundedDouble(min=0.0, max=200.0)
            public static Double EUCALYPTUS_TRANSITION_SIZE = 25.0;
            @ConfigEntry(comment="Sets Eucalyptus colour saturation.")
            @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
            public static Double EUCALYPTUS_SATURATION = 0.5;
            @ConfigEntry(comment="Sets Eucalyptus colour brightness.")
            @ConfigEntry.BoundedDouble(min=0.0, max=1.0)
            public static Double EUCALYPTUS_BRIGHTNESS = 0.8;
        }

        @ConfigContainer.Transitive
        @ConfigEntries(includeAll=true)
        public static class SurfaceRules
        implements ConfigGroup {
            public static Boolean TOGGLE_CUSTOM_DIRTS = true;
        }
    }

    @ConfigContainer.Transitive
    @ConfigEntries(includeAll=true)
    public static class BiomeToggles
    implements ConfigGroup {

        @ConfigContainer.Transitive
        @ConfigEntries(includeAll=true)
        public static class NetherBiomes
        implements ConfigGroup {
            public static Boolean TOGGLE_BLACKSTONE_BASIN = true;
            public static Boolean TOGGLE_INFERNAL_HOLT = true;
            public static Boolean TOGGLE_GLISTERING_MEADOW = true;
            public static Boolean TOGGLE_MYCOTOXIC_UNDERGROWTH = true;
            public static Boolean TOGGLE_REDSTONE_ABYSS = true;
        }

        @ConfigContainer.Transitive
        @ConfigEntries(includeAll=true)
        public static class CaveBiomes
        implements ConfigGroup {
            public static Boolean TOGGLE_ANCIENT_DELTA = true;
            public static Boolean TOGGLE_BIOSHROOM_CAVES = true;
            public static Boolean TOGGLE_PRISMACHASM = true;
            public static Boolean TOGGLE_REDSTONE_CAVES = true;
            public static Boolean TOGGLE_SCORCHING_CAVES = true;
        }

        @ConfigContainer.Transitive
        @ConfigEntries(includeAll=true)
        public static class OverworldBiomes
        implements ConfigGroup {
            public static Boolean TOGGLE_ALPHA_GROVE = true;
            public static Boolean TOGGLE_ARID_MOUNTAINS = true;
            public static Boolean TOGGLE_AUTUMNAL_MAPLE_FOREST = true;
            public static Boolean TOGGLE_BAMBOO_FOREST = true;
            public static Boolean TOGGLE_BAOBAB_SAVANNA = true;
            public static Boolean TOGGLE_BARLEY_FIELDS = true;
            public static Boolean TOGGLE_BAYOU = true;
            public static Boolean TOGGLE_BLACKWOOD_TAIGA = true;
            public static Boolean TOGGLE_BOREAL_TAIGA = true;
            public static Boolean TOGGLE_CHALK_CLIFFS = true;
            public static Boolean TOGGLE_CLOVER_PLAINS = true;
            public static Boolean TOGGLE_COLD_BOREAL_TAIGA = true;
            public static Boolean TOGGLE_COLD_DECIDUOUS_FOREST = true;
            public static Boolean TOGGLE_COLD_RIVER = true;
            public static Boolean TOGGLE_DECIDUOUS_FOREST = true;
            public static Boolean TOGGLE_DRY_BUSHLAND = true;
            public static Boolean TOGGLE_EUCALYPTUS_FOREST = true;
            public static Boolean TOGGLE_FEN = true;
            public static Boolean TOGGLE_FLOWER_FIELDS = true;
            public static Boolean TOGGLE_FROZEN_PINE_TAIGA = true;
            public static Boolean TOGGLE_FROZEN_TUNDRA = true;
            public static Boolean TOGGLE_FUNGAL_FEN = true;
            public static Boolean TOGGLE_GOLDEN_BOREAL_TAIGA = true;
            public static Boolean TOGGLE_GRASSLAND = true;
            public static Boolean TOGGLE_GRASSY_BEACH = true;
            public static Boolean TOGGLE_GRAVEL_BEACH = true;
            public static Boolean TOGGLE_HIGHLAND_FIELDS = true;
            public static Boolean TOGGLE_HYACINTH_DEEPS = true;
            public static Boolean TOGGLE_ICY_DESERT = true;
            public static Boolean TOGGLE_ICY_HEIGHTS = true;
            public static Boolean TOGGLE_JOSHUA_DESERT = true;
            public static Boolean TOGGLE_MAPLE_FOREST = true;
            public static Boolean TOGGLE_MAGNOLIA_WOODLAND = true;
            public static Boolean TOGGLE_MARSH = true;
            public static Boolean TOGGLE_MAUVE_HILLS = true;
            public static Boolean TOGGLE_MEADOW = true;
            public static Boolean TOGGLE_MOUNTAINS = true;
            public static Boolean TOGGLE_MUDDY_RIVER = true;
            public static Boolean TOGGLE_OLD_GROWTH_BAYOU = true;
            public static Boolean TOGGLE_ORCHARD = true;
            public static Boolean TOGGLE_OUTBACK = true;
            public static Boolean TOGGLE_PINE_SLOPES = true;
            public static Boolean TOGGLE_PINE_TAIGA = true;
            public static Boolean TOGGLE_POPPY_FIELDS = true;
            public static Boolean TOGGLE_PRAIRIE = true;
            public static Boolean TOGGLE_PUMPKIN_FIELDS = true;
            public static Boolean TOGGLE_RAINFOREST = true;
            public static Boolean TOGGLE_REDWOODS = true;
            public static Boolean TOGGLE_ROCKY_REEF = true;
            public static Boolean TOGGLE_SAGUARO_DESERT = true;
            public static Boolean TOGGLE_SHRUBLAND = true;
            public static Boolean TOGGLE_SILVER_BIRCH_FOREST = true;
            public static Boolean TOGGLE_ASHEN_WOODLAND = true;
            public static Boolean TOGGLE_SPARSE_RAINFOREST = true;
            public static Boolean TOGGLE_SPARSE_REDWOODS = true;
            public static Boolean TOGGLE_SPIRES = true;
            public static Boolean TOGGLE_STEPPE = true;
            public static Boolean TOGGLE_TEMPERATE_GROVE = true;
            public static Boolean TOGGLE_TOWERING_CLIFFS = true;
            public static Boolean TOGGLE_TROPICS = true;
            public static Boolean TOGGLE_TROPICAL_RIVER = true;
            public static Boolean TOGGLE_WILLOW_FOREST = true;
        }
    }
}

