/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.easiervillagertrading;

import de.guntram.mcmod.fabrictools.ConfigChangedEvent;
import de.guntram.mcmod.fabrictools.Configuration;
import de.guntram.mcmod.fabrictools.ModConfigurationHandler;
import java.io.File;

public class ConfigurationHandler
implements ModConfigurationHandler {
    private static ConfigurationHandler instance;
    private Configuration config;
    private String configFileName;
    private boolean swapShiftBehavior;

    public static ConfigurationHandler getInstance() {
        if (instance == null) {
            instance = new ConfigurationHandler();
        }
        return instance;
    }

    public void load(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile);
            this.configFileName = configFile.getPath();
            this.loadConfig();
        }
    }

    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("easiervillagertrading")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.swapShiftBehavior = this.config.getBoolean("easiervillagertrading.config.swapshift", 0, false, "easiervillagertrading.config.tt.swapshift");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static String getConfigFileName() {
        return ConfigurationHandler.getInstance().configFileName;
    }

    public static boolean isShiftSwapped() {
        return ConfigurationHandler.getInstance().swapShiftBehavior;
    }
}

