/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commandconfig.impl.builders;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.kikugie.commandconfig.Reference;
import dev.kikugie.commandconfig.api.builders.OptionBuilder;
import dev.kikugie.commandconfig.api.option.access.OptionValueAccess;
import dev.kikugie.commandconfig.impl.builders.CommandNodeImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class OptionBuilderImpl<T, S extends class_2172>
extends CommandNodeImpl<S>
implements OptionBuilder<T, S> {
    protected final List<Consumer<LiteralArgumentBuilder<S>>> extraNodes = new ArrayList<Consumer<LiteralArgumentBuilder<S>>>();
    protected OptionValueAccess<T, S> valueAccess;

    public OptionBuilderImpl(String name, Class<S> type) {
        super(name, type);
        Validate.matchesPattern((CharSequence)name, (String)"^[a-zA-Z0-9-_]+$", (String)Reference.optionError(name, "Invalid name for %s: \"%s\".\nOption and category names can only contain letters, numbers, dashes and underscores without spaces."), (Object[])new Object[0]);
    }

    @Override
    public OptionBuilder<T, S> node(@NotNull Consumer<LiteralArgumentBuilder<S>> node) {
        Validate.notNull(node, (String)Reference.optionError(this.name, "Custom node can't be null for %s \"%s\""), (Object[])new Object[0]);
        this.extraNodes.add(node);
        return this;
    }

    @Override
    public OptionBuilder<T, S> valueAccess(@NotNull OptionValueAccess<T, S> access) {
        Validate.notNull(access, (String)Reference.optionError(this.name, "Value access can't be null for %s \"%s\""), (Object[])new Object[0]);
        this.valueAccess = access.name(this.name);
        return this;
    }

    @Override
    public OptionBuilder<T, S> valueAccess(@NotNull Function<CommandContext<S>, class_2561> getter, @NotNull BiFunction<CommandContext<S>, T, class_2561> setter) {
        this.valueAccess = new OptionValueAccess<T, S>(this.name, getter, setter);
        return this;
    }

    @Override
    public OptionBuilder<T, S> valueAccess(@NotNull Supplier<class_2561> getter, @NotNull Function<T, class_2561> setter) {
        this.valueAccess = new OptionValueAccess(this.name, context -> (class_2561)getter.get(), (context, t) -> (class_2561)setter.apply(t));
        return this;
    }

    @Override
    public OptionBuilder<T, S> listener(@NotNull BiConsumer<String, T> listener) {
        Validate.notNull(listener, (String)Reference.optionError(this.name, "Listener can't be null for %s \"%s\""), (Object[])new Object[0]);
        Validate.notNull((Object)this.printFunc, (String)Reference.optionError(this.name, "No value access for %s \"%s\".\nAdd it using `valueAccess()` before adding listeners."), (Object[])new Object[0]);
        this.valueAccess.addListener(listener);
        return this;
    }

    @Override
    public OptionBuilder<T, S> printFunc(@NotNull BiFunction<CommandContext<S>, class_2561, Integer> printFunc) {
        super.printFunc(printFunc);
        return this;
    }

    @Override
    public OptionBuilder<T, S> saveFunc(@NotNull Runnable saveFunc) {
        super.saveFunc(saveFunc);
        return this;
    }

    @Override
    public OptionBuilder<T, S> helpFunc(@NotNull Supplier<class_2561> helpFunc) {
        super.helpFunc(helpFunc);
        return this;
    }

    @Override
    @Nullable
    public LiteralArgumentBuilder<S> buildHelpFunc() {
        Validate.notNull((Object)this.printFunc, (String)Reference.optionError(this.name, "No print function for %s \"%s\".\nAdd it using `printFunc` on current or any higher node."), (Object[])new Object[0]);
        if (this.helpFunc == null) {
            return null;
        }
        LiteralArgumentBuilder option = LiteralArgumentBuilder.literal((String)this.name);
        return (LiteralArgumentBuilder)option.executes(this::help);
    }
}

